﻿/*
	DigitalFlipbook Source Code License Agreement
	Copyright(c) 2008 Mark Walters. All rights reserved.
		
	Please read this Source Code License Agreement carefully before using
	the source code.
		
	Mark Walters grants to you a perpetual, worldwide, non-exclusive,
	no-charge, royalty-free, irrevocable copyright license, to reproduce,
	prepare derivative works of, publicly display, publicly perform, and
	distribute this source code and such derivative works in source or
	object code form without any attribution requirements.
	
	The names "Mark Walters" and "DigitalFlipbook" must not be used to endorse or promote products
	derived from the source code without prior written permission.
		
	You agree to indemnify, hold harmless and defend Mark Walters from and
	against any loss, damage, claims or lawsuits, including attorney's
	fees that arise or result from your use or distribution of the source
	code.
		
	THIS SOURCE CODE IS PROVIDED "AS IS" AND "WITH ALL FAULTS", WITHOUT
	ANY TECHNICAL SUPPORT OR ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING,
	BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. ALSO, THERE IS NO WARRANTY OF
	NON-INFRINGEMENT, TITLE OR QUIET ENJOYMENT. IN NO EVENT SHALL MARK WALTERS
	OR HIS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
	OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
	WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
	OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOURCE CODE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package com.digitalflipbook.geoglobe
{
	import flash.events.Event;
	
	public class GeocoderEvent extends Event
	{
		public static const GEOCODER_SUCCESS:String = "geocoderSuccess";
		public static const GEOCODER_FAILURE:String = "geocoderFailure";
		public static const GEOCODER_UNAVAILABLE:String = "geocoderUnavailable";
		
		private var _location:String;
		private var _latitude:Number;
		private var _longitude:Number;
		
		public function GeocoderEvent( type:String, location:String=null, latitude:Number=0, longitude:Number=0 )
		{
			super( type );
			
			this.location = location;
			this.latitude = latitude;
			this.longitude = longitude;
		}
		
		public function set location(value:String):void
		{
			_location = value;
		}
		
		public function get location():String
		{
			return(_location);
		}
		
		public function set longitude(value:Number):void
		{
			_longitude = value;
		}
		
		public function get longitude():Number
		{
			return(_longitude);
		}
		
		public function set latitude(value:Number):void
		{
			_latitude = value;
		}
		
		public function get latitude():Number
		{
			return(_latitude);
		}
	}
}