/*
	DigitalFlipbook Source Code License Agreement
	Copyright(c) 2008 Mark Walters. All rights reserved.
		
	Please read this Source Code License Agreement carefully before using
	the source code.
		
	Mark Walters grants to you a perpetual, worldwide, non-exclusive,
	no-charge, royalty-free, irrevocable copyright license, to reproduce,
	prepare derivative works of, publicly display, publicly perform, and
	distribute this source code and such derivative works in source or
	object code form without any attribution requirements.
	
	The names "Mark Walters" and "DigitalFlipbook" must not be used to endorse or promote products
	derived from the source code without prior written permission.
		
	You agree to indemnify, hold harmless and defend Mark Walters from and
	against any loss, damage, claims or lawsuits, including attorney's
	fees that arise or result from your use or distribution of the source
	code.
		
	THIS SOURCE CODE IS PROVIDED "AS IS" AND "WITH ALL FAULTS", WITHOUT
	ANY TECHNICAL SUPPORT OR ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING,
	BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. ALSO, THERE IS NO WARRANTY OF
	NON-INFRINGEMENT, TITLE OR QUIET ENJOYMENT. IN NO EVENT SHALL MARK WALTERS
	OR HIS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
	OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
	WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
	OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOURCE CODE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package com.digitalflipbook.geoglobe
{
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	
	public class Marker extends DisplayObject3D
	{
		private var cube:Cube;
		private var _width:Number = 12;
		private var _height:Number = 12;
		private var _depth:Number = 34;
		private var _frontMaterial:ColorMaterial = new ColorMaterial( 0xff7200 );
		private var _backMaterial:ColorMaterial = new ColorMaterial( 0xff7200 );
		private var _leftMaterial:ColorMaterial = new ColorMaterial( 0xff6100 );
		private var _rightMaterial:ColorMaterial = new ColorMaterial( 0xff6100 );
		private var _topMaterial:ColorMaterial = new ColorMaterial( 0xff4f00 );
		private var _bottomMaterial:ColorMaterial = new ColorMaterial( 0xff4f00 );
		
		public function Marker()
		{
			super();
			
			var materials:MaterialsList = new MaterialsList( { front:_frontMaterial, back:_backMaterial, left:_leftMaterial, right:_rightMaterial, top:_topMaterial, bottom:_bottomMaterial } );
			cube = new Cube( materials, width, depth, height );
			cube.geometry.vertices[0].x -= 4;
			cube.geometry.vertices[0].y += 4;
			cube.geometry.vertices[1].x -= 4;
			cube.geometry.vertices[1].y -= 4;
			cube.geometry.vertices[2].x += 4;
			cube.geometry.vertices[2].y += 4;
			cube.geometry.vertices[3].x += 4;
			cube.geometry.vertices[3].y -= 4;
			addChild( cube );
			cube.moveBackward( depth / 2 );
		}
		
		public function get width():Number
		{
			return _width;
		}
		
		public function get height():Number
		{
			return _height;
		}
		
		public function get depth():Number
		{
			return _depth;
		}
		
	}
}