/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flex2.compiler.io.VirtualFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Assets {
    private Map assets;
    private Map assetPaths;
    private Map assetCreationTimes;
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    };

    public void add(String className, VirtualFile path, DefineTag defineTag, long timeStamp) {
        if (this.assets == null) {
            this.assets = new HashMap(4);
            this.assetPaths = new HashMap(4);
            this.assetCreationTimes = new HashMap(4);
        }
        this.assets.put(className, defineTag);
        if (path != null) {
            this.assetPaths.put(className, path);
        }
        if (timeStamp != -1L) {
            this.assetCreationTimes.put(className, new Long(timeStamp));
        }
    }

    public void add(String className, DefineTag tag) {
        if (this.assets == null) {
            this.assets = new HashMap(4);
            this.assetPaths = new HashMap(4);
            this.assetCreationTimes = new HashMap(4);
        }
        this.assets.put(className, tag);
    }

    public void addAll(Assets ass) {
        if (ass.assets == null) {
            return;
        }
        if (this.assets == null) {
            this.assets = new HashMap(4);
            this.assetPaths = new HashMap(4);
            this.assetCreationTimes = new HashMap(4);
        }
        this.assets.putAll(ass.assets);
        this.assetPaths.putAll(ass.assetPaths);
        this.assetCreationTimes.putAll(ass.assetCreationTimes);
    }

    public int count() {
        return this.assets == null ? 0 : this.assets.size();
    }

    public Iterator names() {
        return this.assets == null ? EMPTY_ITERATOR : this.assets.keySet().iterator();
    }

    public DefineTag get(String className) {
        return this.assets == null ? null : (DefineTag)this.assets.get(className);
    }

    public Iterator iterator() {
        return this.assets == null ? EMPTY_ITERATOR : this.assets.entrySet().iterator();
    }

    public VirtualFile getPath(String className) {
        return this.assetPaths == null ? null : (VirtualFile)this.assetPaths.get(className);
    }

    public Iterator paths() {
        return this.assetPaths == null ? EMPTY_ITERATOR : this.assetPaths.entrySet().iterator();
    }

    public long getCreationTime(String className) {
        if (this.assetCreationTimes == null) {
            return 0L;
        }
        Long ts = (Long)this.assetCreationTimes.get(className);
        return ts != null ? ts : 0L;
    }

    public Iterator creationTimes() {
        return this.assetCreationTimes == null ? EMPTY_ITERATOR : this.assetCreationTimes.entrySet().iterator();
    }

    public boolean isUpdated(String className, long timeStamp) {
        if (this.assetCreationTimes != null) {
            if (this.assetCreationTimes.containsKey(className)) {
                return timeStamp != (Long)this.assetCreationTimes.get(className);
            }
            return true;
        }
        return true;
    }

    public boolean isUpdated() {
        if (this.assetPaths != null) {
            Iterator i = this.assetPaths.keySet().iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                VirtualFile f = (VirtualFile)this.assetPaths.get(className);
                long timestamp = (Long)this.assetCreationTimes.get(className);
                if (timestamp == f.getLastModified()) continue;
                return true;
            }
        }
        return false;
    }

    public List getFonts() {
        LinkedList<DefineTag> fonts = new LinkedList<DefineTag>();
        if (this.assets != null) {
            Iterator it = this.assets.values().iterator();
            while (it.hasNext()) {
                DefineTag tag = (DefineTag)it.next();
                if (!(tag instanceof DefineFont)) continue;
                fonts.add(tag);
            }
        }
        return fonts;
    }

    public boolean exists(String name) {
        return this.assetPaths != null && this.assetPaths.containsValue(name);
    }

    public int size() {
        return this.assets == null ? 0 : this.assets.size();
    }
}

