/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.swf.tags.DefineTag;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.swc.SwcPathResolver;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilerSwcContext {
    private boolean locked = false;
    private SwcGroup swcGroup;
    private QNameMap def2source = new QNameMap();
    private QNameMap def2script = new QNameMap();
    private Set packageNames = new HashSet();
    private Set externs = new HashSet();
    private Set includes = new HashSet();
    private Map files = new HashMap();
    private int loaded = 0;
    private List themeStyles = new LinkedList();
    private List errlocations = new LinkedList();
    private StringBuffer ts = new StringBuffer();
    private boolean fullCompile;
    private boolean enableIncrementalCompile;

    public CompilerSwcContext() {
        this(true, false);
    }

    public CompilerSwcContext(boolean fullCompile, boolean enableIncrementalCompile) {
        this.fullCompile = fullCompile;
        this.enableIncrementalCompile = enableIncrementalCompile;
    }

    public int load(VirtualFile[] libPath, VirtualFile[] rslPath, VirtualFile[] themeFiles, VirtualFile[] includeLibraries, NameMappings mappings, SwcCache swcCache) {
        SwcGroup libGroup = null;
        if (libPath != null && libPath.length > 0) {
            libGroup = swcCache.getSwcGroup(libPath);
            this.addTimeStamps(libGroup);
        }
        SwcGroup rslGroup = null;
        if (rslPath != null && rslPath.length > 0) {
            rslGroup = swcCache.getSwcGroup(rslPath);
            this.externs.addAll(rslGroup.getScriptMap().keySet());
            this.addTimeStamps(rslGroup);
        }
        SwcGroup includeGroup = null;
        if (includeLibraries != null && includeLibraries.length > 0) {
            includeGroup = swcCache.getSwcGroup(includeLibraries);
            this.includes.addAll(includeGroup.getScriptMap().keySet());
            this.addTimeStamps(includeGroup);
            this.files.putAll(includeGroup.getFiles());
        }
        LinkedList<SwcGroup> groupList = new LinkedList<SwcGroup>();
        groupList.add(libGroup);
        groupList.add(rslGroup);
        groupList.add(includeGroup);
        for (int i = 0; themeFiles != null && i < themeFiles.length; ++i) {
            if (themeFiles[i].getName().endsWith(".css")) {
                this.themeStyles.add(themeFiles[i]);
                this.ts.append(themeFiles[i].getLastModified());
                continue;
            }
            SwcGroup tmpThemeGroup = swcCache.getSwcGroup(new VirtualFile[]{themeFiles[i]});
            groupList.add(tmpThemeGroup);
            Iterator it = tmpThemeGroup.getFiles().values().iterator();
            while (it.hasNext()) {
                VirtualFile f = (VirtualFile)it.next();
                this.ts.append(f.getLastModified());
                if (!f.getName().endsWith(".css")) continue;
                this.themeStyles.add(f);
            }
        }
        this.swcGroup = swcCache.getSwcGroup(groupList);
        if (this.swcGroup == null) {
            return 0;
        }
        this.toQNameMap(this.swcGroup.getScriptMap());
        Set qnames = this.swcGroup.getQNames();
        Iterator iterator = qnames.iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            this.packageNames.add(qName.getNamespace());
        }
        ThreadLocalToolkit.getPathResolver().addSinglePathResolver(new SwcPathResolver(this.swcGroup.getFiles()));
        mappings.addMappings(this.swcGroup.getNameMappings());
        int num = this.swcGroup.getNumberLoaded();
        this.loaded += num;
        return num;
    }

    public VirtualFile getFile(String name) {
        return this.swcGroup.getFile(name);
    }

    private void addTimeStamps(SwcGroup libGroup) {
        if (libGroup != null) {
            List lastModified = libGroup.getSwcTimes();
            int size = lastModified.size();
            for (int i = 0; i < size; ++i) {
                this.ts.append(lastModified.get(i));
            }
        }
    }

    public List getSources(SymbolTable symbolTable) {
        ArrayList<Source> sources = new ArrayList<Source>();
        Iterator i = this.def2script.keySet().iterator();
        while (i.hasNext()) {
            QName qName = new QName((String)i.next());
            Source source = this.getSource(qName.getNamespace(), qName.getLocalPart());
            sources.add(source);
            symbolTable.registerQName(qName, source);
        }
        return sources;
    }

    public Source getSource(String namespaceURI, String localPart) {
        if (this.def2source.containsKey(namespaceURI, localPart)) {
            return (Source)this.def2source.get(namespaceURI, localPart);
        }
        SwcScript script = (SwcScript)this.def2script.get(namespaceURI, localPart);
        if (script == null) {
            return null;
        }
        String loc = script.getLibrary().getSwcLocation();
        InMemoryFile f = new InMemoryFile(script.getDoABC().abc, loc + "(" + script.getName() + ")", "application/x-actionscript-bytecode", script.getLastModified());
        Source s = loc.endsWith("playerglobal.swc") || loc.endsWith("apolloglobal.swc") || loc.endsWith("avmplus.swc") ? new Source((VirtualFile)f, "", script, true, false, false) : new Source((VirtualFile)f, "", script, false, false, false);
        s.setPathResolver(null);
        CompilationUnit u = s.newCompilationUnit(null, new Context());
        Iterator i = script.getDefinitionIterator();
        while (i.hasNext()) {
            u.topLevelDefinitions.add(new QName((String)i.next()));
        }
        SwcDependencySet set = script.getDependencySet();
        Iterator i2 = set.getDependencyIterator("i");
        while (i2 != null && i2.hasNext()) {
            u.inheritance.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("s");
        while (i2 != null && i2.hasNext()) {
            u.types.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("n");
        while (i2 != null && i2.hasNext()) {
            u.namespaces.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("e");
        while (i2 != null && i2.hasNext()) {
            u.expressions.add(new MultiName((String)i2.next()));
        }
        i2 = script.getSymbolClasses().iterator();
        while (i2.hasNext()) {
            u.expressions.add(new MultiName((String)i2.next()));
        }
        HashMap misc = script.getMiscData();
        if (misc == null) {
            if (this.enableIncrementalCompile) {
                misc = new HashMap(4);
                script.setMiscData(misc);
            }
        } else if (!this.fullCompile && misc.containsKey(CompilationUnit.COMPILATION_UNIT)) {
            CompilationUnit oldUnit = (CompilationUnit)misc.get(CompilationUnit.COMPILATION_UNIT);
            Source.copyMetaData(oldUnit, u);
        }
        u.getContext().setAttribute("SwcScript.misc", misc);
        Iterator i3 = script.getDefinitionIterator();
        while (i3.hasNext()) {
            String name = (String)i3.next();
            DefineTag tag = script.getLibrary().getSymbol(name);
            if (tag == null) continue;
            u.getAssets().add(name, tag);
        }
        this.def2source.put(namespaceURI, localPart, s);
        if (loc.trim().length() < loc.length()) {
            this.errlocations.add(loc.trim());
            return null;
        }
        return s;
    }

    public int getNumberLoaded() {
        return this.loaded;
    }

    public Set getExterns() {
        return this.externs;
    }

    public Set getIncludes() {
        return this.includes;
    }

    public Map getIncludeFiles() {
        return this.files;
    }

    public boolean hasPackage(String packageName) {
        return this.packageNames.contains(packageName);
    }

    public boolean hasDefinition(QName qName) {
        return this.def2script.get(qName.getNamespace(), qName.getLocalPart()) != null;
    }

    public List getThemeStyleSheets() {
        return this.themeStyles;
    }

    public List errorLocations() {
        return this.errlocations;
    }

    public int checksum() {
        byte[] b = null;
        try {
            b = this.ts.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            b = this.ts.toString().getBytes();
        }
        int checksum = 0;
        for (int i = 0; i < b.length; ++i) {
            checksum += b[i];
        }
        return checksum;
    }

    public void close() {
        if (!this.locked && this.swcGroup != null) {
            this.swcGroup.close();
        }
    }

    public void setLock(boolean lock) {
        this.locked = lock;
    }

    private void toQNameMap(Map scriptMap) {
        Iterator i = scriptMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = scriptMap.get(key);
            this.def2script.put(new QName(key), value);
        }
    }
}

