/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SourcePath {
    private static final Object NO_DIR;
    private final List directories = new LinkedList();
    private final String[] mimeTypes;
    private final Map sources;
    private boolean allowSourcePathOverlap;
    private final Set hits;
    private final Set misses;
    private final HashMap dirs;
    private final List warnings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourcePath(VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes, boolean allowSourcePathOverlap) {
        this(mimeTypes, allowSourcePathOverlap);
        SourcePath.addApplicationParentToSourcePath(appPath, classPath, this.directories);
        this.addPathElements(classPath);
    }

    static void addApplicationParentToSourcePath(VirtualFile appPath, VirtualFile[] classPath, List directories) {
        File f;
        if (appPath != null && (f = FileUtil.openFile(appPath.getParent())) != null && f.isDirectory() && FileUtil.isSubdirectoryOf(appPath.getParent(), classPath) == -1) {
            directories.add(f);
        }
    }

    public SourcePath(String[] mimeTypes, boolean allowSourcePathOverlap) {
        this.mimeTypes = mimeTypes;
        this.allowSourcePathOverlap = allowSourcePathOverlap;
        this.sources = new HashMap();
        this.hits = new HashSet();
        this.misses = new HashSet(1024);
        this.dirs = new HashMap();
        this.warnings = new ArrayList(5);
    }

    public void addPathElements(VirtualFile[] classPath) {
        SourcePath.addPathElements(classPath, this.directories, this.allowSourcePathOverlap, this.warnings);
    }

    static void addPathElements(VirtualFile[] classPath, List directories, boolean allowSourcePathOverlap, List warnings) {
        int length;
        boolean badPaths = false;
        int n = length = classPath == null ? 0 : classPath.length;
        for (int i = 0; i < length; ++i) {
            String dirPath;
            int index;
            String path = classPath[i].getName();
            File f = FileUtil.openFile(path);
            if (f == null || !f.isDirectory()) continue;
            if (!allowSourcePathOverlap && !badPaths && (index = FileUtil.isSubdirectoryOf(f, directories)) != -1 && SourcePath.checkValidPackageName(path, dirPath = ((File)directories.get(index)).getAbsolutePath())) {
                warnings.add(new ClasspathOverlap(path, dirPath));
                badPaths = true;
            }
            directories.add(f);
        }
    }

    private static boolean checkValidPackageName(String path1, String path2) {
        if (path1.equals(path2)) {
            return true;
        }
        String packagePath = path1.length() > path2.length() ? path1.substring(path2.length()) : path2.substring(path1.length());
        StringTokenizer t = new StringTokenizer(packagePath, File.separator);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (TextParser.isValidIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    public boolean hasPackage(String packageName) {
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = (File)this.directories.get(i);
            if (!this.hasDirectory(d, packageName)) continue;
            return true;
        }
        return false;
    }

    protected String constructClassName(String namespaceURI, String localPart) {
        return namespaceURI.length() == 0 ? localPart : new StringBuffer(namespaceURI.length() + localPart.length() + 1).append(namespaceURI).append(":").append(localPart).toString();
    }

    public boolean hasDefinition(QName qName) {
        String className = this.constructClassName(qName.getNamespace(), qName.getLocalPart());
        if (this.misses.contains(className)) {
            return false;
        }
        if (this.hits.contains(className)) {
            return true;
        }
        String p = className.replace(':', '.').replace('.', File.separatorChar);
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = (File)this.directories.get(i);
            try {
                File f = this.findFile(d, p, this.mimeTypes);
                if (f == null) continue;
                this.hits.add(className);
                return true;
            }
            catch (CompilerException ex) {
                // empty catch block
            }
        }
        this.misses.add(className);
        return false;
    }

    public Source findSource(String namespaceURI, String localPart) throws CompilerException {
        if (!($assertionsDisabled || localPart.indexOf(46) == -1 && localPart.indexOf(47) == -1 && localPart.indexOf(58) == -1)) {
            throw new AssertionError((Object)("findSource(" + namespaceURI + "," + localPart + ") has bad localPart"));
        }
        String className = this.constructClassName(namespaceURI, localPart);
        return this.findSource(className, namespaceURI, localPart);
    }

    protected Source findSource(String className, String namespaceURI, String localPart) throws CompilerException {
        CompilationUnit u;
        if (this.misses.contains(className)) {
            return null;
        }
        Source s = null;
        if (!this.sources.containsKey(className)) {
            String p = className.replace(':', '.').replace('.', File.separatorChar);
            int size = this.directories.size();
            for (int i = 0; i < size; ++i) {
                File d = (File)this.directories.get(i);
                File f = this.findFile(d, p, this.mimeTypes);
                if (f == null) continue;
                s = this.newSource(f, d, namespaceURI);
                this.sources.put(className, s);
                return s;
            }
        }
        CompilationUnit compilationUnit = u = (s = (Source)this.sources.get(className)) != null ? s.getCompilationUnit() : null;
        if (s != null && !s.exists()) {
            this.sources.remove(className);
            s = null;
        }
        if (s != null && u != null && u.topLevelDefinitions.size() == 1 && !u.topLevelDefinitions.contains(namespaceURI, localPart)) {
            String realName = u.topLevelDefinitions.first().toString();
            this.sources.put(realName, s);
            this.misses.remove(realName);
            s = null;
            u = null;
        }
        if ((s == null || (u == null || u.isDone()) && !s.isUpdated()) && s != null && u != null) {
            s = s.copy();
            if (!$assertionsDisabled && s == null) {
                throw new AssertionError();
            }
        }
        if (s == null) {
            this.misses.add(className);
        }
        return s;
    }

    private String constructRelativePath(Source s) {
        String relativePath = s.getName().substring(s.getPathRoot().getName().length() + 1);
        int length = this.mimeTypes.length;
        for (int k = 0; k < length; ++k) {
            String ext = MimeMappings.getExtension(this.mimeTypes[k]);
            if (!relativePath.endsWith(ext)) continue;
            relativePath = relativePath.substring(0, relativePath.length() - ext.length());
            return relativePath;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    boolean checkPreference(Source s) {
        if (!$assertionsDisabled && s.getOwner() != this) {
            throw new AssertionError();
        }
        String relativePath = this.constructRelativePath(s);
        String pathRoot = s.getPathRoot().getName();
        if (relativePath == null) {
            return true;
        }
        boolean thisPath = false;
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = (File)this.directories.get(i);
            File f = null;
            if (pathRoot.equals(FileUtil.getCanonicalPath(d))) {
                thisPath = true;
            }
            try {
                f = this.findFile(d, relativePath, this.mimeTypes);
            }
            catch (CompilerException ex) {
                this.removeSource(s);
                return false;
            }
            if (f == null || thisPath) continue;
            this.removeSource(s);
            return false;
        }
        return true;
    }

    public void removeSource(Source s) {
        Iterator i = this.sources.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getValue() != s) continue;
            i.remove();
            break;
        }
    }

    protected Source newSource(File file, File directory, String namespaceURI) {
        return new Source((VirtualFile)new LocalFile(file), new LocalFile(directory), namespaceURI.replace('.', '/'), this, false, false);
    }

    public void clearCache() {
        this.hits.clear();
        this.misses.clear();
        this.dirs.clear();
    }

    private File findFile(File directory, String relativePath, String[] mimeTypes) throws CompilerException {
        File found = null;
        int length = mimeTypes.length;
        for (int k = 0; k < length; ++k) {
            File f = this.findFile(directory, relativePath, mimeTypes[k]);
            if (f != null && found == null) {
                found = f;
                continue;
            }
            if (f == null) continue;
            throw new MoreThanOneComponentOfTheSameName(found.getAbsolutePath(), f.getAbsolutePath());
        }
        return found;
    }

    private File findFile(File directory, String relativePath, String mimeType) {
        String fullPath = directory.getPath() + File.separator + relativePath;
        int lastSlash = fullPath.lastIndexOf(File.separator);
        String dir = null;
        if (lastSlash != -1 && this.dirs.get(dir = fullPath.substring(0, lastSlash)) == NO_DIR) {
            return null;
        }
        String path = relativePath + MimeMappings.getExtension(mimeType);
        File f = FileUtil.openFile(directory, path);
        if (f != null && f.isFile() && FileUtil.getCanonicalPath(f).endsWith(path)) {
            return f;
        }
        if (f != null && dir != null && !this.dirs.containsKey(dir)) {
            File p = f.getParentFile();
            this.dirs.put(dir, p != null && p.isDirectory() ? dir : NO_DIR);
        }
        return null;
    }

    private boolean hasDirectory(File dir, String packageName) {
        if (packageName.length() == 0) {
            return true;
        }
        String relativePath = packageName.replace('.', File.separatorChar);
        String fullPath = dir.getPath() + File.separator + relativePath;
        if (this.dirs.get(fullPath) == NO_DIR) {
            return false;
        }
        boolean result = new File(dir, relativePath).isDirectory();
        this.dirs.put(fullPath, result ? fullPath : NO_DIR);
        return result;
    }

    public List getPaths() {
        return this.directories;
    }

    String[] getMimeTypes() {
        return this.mimeTypes;
    }

    Map sources() {
        return this.sources;
    }

    public void displayWarnings() {
        int size = this.warnings.size();
        for (int i = 0; i < size; ++i) {
            ThreadLocalToolkit.log((ClasspathOverlap)this.warnings.get(i));
        }
    }

    static {
        $assertionsDisabled = !SourcePath.class.desiredAssertionStatus();
        NO_DIR = new Object();
    }

    public static class MoreThanOneComponentOfTheSameName
    extends CompilerMessage.CompilerInfo {
        public final String file1;
        public final String file2;

        public MoreThanOneComponentOfTheSameName(String file1, String file2) {
            this.file1 = file1;
            this.file2 = file2;
        }
    }

    public static class ClasspathOverlap
    extends CompilerMessage.CompilerWarning {
        public final String cpath;
        public final String directory;

        public ClasspathOverlap(String path, String directory) {
            this.cpath = path;
            this.directory = directory;
        }
    }
}

