/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flex2.compiler.Source;
import flex2.compiler.util.LineNumberMap;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.StringPrintWriter;

public final class BytecodeEmitter
extends ActionBlockEmitter {
    private LineNumberMap map;
    private Source source;
    private String currentFileName;
    private Context cx;
    private Set lines;
    private Line key;

    public BytecodeEmitter(Context cx, Source source, boolean debug) {
        this(cx, source, debug, null);
    }

    public BytecodeEmitter(Context cx, Source source, boolean debug, LineNumberMap map) {
        super(cx, source != null ? source.getName() : null, new StringPrintWriter(), new StringPrintWriter(), false, false, false, debug);
        this.map = map;
        this.source = source;
        this.cx = cx;
        if (debug) {
            this.lines = new HashSet();
            this.key = new Line();
        }
    }

    protected void DebugSlot(String name, int slot, int line) {
        int newLine;
        if (line > this.cx.input.lnNum) {
            return;
        }
        if (this.source.isDebuggable() && (newLine = this.calculateLineNumber(line)) != -1) {
            super.DebugSlot(name, slot, newLine);
        }
    }

    protected void DebugFile(String name) {
        this.currentFileName = name;
        if (!this.source.isDebuggable()) {
            return;
        }
        if (this.map != null && this.map.getNewName().equals(name)) {
            name = this.map.getOldName();
        }
        if (this.source.isSourcePathOwner() || this.source.isSourceListOwner() || this.source.isResourceContainerOwner() || this.source.isRoot()) {
            String relativePath = this.source.getRelativePath().replace('/', File.separatorChar);
            if (relativePath.length() == 0) {
                int index = name.lastIndexOf(File.separatorChar);
                if (index != -1) {
                    name = name.substring(0, index) + ";;" + name.substring(index + 1);
                }
            } else {
                int index = name.lastIndexOf(relativePath);
                if (index > 0) {
                    name = name.substring(0, index - 1) + ";" + relativePath + ";" + name.substring(index + relativePath.length() + 1);
                }
            }
        }
        super.DebugFile(name);
    }

    protected void DebugLine(ByteList code, int line) {
        if (line > this.cx.input.lnNum) {
            return;
        }
        if (this.lines != null) {
            this.key.fileName = this.currentFileName;
            this.key.line = line;
            if (!this.lines.contains(this.key)) {
                this.lines.add(new Line(this.currentFileName, line));
                this.source.lineCount = this.lines.size();
            }
        }
        if (!this.source.isDebuggable()) {
            return;
        }
        int newLine = this.calculateLineNumber(line);
        if (newLine != -1) {
            super.DebugLine(code, newLine);
        }
    }

    private int calculateLineNumber(int line) {
        if (this.map == null || !this.source.getName().equals(this.currentFileName)) {
            return line;
        }
        int newLine = this.map.get(line);
        if (newLine > 0) {
            return newLine;
        }
        return -1;
    }

    private static class Line {
        public String fileName;
        public int line;

        Line() {
        }

        Line(String f, int l) {
            this.fileName = f;
            this.line = l;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Line) {
                Line line = (Line)o;
                return this.fileName.equals(line.fileName) && this.line == line.line;
            }
            return false;
        }

        public int hashCode() {
            return this.fileName.hashCode() ^ this.line;
        }
    }
}

