/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.MetaDataEvaluator;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.io.FileUtil;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.VariableDeclaration;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;

public class SyntaxTreeEvaluator
extends EvaluatorAdapter {
    private CompilationUnit unit;
    private String currentClassName = "";
    private ClassDefinitionNode currentClassNode = null;
    private ProgramNode currentProgramNode = null;
    private PackageDefinitionNode lastPackageNode = null;
    private boolean seenConstructor = false;
    private Map functionMap;
    private FunctionDefinitionNode cur_func = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SyntaxTreeEvaluator(CompilationUnit unit) {
        this.unit = unit;
    }

    public Value evaluate(macromedia.asc.util.Context cx, PackageDefinitionNode node) {
        this.lastPackageNode = this.lastPackageNode == node ? null : null;
        return super.evaluate(cx, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(macromedia.asc.util.Context cx, ClassDefinitionNode node) {
        ClassDefinitionNode prev = this.currentClassNode;
        try {
            if (!$assertionsDisabled && !this.currentClassName.equals("")) {
                throw new AssertionError((Object)("nested classdef in SyntaxTreeEvaluator (outer='" + this.currentClassName + "')"));
            }
            this.currentClassName = NodeMagic.getUnqualifiedClassName(node);
            this.currentClassNode = node;
            this.seenConstructor = false;
            this.functionMap = new HashMap();
            super.evaluate(cx, node);
            Object var5_4 = null;
            this.currentClassNode = prev;
            this.currentClassName = "";
            this.seenConstructor = false;
            this.functionMap = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.currentClassNode = prev;
            this.currentClassName = "";
            this.seenConstructor = false;
            this.functionMap = null;
            throw throwable;
        }
        return null;
    }

    public Value evaluate(macromedia.asc.util.Context cx, FunctionDefinitionNode node) {
        FunctionDefinitionNode old = this.cur_func;
        this.cur_func = node;
        super.evaluate(cx, node);
        this.cur_func = old;
        if (NodeMagic.getFunctionName(node).equals(this.currentClassName)) {
            if (this.seenConstructor) {
                cx.localizedError2(cx.input.origin, node.pos(), new MultipleConstructorDefs());
            } else {
                this.seenConstructor = true;
            }
        } else {
            String functionName = NodeMagic.getFunctionName(node);
            if (this.functionMap != null && functionName != null) {
                switch (node.name.kind) {
                    case -78: {
                        FunctionDefinitionNode setter = (FunctionDefinitionNode)this.functionMap.get(functionName);
                        if (setter != null) {
                            this.processAccessorMetaData(cx, node, setter);
                            break;
                        }
                        this.functionMap.put(functionName, node);
                        break;
                    }
                    case -97: {
                        FunctionDefinitionNode getter = (FunctionDefinitionNode)this.functionMap.get(functionName);
                        if (getter != null) {
                            this.processAccessorMetaData(cx, getter, node);
                            break;
                        }
                        this.functionMap.put(functionName, node);
                        break;
                    }
                }
            }
        }
        return null;
    }

    public Value evaluate(macromedia.asc.util.Context cx, IncludeDirectiveNode node) {
        super.evaluate(cx, node);
        this.unit.getSource().addFileInclude(FileUtil.getCanonicalPath(node.filespec.value));
        return null;
    }

    public Value evaluate(macromedia.asc.util.Context cx, MetaDataNode node) {
        if (node.data != null) {
            macromedia.asc.parser.MetaDataEvaluator mde = new macromedia.asc.parser.MetaDataEvaluator();
            node.evaluate(cx, mde);
        }
        this.unit.metadata.add(node);
        if (NodeMagic.isClassDefinition(node)) {
            if ("SWF".equals(node.id)) {
                this.unit.swfMetaData = new MetaData(node);
            } else if ("Frame".equals(node.id)) {
                this.processFrameMetaData(node);
            } else if ("AccessibilityClass".equals(node.id)) {
                this.unit.addAccessibilityClass(new MetaData(node));
            } else if ("RemoteClass".equals(node.id)) {
                this.processRemoteClassMetaData(cx, node);
            } else if ("RequiresLicense".equals(node.id)) {
                this.processLicenseMetaData(cx, node);
            } else if ("Mixin".equals(node.id)) {
                this.unit.mixins.add(NodeMagic.retrieveClassName(node));
            } else if ("IconFile".equals(node.id)) {
                this.processIconFileMetaData(cx, node);
            } else if ("Event".equals(node.id)) {
                this.processEventMetaData(node);
            } else if ("Effect".equals(node.id)) {
                this.processEffectTriggerMetaData(node);
            }
        } else if ("ResourceBundle".equals(node.id)) {
            this.processResourceBundle(cx, node);
        } else if ("ArrayElementType".equals(node.id)) {
            this.processArrayElementTypeMetaData(cx, node);
        } else if ("InstanceType".equals(node.id)) {
            this.processInstanceTypeMetaData(cx, node);
        } else if ("PercentProxy".equals(node.id)) {
            this.processPercentProxyMetaData(cx, node);
        }
        return null;
    }

    private boolean isFlexMetaData(String metaData) {
        boolean result = false;
        if (metaData.equals("AccessibilityClass") || metaData.equals("ArrayElementType") || metaData.equals("Bindable") || metaData.equals("ChangeEvent") || metaData.equals("CollapseWhiteSpace") || metaData.equals("DefaultProperty") || metaData.equals("Deprecated") || metaData.equals("Effect") || metaData.equals("Embed") || metaData.equals("Event") || metaData.equals("Frame") || metaData.equals("IconFile") || metaData.equals("Inspectable") || metaData.equals("InstanceType") || metaData.equals("Managed") || metaData.equals("Mixin") || metaData.equals("NonCommittingChangeEvent") || metaData.equals("PercentProxy") || metaData.equals("RequiresLicense") || metaData.equals("RemoteClass") || metaData.equals("ResourceBundle") || metaData.equals("Style") || metaData.equals("SWF") || metaData.equals("Transient")) {
            result = true;
        }
        return result;
    }

    private void processAccessorMetaData(macromedia.asc.util.Context cx, FunctionDefinitionNode getter, FunctionDefinitionNode setter) {
        List getterMetaDataList = NodeMagic.getMetaData(getter);
        List setterMetaDataList = NodeMagic.getMetaData(setter);
        Iterator getterMetaDataIterator = getterMetaDataList.iterator();
        while (getterMetaDataIterator.hasNext()) {
            MetaDataNode getterMetaDataNode = (MetaDataNode)getterMetaDataIterator.next();
            if (getterMetaDataNode instanceof DocCommentNode) continue;
            Iterator setterMetaDataIterator = setterMetaDataList.iterator();
            while (setterMetaDataIterator.hasNext()) {
                MetaDataNode setterMetaDataNode = (MetaDataNode)setterMetaDataIterator.next();
                if (setterMetaDataNode instanceof DocCommentNode || !getterMetaDataNode.id.equals(setterMetaDataNode.id) || !this.isFlexMetaData(setterMetaDataNode.id) || getterMetaDataNode.count() != 0 || setterMetaDataNode.count() != 0) continue;
                String functionName = NodeMagic.getFunctionName(setter);
                cx.localizedWarning2(setterMetaDataNode.pos(), new DuplicateMetaData(this.currentClassName, functionName, setterMetaDataNode.id));
            }
        }
    }

    private void processInstanceTypeMetaData(macromedia.asc.util.Context cx, MetaDataNode node) {
        if (node.count() == 1) {
            this.unit.expressions.add(NameFormatter.toMultiName(node.getValue(0)));
        } else {
            cx.localizedError2(cx.input.origin, node.pos(), new InstanceTypeMustHaveType());
        }
    }

    private void processResourceBundle(macromedia.asc.util.Context context, MetaDataNode node) {
        if (node.count() == 0) {
            context.localizedError2(node.pos(), new RBEmptyMetadata());
        } else {
            String name = node.getValue(0);
            this.unit.resourceBundleHistory.add(name);
            DefinitionNode def = node.def;
            if (def instanceof VariableDefinitionNode) {
                Object item;
                if (this.cur_func != null) {
                    this.cur_func.addMetaDataNode(node);
                }
                VariableDefinitionNode varDefinition = (VariableDefinitionNode)def;
                if (varDefinition.list != null && varDefinition.list.items != null && varDefinition.list.items.size() > 0 && (item = varDefinition.list.items.get(0)) instanceof VariableBindingNode) {
                    VariableBindingNode variableBinding = (VariableBindingNode)item;
                    if (variableBinding.initializer == null) {
                        String type = NodeMagic.lookupType(variableBinding);
                        if (type == null || !type.equals("ResourceBundle")) {
                            context.localizedError2(context.input.origin, node.pos(), new NotResourceBundleType());
                        }
                        IdentifierNode idNode = new IdentifierNode("ResourceBundle", 0);
                        GetExpressionNode getNode = new GetExpressionNode(idNode);
                        getNode.setPosition(0);
                        MemberExpressionNode memberNode = new MemberExpressionNode(null, getNode, 0);
                        LiteralStringNode litNode = new LiteralStringNode(name);
                        litNode.setPosition(0);
                        ArgumentListNode argNode = new ArgumentListNode(litNode, 0);
                        MemberExpressionNode ad = new MemberExpressionNode(new MemberExpressionNode(null, new GetExpressionNode(new IdentifierNode("ApplicationDomain", 0)), 0), new GetExpressionNode(new IdentifierNode("currentDomain", 0)), 0);
                        argNode.items.push_back(ad);
                        IdentifierNode idNode3 = new IdentifierNode("getResourceBundle", 0);
                        CallExpressionNode callNode = new CallExpressionNode(idNode3, argNode);
                        variableBinding.initializer = new MemberExpressionNode(memberNode, callNode, 0);
                        NodeMagic.addImport(context, this.currentClassNode, NameFormatter.toDot(StandardDefs.CLASS_APPLICATIONDOMAIN));
                    }
                }
            } else if (!(def instanceof FunctionDefinitionNode)) {
                context.localizedError2(node.pos(), new RBOnlyOnVars());
            }
        }
    }

    private void processArrayElementTypeMetaData(macromedia.asc.util.Context cx, MetaDataNode node) {
        if (node.count() == 1) {
            this.unit.expressions.add(NameFormatter.toMultiName(node.getValue(0)));
        } else {
            cx.localizedError2(cx.input.origin, node.pos(), new ArrayElementTypeMustHaveType());
        }
    }

    private void processPercentProxyMetaData(macromedia.asc.util.Context cx, MetaDataNode node) {
        if (node.count() != 1) {
            cx.localizedError2(cx.input.origin, node.pos(), new PercentProxyMustHaveProperty());
        }
    }

    private void processEventMetaData(MetaDataNode node) {
        String typeName = node.getValue("type");
        if (typeName != null) {
            this.unit.expressions.add(NameFormatter.toMultiName(typeName));
        }
    }

    private void processIconFileMetaData(macromedia.asc.util.Context cx, MetaDataNode node) {
        if (this.unit.iconFile == null) {
            this.unit.iconFile = new MetaData(node);
        } else {
            String icon = this.unit.iconFile.getValue(0);
            String val = node.getValue(0);
            String sourceName = this.unit.getSource().getNameForReporting();
            if (icon != null && !icon.equals(val)) {
                cx.localizedError2(cx.input.origin, node.pos(), new DuplicateIconFileMetadata(icon, val, sourceName));
            } else if (icon == null) {
                this.unit.iconFile = new MetaData(node);
            }
        }
    }

    private void processLicenseMetaData(macromedia.asc.util.Context cx, MetaDataNode node) {
        String handler;
        String className = NodeMagic.retrieveClassName(node);
        String packageName = className.indexOf(58) == -1 ? null : className.substring(0, className.indexOf(58));
        String id = node.getValue("id");
        if (id == null) {
            id = packageName != null ? packageName : className;
        }
        if ((handler = node.getValue("handler")) == null) {
            handler = packageName != null ? packageName + ".LicenseHandler" : id + "LicenseHandler";
        }
        this.unit.licensedClassReqs.put(id, NodeMagic.normalizeClassName(handler));
    }

    private void processRemoteClassMetaData(macromedia.asc.util.Context cx, MetaDataNode node) {
        String className = NodeMagic.retrieveClassName(node);
        String alias = node.getValue("alias");
        if (alias == null) {
            alias = ">" + className;
        }
        this.unit.remoteClassAliases.put(className, alias);
    }

    private void processFrameMetaData(MetaDataNode node) {
        if (node.getValue("factoryClass") != null) {
            this.unit.loaderClass = NodeMagic.normalizeClassName(node.getValue("factoryClass"));
        }
        if (node.getValue("extraClass") != null) {
            this.unit.extraClasses.add(NodeMagic.normalizeClassName(node.getValue("extraClass")));
        }
    }

    private void processEffectTriggerMetaData(MetaDataNode node) {
        String event;
        String triggerName = node.getValue("name");
        if (triggerName == null) {
            triggerName = node.getValue(0);
        }
        if ((event = node.getValue("event")) == null) {
            event = "";
        }
        this.unit.effectTriggers.put(triggerName, event);
    }

    public static void removeNonAPIContent(CompilationUnit ascUnit) {
        int size;
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        ClassDefinitionNode clsdef = SyntaxTreeEvaluator.getFirstClassDefinition((ProgramNode)ascUnit.getSyntaxTree());
        if (!$assertionsDisabled && clsdef == null) {
            throw new AssertionError((Object)"could not find a class definition node...");
        }
        Context context = ascUnit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        int n = size = clsdef != null && clsdef.statements != null && clsdef.statements.items != null ? clsdef.statements.items.size() : 0;
        for (int i = 0; i < size; ++i) {
            Object node = clsdef.statements.items.get(i);
            if (node instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode function = (FunctionDefinitionNode)node;
                if (function.fexpr == null || function.fexpr.body == null || function.fexpr.body.items == null) continue;
                NodeFactory nodeFactory = cx.getNodeFactory();
                function.fexpr.body = nodeFactory.statementList(null, function.fexpr.body.items.removeLast());
                if (function.fexpr.signature == null || function.fexpr.signature.result == null) continue;
                function.fexpr.body.items.add(0, nodeFactory.list(null, nodeFactory.returnStatement(nodeFactory.literalNull())));
                continue;
            }
            if (!(node instanceof VariableDefinitionNode)) continue;
            VariableDefinitionNode var = (VariableDefinitionNode)node;
            int len = var.list.items.size();
            for (int k = 0; k < len; ++k) {
                VariableBindingNode binding = (VariableBindingNode)var.list.items.get(k);
                binding.initializer = null;
            }
        }
    }

    private static ClassDefinitionNode getFirstClassDefinition(ProgramNode program) {
        int size;
        int n = size = program != null && program.statements != null && program.statements.items != null ? program.statements.items.size() : 0;
        for (int i = 0; i < size; ++i) {
            Object node = program.statements.items.get(i);
            if (!(node instanceof ClassDefinitionNode)) continue;
            return (ClassDefinitionNode)node;
        }
        return null;
    }

    public static void ensureMetaDataHasDefinition(CompilationUnit compilationUnit) {
        ProgramNode programNode = (ProgramNode)compilationUnit.getSyntaxTree();
        Context context = compilationUnit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        MetaDataEvaluator metaDataEvaluator = new MetaDataEvaluator();
        programNode.evaluate(cx, metaDataEvaluator);
    }

    public static void stripRedeclaredManagementVars(CompilationUnit ascUnit, String className, SymbolTable symbolTable) {
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        ProgramNode program = (ProgramNode)ascUnit.getSyntaxTree();
        ClassDefinitionNode classDefinitionNode = SyntaxTreeEvaluator.getFirstClassDefinition(program);
        if (!$assertionsDisabled && classDefinitionNode == null) {
            throw new AssertionError((Object)"could not find a class definition node...");
        }
        Context context = ascUnit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        TypeAnalyzer typeAnalyzer = symbolTable.getTypeAnalyzer();
        program.evaluate(cx, typeAnalyzer);
        ClassInfo classInfo = typeAnalyzer.getClassInfo(className);
        ClassInfo baseClassInfo = classInfo.getBaseClassInfo();
        if (baseClassInfo != null && !FrameworkDefs.bindingManagementVars.isEmpty() && baseClassInfo.definesVariable(((VariableDeclaration)FrameworkDefs.bindingManagementVars.get(0)).getName())) {
            SyntaxTreeEvaluator.removeVariables(classDefinitionNode, FrameworkDefs.bindingManagementVars);
        }
    }

    private static void removeVariables(ClassDefinitionNode classDefinition, List variableDeclarations) {
        Iterator iterator = classDefinition.statements.items.iterator();
        while (iterator.hasNext()) {
            Object variableNode;
            Object node = iterator.next();
            if (!(node instanceof VariableDefinitionNode)) continue;
            VariableDefinitionNode variableDefinition = (VariableDefinitionNode)node;
            if (variableDefinition.list == null || variableDefinition.list.items == null || variableDefinition.list.items.size() != 1 || !((variableNode = variableDefinition.list.items.get(0)) instanceof VariableBindingNode)) continue;
            VariableBindingNode variableBindingNode = (VariableBindingNode)variableNode;
            String name = variableBindingNode.variable.identifier.name;
            Iterator varDeclIter = variableDeclarations.iterator();
            while (varDeclIter.hasNext()) {
                if (!name.equals(((VariableDeclaration)varDeclIter.next()).getName())) continue;
                iterator.remove();
            }
        }
    }

    static {
        $assertionsDisabled = !SyntaxTreeEvaluator.class.desiredAssertionStatus();
    }

    public static class RBEmptyMetadata
    extends CompilerMessage.CompilerError {
    }

    public static class RBOnlyOnVars
    extends CompilerMessage.CompilerError {
    }

    public static class MultipleConstructorDefs
    extends CompilerMessage.CompilerError {
    }

    public static class PercentProxyMustHaveProperty
    extends CompilerMessage.CompilerError {
    }

    public static class InstanceTypeMustHaveType
    extends CompilerMessage.CompilerError {
    }

    public static class ArrayElementTypeMustHaveType
    extends CompilerMessage.CompilerError {
    }

    public static class RemoteClassRequiresAlias
    extends CompilerMessage.CompilerError {
    }

    public static class NotResourceBundleType
    extends CompilerMessage.CompilerError {
    }

    public static class DuplicateMetaData
    extends CompilerMessage.CompilerWarning {
        public String declaringClass;
        public String setter;
        public String metaData;

        public DuplicateMetaData(String declaringClass, String setter, String metaData) {
            this.declaringClass = declaringClass;
            this.setter = setter;
            this.metaData = metaData;
        }
    }

    public static class DuplicateIconFileMetadata
    extends CompilerMessage.CompilerError {
        public final String icon;
        public final String val;
        public final String sourceName;

        public DuplicateIconFileMetadata(String icon, String val, String sourceName) {
            this.icon = icon;
            this.val = val;
            this.sourceName = sourceName;
        }
    }
}

