/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.as3.reflect.TypeTable;
import java.util.HashSet;
import java.util.Set;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class DataBindingDependencyEvaluator
extends EvaluatorAdapter {
    private Set evaluatedClasses = new HashSet();
    private Set unresolvedDependencies = new HashSet();
    private String bindingFunctionName;
    private TypeTable typeTable;
    private boolean insideArrayExpression = false;
    private boolean insideBindingExpressionsFunction = false;
    private boolean insideSetExpression = false;

    public DataBindingDependencyEvaluator(TypeTable typeTable) {
        this.typeTable = typeTable;
    }

    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            String className = node.name.name;
            String convertedClassName = "_" + className.replace('.', '_').replace(':', '_');
            this.bindingFunctionName = convertedClassName + "_bindingExprs";
            if (node.fexprs != null) {
                int size = node.fexprs.size();
                for (int i = 0; i < size; ++i) {
                    FunctionCommonNode functionCommon = (FunctionCommonNode)node.fexprs.get(i);
                    functionCommon.evaluate(context, this);
                }
            }
            this.evaluatedClasses.add(node);
        }
        return null;
    }

    public Value evaluate(Context context, FunctionCommonNode functionCommon) {
        if (functionCommon.identifier != null && functionCommon.identifier.name.equals(this.bindingFunctionName)) {
            this.insideBindingExpressionsFunction = true;
            super.evaluate(context, functionCommon);
            this.insideBindingExpressionsFunction = false;
        }
        return null;
    }

    public Value evaluate(Context context, MemberExpressionNode node) {
        ReferenceValue ref;
        boolean oldArrayExpression = this.insideArrayExpression;
        this.insideArrayExpression = node.isIndexedMemberExpression();
        if (node.base != null) {
            node.base.evaluate(context, this);
            if (this.insideBindingExpressionsFunction && this.insideSetExpression && !this.insideArrayExpression) {
                Node base;
                ReferenceValue ref2 = null;
                if (node.base instanceof CallExpressionNode) {
                    base = (CallExpressionNode)node.base;
                    ref2 = base.ref;
                } else if (node.base instanceof MemberExpressionNode) {
                    base = (MemberExpressionNode)node.base;
                    ref2 = ((MemberExpressionNode)base).ref;
                } else if (node.base instanceof GetExpressionNode) {
                    base = (GetExpressionNode)node.base;
                    ref2 = ((GetExpressionNode)base).ref;
                }
                if (ref2 != null && ref2.slot != null) {
                    if (ref2.slot.getObjectValue() != null && !ref2.slot.getObjectValue().toString().equals("")) {
                        this.resolveDependency(ref2.slot.getObjectValue().toString());
                    } else if (ref2.getType(context) != null && !ref2.getType(context).toString().equals("")) {
                        this.resolveDependency(ref2.getType(context).toString());
                    } else if (ref2.slot.getType() != null && !ref2.slot.getType().toString().equals("")) {
                        this.resolveDependency(ref2.slot.getType().toString());
                    }
                }
            }
        }
        boolean staticReference = false;
        if (this.insideBindingExpressionsFunction && this.insideSetExpression && (ref = node.ref) != null && ref.getType(context).toString().equals("Class") && ref.slot != null && ref.slot.getObjectValue() != null) {
            staticReference = true;
            this.resolveDependency(ref.slot.getObjectValue().toString());
        }
        if (node.selector != null && !staticReference) {
            node.selector.evaluate(context, this);
        }
        this.insideArrayExpression = oldArrayExpression;
        return null;
    }

    public Value evaluate(Context context, SetExpressionNode node) {
        if (node.expr != null) {
            node.expr.evaluate(context, this);
        }
        if (node.args != null) {
            this.insideSetExpression = true;
            node.args.evaluate(context, this);
            this.insideSetExpression = false;
        }
        return null;
    }

    public Set getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    public void resolveDependency(String className) {
        if (className != null && !className.equals("") && this.typeTable.getClass(className) == null) {
            this.unresolvedDependencies.add(className);
        }
    }
}

