/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.CompilationUnit;
import flex2.compiler.SymbolTable;
import flex2.compiler.abc.Attributes;
import flex2.compiler.abc.Class;
import flex2.compiler.abc.MetaData;
import flex2.compiler.abc.Method;
import flex2.compiler.abc.Variable;
import flex2.compiler.as3.binding.ArrayElementWatcher;
import flex2.compiler.as3.binding.DataBindingInfo;
import flex2.compiler.as3.binding.FunctionReturnWatcher;
import flex2.compiler.as3.binding.PropertyWatcher;
import flex2.compiler.as3.binding.RepeaterComponentWatcher;
import flex2.compiler.as3.binding.RepeaterDataProviderWatcher;
import flex2.compiler.as3.binding.RepeaterItemWatcher;
import flex2.compiler.as3.binding.Watcher;
import flex2.compiler.as3.binding.XMLWatcher;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.semantics.VariableSlot;
import macromedia.asc.util.Context;

public class DataBindingFirstPassEvaluator
extends EvaluatorAdapter {
    private static final String BINDABLE = "Bindable";
    private static final String CHANGE_EVENT = "ChangeEvent";
    private static final String NON_COMMITTING_CHANGE_EVENT = "NonCommittingChangeEvent";
    private static final String EVENT = "event";
    private boolean showBindingWarnings;
    private TypeTable typeTable;
    private Stack srcTypeStack;
    private Stack argumentListStack;
    private Set skipInitSet;
    private Set resetSet;
    private MemberExpressionNode xmlMember = null;
    private boolean insideXmlExpression = false;
    private boolean insideBindingExpressionsFunction = false;
    private boolean insideCallExpression = false;
    private boolean insideGetExpression = false;
    private boolean insideSetExpression = false;
    private boolean insideArrayExpression = false;
    private LinkedList watcherList;
    private ClassDefinitionNode currentClassDefinition;
    private BindingExpression currentBindingExpression;
    private int currentWatcherId = 1;
    private String bindingFunctionName;
    private List bindingExpressions;
    private Set evaluatedClasses;
    private DataBindingInfo dataBindingInfo;
    private List dataBindingInfoList;
    private boolean makeSecondPass = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataBindingFirstPassEvaluator(CompilationUnit unit, TypeTable typeTable, boolean showBindingWarnings) {
        this.typeTable = typeTable;
        this.argumentListStack = new Stack();
        this.skipInitSet = new HashSet();
        this.resetSet = new HashSet();
        this.srcTypeStack = new Stack();
        this.bindingExpressions = (List)unit.getContext().getAttribute("BindingExpressions");
        this.evaluatedClasses = new HashSet();
        this.dataBindingInfoList = new ArrayList();
        this.showBindingWarnings = showBindingWarnings;
        this.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
    }

    private boolean addBindables(Watcher watcher, List bindables) {
        boolean addedBindable = false;
        if (bindables != null) {
            Iterator bindablesIterator = bindables.iterator();
            while (bindablesIterator.hasNext()) {
                MetaData metaData = (MetaData)bindablesIterator.next();
                String event = this.getEventName(metaData);
                if (event != null) {
                    watcher.addChangeEvent(event);
                } else {
                    watcher.addChangeEvent("propertyChange");
                }
                addedBindable = true;
            }
        }
        return addedBindable;
    }

    private String getEventName(MetaData metaData) {
        String param;
        String eventName = metaData.getValue(EVENT);
        if (eventName != null) {
            return eventName;
        }
        if (metaData.count() == 1 && !(param = metaData.getValue(0)).equals(metaData.getID())) {
            return param;
        }
        return null;
    }

    private boolean addChangeEvents(Watcher watcher, List changeEvents) {
        boolean addedChangeEvent = false;
        if (changeEvents != null) {
            Iterator changeEventIterator = changeEvents.iterator();
            while (changeEventIterator.hasNext()) {
                MetaData metaData = (MetaData)changeEventIterator.next();
                String event = metaData.getValue(0);
                if (event == null) continue;
                watcher.addChangeEvent(event);
                addedChangeEvent = true;
            }
        }
        return addedChangeEvent;
    }

    private boolean addNonCommittingChangeEvents(Watcher watcher, List changeEvents) {
        boolean addedChangeEvent = false;
        if (changeEvents != null) {
            Iterator changeEventIterator = changeEvents.iterator();
            while (changeEventIterator.hasNext()) {
                MetaData metaData = (MetaData)changeEventIterator.next();
                String event = metaData.getValue(0);
                if (event == null) continue;
                watcher.addChangeEvent(event, false);
                addedChangeEvent = true;
            }
        }
        return addedChangeEvent;
    }

    public Value evaluate(Context context, ArgumentListNode node) {
        if (this.insideBindingExpressionsFunction && this.insideSetExpression) {
            int size = node.items.size();
            for (int i = 0; i < size; ++i) {
                Node argument = (Node)node.items.get(i);
                LinkedList tempWatcherList = this.watcherList;
                this.argumentListStack.push(node);
                if (!this.skipInitSet.remove(node)) {
                    this.watcherList = new LinkedList();
                }
                argument.evaluate(context, this);
                if (this.resetSet.remove(node)) {
                    this.watcherList = tempWatcherList;
                }
                this.argumentListStack.pop();
            }
        }
        return null;
    }

    public Value evaluate(Context context, BinaryExpressionNode node) {
        if (node.lhs != null) {
            node.lhs.evaluate(context, this);
        }
        if (this.insideBindingExpressionsFunction && this.insideSetExpression) {
            this.watcherList = new LinkedList();
        }
        if (node.rhs != null) {
            node.rhs.evaluate(context, this);
        }
        if (this.insideBindingExpressionsFunction && this.insideSetExpression) {
            this.watcherList = new LinkedList();
        }
        return null;
    }

    public Value evaluate(Context context, CallExpressionNode node) {
        if (this.insideBindingExpressionsFunction && this.insideSetExpression && !node.is_new && node.expr != null) {
            this.argumentListStack.push(node.args);
            if (node.expr instanceof IdentifierNode) {
                IdentifierNode identifier = (IdentifierNode)node.expr;
                if (identifier.ref != null && identifier.ref.getType(context) != null && !identifier.name.equals(identifier.ref.getType((Context)context).name.name)) {
                    this.insideCallExpression = true;
                    node.expr.evaluate(context, this);
                    this.insideCallExpression = false;
                    this.resetSet.add(node.args);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unexpected CallExpressionNode.expr type: " + node.expr.getClass().getName()));
            }
            if (node.args != null) {
                this.srcTypeStack.push(this.srcTypeStack.firstElement());
                node.args.evaluate(context, this);
                this.srcTypeStack.pop();
            }
            this.argumentListStack.pop();
        }
        return null;
    }

    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            this.currentClassDefinition = node;
            String className = node.name.name;
            String convertedClassName = "_" + className.replace('.', '_').replace(':', '_');
            this.bindingFunctionName = convertedClassName + "_bindingExprs";
            String fullyQualifiedClassName = node.cframe.name.toString();
            this.srcTypeStack.push(TypeTable.convertName(fullyQualifiedClassName));
            if (node.fexprs != null) {
                int size = node.fexprs.size();
                for (int i = 0; i < size; ++i) {
                    FunctionCommonNode functionCommon = (FunctionCommonNode)node.fexprs.get(i);
                    functionCommon.evaluate(context, this);
                }
            }
            this.srcTypeStack.pop();
            if (this.dataBindingInfo != null) {
                this.dataBindingInfo.setBindingExpressions(this.bindingExpressions);
                this.dataBindingInfo.setClassName(fullyQualifiedClassName);
                this.dataBindingInfoList.add(this.dataBindingInfo);
                this.dataBindingInfo = null;
            }
            this.evaluatedClasses.add(node);
            this.currentClassDefinition = null;
        }
        return null;
    }

    public Value evaluate(Context context, ConditionalExpressionNode node) {
        if (node.condition != null) {
            node.condition.evaluate(context, this);
        }
        if (this.insideBindingExpressionsFunction && this.insideSetExpression) {
            this.watcherList = new LinkedList();
        }
        if (node.thenexpr != null) {
            node.thenexpr.evaluate(context, this);
        }
        if (this.insideBindingExpressionsFunction && this.insideSetExpression) {
            this.watcherList = new LinkedList();
        }
        if (node.elseexpr != null) {
            node.elseexpr.evaluate(context, this);
        }
        if (this.insideBindingExpressionsFunction && this.insideSetExpression) {
            this.watcherList = new LinkedList();
        }
        return null;
    }

    public Value evaluate(Context context, FunctionCommonNode functionCommon) {
        if (functionCommon.identifier != null && functionCommon.identifier.name.equals(this.bindingFunctionName)) {
            this.insideBindingExpressionsFunction = true;
            this.dataBindingInfo = new DataBindingInfo(NodeMagic.getImports(this.currentClassDefinition.imported_names));
            Iterator iterator = functionCommon.body.items.iterator();
            while (iterator.hasNext()) {
                Object definition;
                Object item = iterator.next();
                if (!(item instanceof MetaDataNode) || item instanceof DocCommentNode) continue;
                MetaDataNode metaDataNode = (MetaDataNode)item;
                int bindingId = Integer.parseInt(metaDataNode.getValue("id"));
                this.currentBindingExpression = (BindingExpression)this.bindingExpressions.get(bindingId);
                if (!iterator.hasNext() || !((definition = iterator.next()) instanceof ExpressionStatementNode)) continue;
                ExpressionStatementNode expressionStatement = (ExpressionStatementNode)definition;
                this.watcherList = new LinkedList();
                this.evaluate(context, expressionStatement);
            }
            this.insideBindingExpressionsFunction = false;
            this.makeSecondPass = true;
        }
        return null;
    }

    public Value evaluate(Context context, GetExpressionNode node) {
        if (node.expr != null) {
            this.insideGetExpression = true;
            if (node.expr instanceof ArgumentListNode) {
                if (!this.insideXmlExpression && this.showBindingWarnings) {
                    context.localizedWarning2(node.pos(), new UnableToDetectSquareBracketChanges());
                }
                this.argumentListStack.push(node.expr);
                this.watchExpressionArray();
                this.argumentListStack.pop();
                this.resetSet.add(node.expr);
            }
            node.expr.evaluate(context, this);
            this.insideGetExpression = false;
        }
        return null;
    }

    public Value evaluate(Context context, IdentifierNode node) {
        if (this.insideBindingExpressionsFunction && this.insideSetExpression) {
            this.watchExpression(context, node, new MultiName(SymbolTable.VISIBILITY_NAMESPACES, node.name));
        }
        return null;
    }

    public Value evaluate(Context context, InvokeNode node) {
        if (this.insideBindingExpressionsFunction && this.insideSetExpression && this.insideXmlExpression) {
            this.skipInitSet.add(node.args);
        }
        super.evaluate(context, node);
        return null;
    }

    public Value evaluate(Context context, LiteralNumberNode node) {
        if (this.insideBindingExpressionsFunction && this.insideSetExpression && this.insideGetExpression) {
            this.watchExpressionArray();
        }
        return null;
    }

    public Value evaluate(Context context, WithStatementNode node) {
        if (node.expr != null) {
            node.expr.evaluate(context, this);
        }
        LinkedList savedWatcherList = this.watcherList;
        boolean normalWarningMode = this.showBindingWarnings;
        if (this.insideBindingExpressionsFunction && this.insideSetExpression && !this.insideArrayExpression) {
            if (this.xmlMember != null) {
                XMLWatcher watcher = this.watchExpressionStringAsXML(this.xmlMember.ref.name);
                if (watcher != null) {
                    String name = this.xmlMember.ref.name;
                    MultiName multiName = new MultiName(SymbolTable.VISIBILITY_NAMESPACES, name);
                    this.findEvents(context, name, multiName, this.xmlMember.pos(), (Watcher)watcher);
                }
                this.xmlMember = null;
            }
            if (this.insideXmlExpression) {
                this.watcherList = new LinkedList();
                this.showBindingWarnings = false;
            }
        }
        if (node.statement != null) {
            node.statement.evaluate(context, this);
        }
        if (this.insideBindingExpressionsFunction && this.insideSetExpression && !this.insideArrayExpression && this.insideXmlExpression) {
            this.watcherList = savedWatcherList;
            this.showBindingWarnings = normalWarningMode;
        }
        return null;
    }

    public Value evaluate(Context context, MemberExpressionNode node) {
        ReferenceValue ref;
        boolean pushed = false;
        boolean oldArrayExpression = this.insideArrayExpression;
        this.insideArrayExpression = node.isIndexedMemberExpression();
        if (node.base != null) {
            node.base.evaluate(context, this);
            if (this.insideBindingExpressionsFunction && this.insideSetExpression && !this.insideArrayExpression) {
                Node base;
                ReferenceValue ref2 = null;
                if (node.base instanceof CallExpressionNode) {
                    base = (CallExpressionNode)node.base;
                    ref2 = base.ref;
                } else if (node.base instanceof MemberExpressionNode) {
                    base = (MemberExpressionNode)node.base;
                    ref2 = ((MemberExpressionNode)base).ref;
                } else if (node.base instanceof GetExpressionNode) {
                    base = (GetExpressionNode)node.base;
                    ref2 = ((GetExpressionNode)base).ref;
                }
                if (ref2 != null && ref2.slot != null) {
                    if (ref2.slot.getObjectValue() != null && !ref2.slot.getObjectValue().toString().equals("")) {
                        this.srcTypeStack.push(TypeTable.convertName(ref2.slot.getObjectValue().toString()));
                    } else if (ref2.getType(context) != null && !ref2.getType(context).toString().equals("")) {
                        this.srcTypeStack.push(TypeTable.convertName(ref2.getType(context).toString()));
                    } else if (ref2.slot.getType() != null && !ref2.slot.getType().toString().equals("")) {
                        this.srcTypeStack.push(TypeTable.convertName(ref2.slot.getType().toString()));
                    } else {
                        this.srcTypeStack.push(null);
                    }
                } else if (node.base instanceof ThisExpressionNode) {
                    this.srcTypeStack.push(this.srcTypeStack.firstElement());
                } else {
                    this.srcTypeStack.push(null);
                }
                pushed = true;
            }
        }
        boolean staticReference = false;
        if (this.insideBindingExpressionsFunction && this.insideSetExpression && (ref = node.ref) != null) {
            if (this.isStaticReference(node.selector, ref)) {
                staticReference = true;
                this.srcTypeStack.push(TypeTable.convertName(ref.slot.getObjectValue().toString()));
                pushed = true;
            }
            if (ref.getType(context).toString().equals("XML")) {
                this.xmlMember = node;
                this.insideXmlExpression = true;
            }
        }
        if (node.selector != null && !staticReference) {
            node.selector.evaluate(context, this);
        }
        this.insideArrayExpression = oldArrayExpression;
        if (pushed) {
            this.srcTypeStack.pop();
        }
        return null;
    }

    public Value evaluate(Context context, MetaDataNode node) {
        return null;
    }

    public Value evaluate(Context context, QualifiedIdentifierNode node) {
        if (this.insideBindingExpressionsFunction && this.insideSetExpression) {
            this.watchExpression(context, node, NodeMagic.getQName(node));
        }
        return null;
    }

    public Value evaluate(Context context, SetExpressionNode node) {
        if (node.expr != null) {
            node.expr.evaluate(context, this);
        }
        if (node.args != null) {
            this.insideSetExpression = true;
            node.args.evaluate(context, this);
            this.insideSetExpression = false;
            this.insideXmlExpression = false;
            this.xmlMember = null;
        }
        return null;
    }

    private void findEvents(Context context, IdentifierNode node, String name, MultiName multiName, Watcher watcher) {
        if (this.isStaticReference(null, node.ref)) {
            return;
        }
        this.findEvents(context, name, multiName, node.pos(), watcher);
    }

    private void findEvents(Context context, String name, MultiName multiName, int pos, Watcher watcher) {
        String srcTypeName = null;
        if (watcher.isPartOfAnonObjectGraph()) {
            srcTypeName = StandardDefs.CLASS_OBJECTPROXY;
        } else if (!this.srcTypeStack.empty()) {
            srcTypeName = (String)this.srcTypeStack.peek();
        }
        Watcher parentWatcher = watcher.getParent();
        if (srcTypeName != null) {
            Class watchedClass = this.typeTable.getClass(srcTypeName);
            if (watchedClass != null) {
                Method function;
                if (watchedClass.isSubclassOf(StandardDefs.CLASS_UICOMPONENT)) {
                    this.currentBindingExpression.setUIComponentWatcher(watcher);
                } else if (watchedClass.isSubclassOf(StandardDefs.CLASS_OBJECTPROXY)) {
                    watcher.setPartOfAnonObjectGraph(true);
                } else if (watchedClass.isSubclassOf("XMLList") && (parentWatcher == null || !(parentWatcher instanceof XMLWatcher))) {
                    context.localizedWarning2(pos, new UnableToDetectXMLListChanges(name));
                }
                List metaData = watchedClass.getMetaData(BINDABLE, true);
                boolean foundEvents = this.addBindables(watcher, metaData);
                boolean foundSource = false;
                Variable variable = watchedClass.getVariable(multiName.getNamespace(), multiName.getLocalPart(), true);
                if (variable != null) {
                    metaData = variable.getMetaData(BINDABLE);
                    foundEvents = this.addBindables(watcher, metaData) || foundEvents;
                    metaData = variable.getMetaData(CHANGE_EVENT);
                    foundEvents = this.addChangeEvents(watcher, metaData) || foundEvents;
                    metaData = variable.getMetaData(NON_COMMITTING_CHANGE_EVENT);
                    foundEvents = this.addNonCommittingChangeEvents(watcher, metaData) || foundEvents;
                    Attributes attributes = variable.getAttributes();
                    if (!(attributes == null || !attributes.hasConst() || multiName.getLocalPart().equals("length") && variable.getDeclaringClass().getName().equals("Object"))) {
                        foundEvents = true;
                        if (watcher instanceof PropertyWatcher) {
                            ((PropertyWatcher)watcher).suppress();
                        }
                    }
                    if (attributes != null && attributes.hasStatic() && watcher instanceof PropertyWatcher) {
                        ((PropertyWatcher)watcher).setStaticProperty(true);
                        watcher.setClassName(srcTypeName);
                    }
                    foundSource = true;
                }
                if (!foundEvents) {
                    Method setter;
                    Method getter = watchedClass.getGetter(multiName.getNamespace(), multiName.getLocalPart(), true);
                    if (getter != null) {
                        metaData = getter.getMetaData(BINDABLE);
                        foundEvents = this.addBindables(watcher, metaData);
                        metaData = getter.getMetaData(CHANGE_EVENT);
                        foundEvents = this.addChangeEvents(watcher, metaData) || foundEvents;
                        metaData = getter.getMetaData(NON_COMMITTING_CHANGE_EVENT);
                        foundEvents = this.addNonCommittingChangeEvents(watcher, metaData) || foundEvents;
                        foundSource = true;
                    }
                    if ((setter = watchedClass.getSetter(multiName.getNamespace(), multiName.getLocalPart(), true)) != null) {
                        metaData = setter.getMetaData(BINDABLE);
                        foundEvents = this.addBindables(watcher, metaData) || foundEvents;
                        metaData = setter.getMetaData(CHANGE_EVENT);
                        foundEvents = this.addChangeEvents(watcher, metaData) || foundEvents;
                        metaData = setter.getMetaData(NON_COMMITTING_CHANGE_EVENT);
                        foundEvents = this.addNonCommittingChangeEvents(watcher, metaData) || foundEvents;
                        foundSource = true;
                    } else if (getter != null) {
                        foundEvents = true;
                    }
                }
                if (!foundSource && (function = watchedClass.getMethod(multiName.getNamespace(), multiName.getLocalPart(), true)) != null) {
                    metaData = function.getMetaData(BINDABLE);
                    foundEvents = this.addBindables(watcher, metaData) || foundEvents;
                    metaData = function.getMetaData(CHANGE_EVENT);
                    foundEvents = this.addChangeEvents(watcher, metaData) || foundEvents;
                    metaData = function.getMetaData(NON_COMMITTING_CHANGE_EVENT);
                    foundEvents = this.addNonCommittingChangeEvents(watcher, metaData) || foundEvents;
                    foundSource = true;
                    if (!foundEvents && !this.insideCallExpression) {
                        foundEvents = true;
                        if (watcher instanceof PropertyWatcher) {
                            ((PropertyWatcher)watcher).suppress();
                        }
                    }
                }
                if (!foundSource && watchedClass.isSubclassOf(StandardDefs.CLASS_ABSTRACTSERVICE)) {
                    watcher.setOperation(true);
                } else if (!(foundEvents || watcher instanceof FunctionReturnWatcher || watcher instanceof XMLWatcher || watcher.isOperation() || watchedClass.getName().equals("Object") || watchedClass.getName().equals("*"))) {
                    if (this.showBindingWarnings) {
                        context.localizedWarning2(pos, new UnableToDetectChanges(name));
                    }
                    if (watcher instanceof PropertyWatcher) {
                        ((PropertyWatcher)watcher).suppress();
                    }
                }
            }
        } else if (parentWatcher != null && parentWatcher.isOperation()) {
            watcher.addChangeEvent("resultForBinding");
        }
    }

    public List getDataBindingInfoList() {
        return this.dataBindingInfoList;
    }

    private boolean isStaticReference(SelectorNode selector, ReferenceValue referenceValue) {
        return (selector == null || selector instanceof GetExpressionNode) && referenceValue != null && referenceValue.slot != null && referenceValue.slot instanceof VariableSlot && referenceValue.slot.getType() != null && referenceValue.slot.getType().name.ns.toString().equals("") && referenceValue.slot.getType().name.name.equals("Class") && referenceValue.slot.getObjectValue() != null;
    }

    public boolean makeSecondPass() {
        return this.makeSecondPass;
    }

    private Watcher watchIdentifier(String name) {
        Watcher watcher = null;
        int size = this.srcTypeStack.size();
        if (!(!this.insideGetExpression || size == 1 && (name.equals("Infinity") || name.equals("-Infinity") || name.equals("NaN") || name.equals("undefined")))) {
            String src = (String)this.srcTypeStack.peek();
            if (!this.watcherList.isEmpty() && this.watcherList.getLast() instanceof XMLWatcher || src != null && (src.equals("XML") || src.equals("XMLList"))) {
                watcher = this.watchExpressionStringAsXML(name);
                this.xmlMember = null;
            } else {
                watcher = this.watchExpressionStringAsProperty(name);
            }
        } else if (!(!this.insideCallExpression || size == 1 && (name.equals("Array") || name.equals("Boolean") || name.equals("decodeURI") || name.equals("decodeURIComponent") || name.equals("encodeURI") || name.equals("encodeURIComponent") || name.equals("escape") || name.equals("int") || name.equals("isFinite") || name.equals("isNaN") || name.equals("isXMLName") || name.equals("Number") || name.equals("Object") || name.equals("parseFloat") || name.equals("parseInt") || name.equals("trace") || name.equals("uint") || name.equals("unescape") || name.equals("XML") || name.equals("XMLList")))) {
            watcher = this.watchExpressionStringAsFunction(name);
        }
        return watcher;
    }

    private void watchExpression(Context context, IdentifierNode identifier, MultiName multiName) {
        String name = multiName.getLocalPart();
        Watcher watcher = this.watchIdentifier(name);
        if (watcher != null && !(watcher instanceof RepeaterDataProviderWatcher)) {
            this.findEvents(context, identifier, name, multiName, watcher);
        }
    }

    private void watchExpression(Context context, QualifiedIdentifierNode qualifiedIdentifier, QName qName) {
        String name = qName.getNamespace() + "::" + qName.getLocalPart();
        Watcher watcher = this.watchIdentifier(name);
        if (watcher != null && !(watcher instanceof RepeaterDataProviderWatcher)) {
            MultiName multiName = new MultiName(new String[]{qName.getNamespace()}, qName.getLocalPart());
            this.findEvents(context, qualifiedIdentifier, name, multiName, watcher);
        }
    }

    private void watchExpressionArray() {
        ArrayElementWatcher watcher = new ArrayElementWatcher(this.currentWatcherId++, this.currentBindingExpression, (ArgumentListNode)this.argumentListStack.peek());
        if (!this.watcherList.isEmpty()) {
            Watcher parentWatcher = (Watcher)this.watcherList.getLast();
            watcher.setParentWatcher(parentWatcher);
            parentWatcher.addChild(watcher);
            if (parentWatcher.isPartOfAnonObjectGraph()) {
                watcher.setPartOfAnonObjectGraph(true);
            }
        }
        this.watcherList.addLast(watcher);
    }

    private FunctionReturnWatcher watchExpressionStringAsFunction(String value) {
        FunctionReturnWatcher watcher = new FunctionReturnWatcher(this.currentWatcherId++, this.currentBindingExpression, value, (ArgumentListNode)this.argumentListStack.peek());
        if (!this.watcherList.isEmpty()) {
            Watcher parentWatcher = (Watcher)this.watcherList.getLast();
            if (parentWatcher instanceof RepeaterDataProviderWatcher) {
                RepeaterItemWatcher repeaterItemWatcher = (RepeaterItemWatcher)parentWatcher.getChild("repeaterItem");
                if (repeaterItemWatcher == null) {
                    repeaterItemWatcher = new RepeaterItemWatcher(this.currentWatcherId++);
                    parentWatcher.addChild(repeaterItemWatcher);
                }
                repeaterItemWatcher.addChild(watcher);
                this.watcherList.addLast(repeaterItemWatcher);
            } else {
                watcher.setParentWatcher(parentWatcher);
                parentWatcher.addChild(watcher);
            }
        } else {
            this.dataBindingInfo.getRootWatchers().put(value + watcher.getId(), watcher);
        }
        String src = (String)this.srcTypeStack.peek();
        if (this.srcTypeStack.size() > 1 && src != null && this.srcTypeStack.firstElement() != src && this.watcherList.isEmpty()) {
            watcher.setClassName(src);
        }
        this.watcherList.addLast(watcher);
        return watcher;
    }

    private XMLWatcher watchExpressionStringAsXML(String value) {
        XMLWatcher watcher;
        if (this.watcherList.isEmpty()) {
            Map rootWatchers = this.dataBindingInfo.getRootWatchers();
            if (rootWatchers.containsKey(value)) {
                return null;
            }
            watcher = new XMLWatcher(this.currentWatcherId++, value);
            rootWatchers.put(value, watcher);
        } else {
            Watcher parentWatcher = (Watcher)this.watcherList.getLast();
            if (parentWatcher instanceof RepeaterDataProviderWatcher) {
                RepeaterItemWatcher repeaterItemWatcher = (RepeaterItemWatcher)parentWatcher.getChild("repeaterItem");
                if (repeaterItemWatcher == null) {
                    repeaterItemWatcher = new RepeaterItemWatcher(this.currentWatcherId++);
                    parentWatcher.addChild(repeaterItemWatcher);
                }
                watcher = new XMLWatcher(this.currentWatcherId++, value);
                repeaterItemWatcher.addChild(watcher);
                this.watcherList.addLast(repeaterItemWatcher);
            } else {
                PropertyWatcher child = parentWatcher.getChild(value);
                if (child instanceof XMLWatcher) {
                    watcher = (XMLWatcher)child;
                } else {
                    watcher = new XMLWatcher(this.currentWatcherId++, value);
                    parentWatcher.addChild(watcher);
                }
            }
        }
        String src = (String)this.srcTypeStack.peek();
        if (this.srcTypeStack.size() > 1 && src != null && this.srcTypeStack.firstElement() != src && this.watcherList.isEmpty()) {
            watcher.setClassName(src);
        }
        this.watcherList.addLast(watcher);
        watcher.addBindingExpression(this.currentBindingExpression);
        return watcher;
    }

    private PropertyWatcher watchExpressionStringAsProperty(String value) {
        PropertyWatcher watcher = null;
        if (this.watcherList.isEmpty()) {
            watcher = this.watchRootProperty(value);
        } else {
            Watcher parentWatcher = (Watcher)this.watcherList.getLast();
            if (parentWatcher instanceof RepeaterDataProviderWatcher) {
                RepeaterItemWatcher repeaterItemWatcher = (RepeaterItemWatcher)parentWatcher.getChild("repeaterItem");
                if (repeaterItemWatcher == null) {
                    repeaterItemWatcher = new RepeaterItemWatcher(this.currentWatcherId++);
                    parentWatcher.addChild(repeaterItemWatcher);
                } else {
                    watcher = repeaterItemWatcher.getChild(value);
                }
                if (watcher == null) {
                    watcher = new PropertyWatcher(this.currentWatcherId++, value);
                }
                repeaterItemWatcher.addChild(watcher);
                this.watcherList.addLast(repeaterItemWatcher);
            } else {
                watcher = parentWatcher.getChild(value);
                if (watcher == null) {
                    if (this.currentBindingExpression.isRepeatable() && parentWatcher instanceof PropertyWatcher && this.currentBindingExpression.getRepeaterLevel(((PropertyWatcher)parentWatcher).getProperty()) >= 0) {
                        if (value.equals("currentItem") || value.equals("currentIndex")) {
                            watcher = parentWatcher.getChild("dataProvider");
                            if (watcher == null) {
                                watcher = new RepeaterDataProviderWatcher(this.currentWatcherId++);
                                parentWatcher.addChild(watcher);
                            }
                        } else {
                            watcher = new PropertyWatcher(this.currentWatcherId++, value);
                            parentWatcher.addChild(watcher);
                        }
                    } else {
                        watcher = new PropertyWatcher(this.currentWatcherId++, value);
                        if (parentWatcher.isPartOfAnonObjectGraph()) {
                            watcher.setPartOfAnonObjectGraph(true);
                        } else if (!parentWatcher.getShouldWriteChildren()) {
                            watcher.setShouldWriteChildren(false);
                        }
                        parentWatcher.addChild(watcher);
                    }
                }
            }
        }
        this.watcherList.addLast(watcher);
        watcher.addBindingExpression(this.currentBindingExpression);
        return watcher;
    }

    private PropertyWatcher watchRootProperty(String propertyName) {
        PropertyWatcher result;
        Map rootWatchers = this.dataBindingInfo.getRootWatchers();
        String key = propertyName;
        String srcType = (String)this.srcTypeStack.peek();
        String className = null;
        if (this.srcTypeStack.size() > 1 && srcType != null && this.srcTypeStack.firstElement() != srcType) {
            className = srcType;
            key = className + "." + propertyName;
        }
        if ((result = (PropertyWatcher)rootWatchers.get(key)) == null) {
            Model destination = this.currentBindingExpression.getDestination();
            result = destination != null && destination.getRepeaterLevel() > 1 ? new RepeaterComponentWatcher(this.currentWatcherId++, propertyName, destination.getRepeaterLevel()) : new PropertyWatcher(this.currentWatcherId++, propertyName);
            if (className != null) {
                result.setClassName(className);
            }
            rootWatchers.put(key, result);
        }
        return result;
    }

    static {
        $assertionsDisabled = !DataBindingFirstPassEvaluator.class.desiredAssertionStatus();
    }

    public class UnableToDetectSquareBracketChanges
    extends CompilerMessage.CompilerWarning {
    }

    public class UnableToDetectXMLListChanges
    extends CompilerMessage.CompilerWarning {
        public String name;

        public UnableToDetectXMLListChanges(String name) {
            this.name = name;
        }
    }

    public class UnableToDetectChanges
    extends CompilerMessage.CompilerWarning {
        public String name;

        public UnableToDetectChanges(String name) {
            this.name = name;
        }
    }
}

