/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.managed;

import flex.messaging.config.ServicesDependencies;
import flex2.compiler.as3.genext.GenerativeFirstPassEvaluator;
import flex2.compiler.as3.managed.ManagedClassInfo;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class ManagedFirstPassEvaluator
extends GenerativeFirstPassEvaluator {
    private final Set metaData;
    private ManagedClassInfo currentInfo;
    private Map managedClasses;
    private ServicesDependencies servicesDependencies;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ManagedFirstPassEvaluator(TypeTable typeTable, Set metaData) {
        this(typeTable, metaData, null);
    }

    public ManagedFirstPassEvaluator(TypeTable typeTable, Set metaData, ServicesDependencies servicesDependencies) {
        super(typeTable);
        this.metaData = metaData;
        this.servicesDependencies = servicesDependencies;
    }

    public Map getClassMap() {
        return this.managedClasses != null ? this.managedClasses : Collections.EMPTY_MAP;
    }

    public boolean makeSecondPass() {
        return this.managedClasses != null;
    }

    public Value evaluate(Context context, ProgramNode programNode) {
        Iterator iter = this.metaData.iterator();
        while (iter.hasNext()) {
            MetaDataNode metaDataNode = (MetaDataNode)iter.next();
            if (!"Managed".equals(metaDataNode.id)) continue;
            if (metaDataNode.def instanceof ClassDefinitionNode) {
                ClassDefinitionNode classDef = (ClassDefinitionNode)metaDataNode.def;
                this.currentInfo = new ManagedClassInfo(context, this.typeTable.getSymbolTable(), NodeMagic.getClassName(classDef));
                String destination = metaDataNode.getValue("destination");
                this.registerLazyAssociations(destination, metaDataNode, classDef, context);
                this.evaluate(context, classDef);
                this.currentInfo = null;
                continue;
            }
            context.localizedWarning2(metaDataNode.pos(), new ManagedOnNonClassError());
        }
        return null;
    }

    public Value evaluate(Context context, ClassDefinitionNode node) {
        this.registerManagedClass(this.currentInfo);
        this.addManagedImports(context, node);
        if (node.statements != null) {
            if (node.instanceinits != null) {
                Iterator iterator = node.instanceinits.iterator();
                while (iterator.hasNext()) {
                    Node instanceinit = (Node)iterator.next();
                    instanceinit.evaluate(context, this);
                }
            }
            node.statements.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, FunctionDefinitionNode node) {
        boolean isGetter = NodeMagic.functionIsGetter(node);
        if ((isGetter || NodeMagic.functionIsSetter(node)) && ManagedFirstPassEvaluator.canManage(node)) {
            if (!$assertionsDisabled && this.currentInfo == null) {
                throw new AssertionError((Object)"currentInfo == null");
            }
            this.currentInfo.addAccessorFunction(node, false, isGetter);
        }
        return null;
    }

    public Value evaluate(Context context, VariableDefinitionNode node) {
        if (ManagedFirstPassEvaluator.canManage(node)) {
            if (!$assertionsDisabled && this.currentInfo == null) {
                throw new AssertionError((Object)"currentInfo == null");
            }
            this.currentInfo.addAccessorVariable(node, false);
        }
        return null;
    }

    private static boolean canManage(DefinitionNode def) {
        return def.attrs != null && def.attrs.hasAttribute("public") && !def.attrs.hasAttribute("static") && !def.attrs.hasAttribute("const");
    }

    private void registerLazyAssociations(String destination, MetaDataNode node, ClassDefinitionNode classNode, Context context) {
        if (destination != null) {
            if (this.servicesDependencies == null) {
                context.localizedWarning2(node.pos(), new LazyAssociationsRequireServicesConfiguration(classNode.name.name));
                return;
            }
            Set lazyAssociations = this.servicesDependencies.getLazyAssociations(destination);
            this.currentInfo.setTransientProperties(lazyAssociations);
        }
    }

    private void registerManagedClass(ManagedClassInfo info) {
        if (this.managedClasses == null) {
            this.managedClasses = new LinkedHashMap();
        }
        this.managedClasses.put(info.getClassName(), info);
    }

    private void addManagedImports(Context context, ClassDefinitionNode node) {
        NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_EVENT));
        NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_EVENTDISPATCHER));
        NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_PROPERTYCHANGEEVENT));
        NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_MANAGED));
        NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_UIDUTIL));
        NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.INTERFACE_IMANAGED));
        NodeMagic.addImport(context, node, NameFormatter.toDot("mx.core:mx_internal"));
    }

    static {
        $assertionsDisabled = !ManagedFirstPassEvaluator.class.desiredAssertionStatus();
    }

    public static class LazyAssociationsRequireServicesConfiguration
    extends CompilerMessage.CompilerWarning {
        public String className;

        public LazyAssociationsRequireServicesConfiguration(String className) {
            this.className = className;
        }
    }

    public static class ManagedOnNonClassError
    extends CompilerMessage.CompilerError {
    }
}

