/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flash.localization.LocalizationManager;
import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.Compiler;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.Transcoder;
import flex2.compiler.asdoc.ASDocConfigHandler;
import flex2.compiler.asdoc.ASDocExtension;
import flex2.compiler.asdoc.OverviewsHandler;
import flex2.compiler.asdoc.PumpStreamHandler;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.swc.Component;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.ASDocConfiguration;
import flex2.tools.CompcPreLink;
import flex2.tools.Compiler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class API {
    public static boolean forceWindows = System.getProperty("asdoc.windows") != null;
    public static boolean forceMac = System.getProperty("asdoc.mac") != null;
    public static boolean forceLinux = System.getProperty("asdoc.linux") != null;

    /*
     * Loose catch block
     */
    public static void createASDocConfig(ASDocConfiguration config) throws CompilerException {
        block15: {
            IOException ioe22;
            Reader reader;
            BufferedWriter writer;
            block14: {
                String templatesPath = config.getTemplatesPath();
                writer = null;
                reader = null;
                writer = new BufferedWriter(new FileWriter(templatesPath + "ASDoc_Config.xml"));
                reader = new BufferedReader(new FileReader(templatesPath + "ASDoc_Config_Base.xml"));
                ASDocConfigHandler h = new ASDocConfigHandler(writer, config);
                InputSource source = new InputSource(reader);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(source, (DefaultHandler)h);
                Object var9_10 = null;
                if (writer == null) break block14;
                try {
                    writer.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe22) {}
            }
            break block15;
            {
                catch (Exception e) {
                    if (Trace.error) {
                        e.printStackTrace();
                    }
                    CouldNotCreate c = new CouldNotCreate("ASDoc_Config.xml", e.getMessage());
                    ThreadLocalToolkit.log(c);
                    throw c;
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var9_11 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void createOverviews(ASDocConfiguration config) throws CompilerException {
        block15: {
            IOException ioe22;
            Reader reader;
            BufferedWriter writer;
            block14: {
                String templatesPath = config.getTemplatesPath();
                writer = null;
                reader = null;
                writer = new BufferedWriter(new FileWriter(templatesPath + "overviews.xml"));
                reader = new BufferedReader(new FileReader(templatesPath + "Overviews_Base.xml"));
                OverviewsHandler h = new OverviewsHandler(writer, config);
                InputSource source = new InputSource(reader);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(source, (DefaultHandler)h);
                Object var9_10 = null;
                if (writer == null) break block14;
                try {
                    writer.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe22) {}
            }
            break block15;
            {
                catch (Exception e) {
                    if (Trace.error) {
                        e.printStackTrace();
                    }
                    CouldNotCreate c = new CouldNotCreate("overviews.xml", e.getMessage());
                    ThreadLocalToolkit.log(c);
                    throw c;
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var9_11 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static void createTopLevelXML(ASDocConfiguration configuration, LocalizationManager l10n) throws ConfigurationException, CompilerException {
        Iterator iterator;
        StringBuffer sb;
        flex2.compiler.API.setupHeadless(configuration);
        String[] sourceMimeTypes = flex2.tools.API.getSourcePathMimeTypes();
        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
        SourcePath sourcePath = new SourcePath(sourceMimeTypes, compilerConfig.allowSourcePathOverlap());
        sourcePath.addPathElements(compilerConfig.getSourcePath());
        List[] array = flex2.compiler.API.getVirtualFileList(configuration.getDocSources(), new HashSet<String>(Arrays.asList(sourceMimeTypes)), sourcePath.getPaths());
        NameMappings mappings = flex2.compiler.API.getNameMappings(configuration);
        Transcoder[] transcoders = flex2.tools.API.getTranscoders(configuration);
        Compiler[] compilers = API.getCompilers(compilerConfig, mappings, transcoders);
        FileSpec fileSpec = new FileSpec(array[0], flex2.tools.API.getFileSpecMimeTypes(), false);
        SourceList sourceList = new SourceList(array[1], compilerConfig.getSourcePath(), null, flex2.tools.API.getSourcePathMimeTypes(), false);
        ResourceContainer resources = new ResourceContainer();
        ResourceBundlePath bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), null);
        HashMap classes = new HashMap();
        List nsComponents = flex2.compiler.swc.API.setupNamespaceComponents(configuration.getNamespaces(), mappings, sourcePath, classes, false);
        flex2.compiler.swc.API.setupClasses(configuration.getClasses(), sourcePath, classes);
        HashSet<String> includeOnly = null;
        if (configuration.excludeDependencies()) {
            includeOnly = new HashSet<String>();
            Iterator iterator2 = nsComponents.iterator();
            while (iterator2.hasNext()) {
                Component component = (Component)iterator2.next();
                includeOnly.add(component.getClassName());
            }
            includeOnly.addAll(configuration.getClasses());
        }
        List excludeClasses = configuration.getExcludeClasses();
        Set packages = configuration.getPackagesConfiguration().getPackageNames();
        ASDocExtension asdoc = new ASDocExtension(excludeClasses, includeOnly, packages);
        ((flex2.compiler.as3.Compiler)compilers[0]).addCompilerExtension(asdoc);
        ((flex2.compiler.mxml.Compiler)compilers[1]).addImplementationCompilerExtension(asdoc);
        if (ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.InitialSetup()));
        }
        CompilerSwcContext swcContext = new CompilerSwcContext();
        SwcCache cache = new SwcCache();
        cache.setLazyRead(true);
        swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, null, mappings, cache);
        if (ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.LoadedSWCs(swcContext.getNumberLoaded())));
        }
        configuration.addExterns(swcContext.getExterns());
        flex2.compiler.API.validateCompilationUnits(fileSpec, sourceList, sourcePath, bundlePath, resources, swcContext, null, false, configuration.getCompilerConfiguration().strict());
        Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
        flex2.compiler.API.compile(fileSpec, sourceList, classes.values(), sourcePath, resources, bundlePath, swcContext, configuration, compilers, new CompcPreLink(), licenseMap, new ArrayList());
        asdoc.finish();
        asdoc.saveFile(new File(configuration.getOutput(), "toplevel.xml"));
        if (excludeClasses.size() != 0) {
            sb = new StringBuffer();
            iterator = excludeClasses.iterator();
            while (iterator.hasNext()) {
                sb.append(' ');
                sb.append(iterator.next());
            }
            ThreadLocalToolkit.log(new NotFound("exclude-classes", sb.toString()));
        }
        if (packages.size() != 0) {
            sb = new StringBuffer();
            iterator = packages.iterator();
            while (iterator.hasNext()) {
                sb.append(' ');
                sb.append(iterator.next());
            }
            ThreadLocalToolkit.log(new NotFound("packages", sb.toString()));
        }
    }

    public static Compiler[] getCompilers(CompilerConfiguration compilerConfig, NameMappings mappings, Transcoder[] transcoders) {
        flex2.compiler.as3.Compiler asc = new flex2.compiler.as3.Compiler(compilerConfig);
        flex2.compiler.mxml.Compiler mxmlc = new flex2.compiler.mxml.Compiler(compilerConfig, compilerConfig, mappings, transcoders);
        flex2.compiler.abc.Compiler abc = new flex2.compiler.abc.Compiler(compilerConfig);
        flex2.compiler.i18n.Compiler prop = new flex2.compiler.i18n.Compiler(compilerConfig);
        flex2.compiler.css.Compiler css = new flex2.compiler.css.Compiler(compilerConfig, transcoders);
        return new Compiler[]{asc, mxmlc, abc, prop, css};
    }

    public static void createTopLevelClassesXML(String outputDir, String templatesPath) throws CompilerException {
        Process proc;
        try {
            String asDocHelper;
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows") || forceWindows) {
                asDocHelper = "asDocHelper.exe";
            } else if (osName.startsWith("mac os x") || forceMac) {
                asDocHelper = "asDocHelper";
            } else if (osName.indexOf("linux") != -1 || forceLinux) {
                asDocHelper = "asDocHelper.linux";
            } else {
                throw new UnknownOS();
            }
            File templatesFile = new File(templatesPath);
            Runtime r = Runtime.getRuntime();
            proc = r.exec(new String[]{templatesPath + asDocHelper, outputDir + "toplevel.xml", outputDir + "toplevel_classes.xml", templatesPath + "ASDoc_Config.xml"}, null, templatesFile);
            PumpStreamHandler streamHandler = new PumpStreamHandler();
            streamHandler.setProcessOutputStream(proc.getInputStream());
            streamHandler.setProcessErrorStream(proc.getErrorStream());
            streamHandler.start();
            proc.waitFor();
        }
        catch (Throwable t) {
            if (Trace.error) {
                t.printStackTrace();
            }
            CouldNotCreate c = new CouldNotCreate("toplevel.xml", t.getMessage());
            ThreadLocalToolkit.log(c);
            throw c;
        }
        if (proc.exitValue() != 0) {
            CouldNotCreate c = new CouldNotCreate("toplevel.xml", "");
            ThreadLocalToolkit.log(c);
            throw c;
        }
    }

    /*
     * Loose catch block
     */
    public static void createHTML(String outputDir, String templatesDir, ASDocConfiguration config) throws CompilerException {
        block21: {
            templatesDir = templatesDir.replace('\\', '/');
            File indexTmp = new File(outputDir + "index.tmp");
            String[] args = new String[]{"-in", templatesDir + "index.html", "-xsl", templatesDir + "processHTML.xsl", "-out", indexTmp.toString()};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", templatesDir + "package-frame.html", "-xsl", templatesDir + "processHTML.xsl", "-out", outputDir + "package-frame.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", templatesDir + "index-list.html", "-xsl", templatesDir + "processHTML.xsl", "-out", outputDir + "index-list.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", templatesDir + "title-bar.html", "-xsl", templatesDir + "processHTML.xsl", "-out", outputDir + "title-bar.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", templatesDir + "mxml-tags.html", "-xsl", templatesDir + "processHTML.xsl", "-out", outputDir + "mxml-tags.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "class-files.xsl", "-param", "outputPath", outputDir, "-param", "showExamples", "true", "-param", "showIncludeExamples", "true"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "all-classes.xsl", "-out", outputDir + "all-classes.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "package-list.xsl", "-out", outputDir + "package-list.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "class-summary.xsl", "-param", "overviewsFile", templatesDir + "overviews.xml", "-out", outputDir + "class-summary.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "package-detail.xsl", "-param", "overviewsFile", templatesDir + "overviews.xml", "-param", "outputPath", outputDir};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "package-summary.xsl", "-param", "overviewsFile", templatesDir + "overviews.xml", "-out", outputDir + "package-summary.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "class-list.xsl", "-param", "outputPath", outputDir};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "all-index.xsl", "-param", "overviewsFile", templatesDir + "overviews.xml", "-param", "outputPath", outputDir};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "package.xsl", "-param", "outputPath", outputDir};
            org.apache.xalan.xslt.Process.main((String[])args);
            args = new String[]{"-in", outputDir + "toplevel_classes.xml", "-xsl", templatesDir + "appendixes.xsl", "-param", "overviewsFile", templatesDir + "overviews.xml", "-out", outputDir + "appendixes.html"};
            org.apache.xalan.xslt.Process.main((String[])args);
            File indexHtml = new File(outputDir + "index.html");
            if (config.getLeftFramesetWidth() == -1) {
                FileUtils.renameFile((File)indexTmp, (File)indexHtml);
            } else {
                IOException ioe22;
                File indexTmp2;
                BufferedWriter writer;
                BufferedReader reader;
                block19: {
                    String s;
                    reader = null;
                    writer = null;
                    indexTmp2 = new File(outputDir + "index2.tmp");
                    reader = new BufferedReader(new FileReader(indexTmp));
                    writer = new BufferedWriter(new FileWriter(indexTmp2));
                    boolean foundFrameset = false;
                    String search1 = "frameset cols=";
                    String search2 = ",";
                    while ((s = reader.readLine()) != null) {
                        int ind;
                        if (!foundFrameset && (ind = s.indexOf(search1)) != -1) {
                            foundFrameset = true;
                            int ind2 = s.indexOf(search2, ind);
                            if (ind2 != -1) {
                                s = s.substring(0, ind + search1.length() + 1) + config.getLeftFramesetWidth() + s.substring(ind2);
                            }
                        }
                        writer.write(s);
                        writer.newLine();
                    }
                    Object var16_17 = null;
                    if (writer == null) break block19;
                    try {
                        writer.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                FileUtils.renameFile((File)indexTmp2, (File)indexHtml);
                {
                    break block21;
                    catch (Exception ex) {
                        if (Trace.error) {
                            ex.printStackTrace();
                        }
                        CouldNotCreate c = new CouldNotCreate("index.html", ex.getMessage());
                        ThreadLocalToolkit.log(c);
                        throw c;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe22;
                    Object var16_18 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioe22) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe22) {
                            // empty catch block
                        }
                    }
                    FileUtils.renameFile((File)indexTmp2, (File)indexHtml);
                    throw throwable;
                }
            }
        }
    }

    public static void copyFiles(String outputDir, String templatesPath) throws IOException {
        File templateFile = new File(templatesPath);
        File[] temArr = templateFile.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).endsWith(".js") || name.endsWith(".css");
            }
        });
        for (int i = 0; i < temArr.length; ++i) {
            File f = temArr[i];
            API.copyFile(new File(templatesPath, f.getName()), new File(outputDir, f.getName()));
        }
        File outImages = new File(outputDir, "images");
        outImages.mkdir();
        File temImages = new File(templatesPath, "images");
        File[] imageArr = temImages.listFiles();
        for (int i = 0; i < imageArr.length; ++i) {
            File f = imageArr[i];
            API.copyFile(new File(temImages, f.getName()), new File(outImages, f.getName()));
        }
    }

    public static void copyFile(File fromFile, File toFile) throws IOException {
        int i;
        FileInputStream fileInputStream = new FileInputStream(fromFile);
        FileOutputStream fileOutputStream = new FileOutputStream(toFile);
        byte[] bytes = new byte[2048];
        while ((i = fileInputStream.read(bytes)) != -1) {
            fileOutputStream.write(bytes, 0, i);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void removeXML(String outputDir, String templatesPath) {
        new File(templatesPath + "ASDoc_Config.xml").delete();
        new File(templatesPath + "overviews.xml").delete();
        new File(outputDir + "index.tmp").delete();
        new File(outputDir + "index2.tmp").delete();
        new File(outputDir + "toplevel.xml").delete();
        new File(outputDir + "toplevel_classes.xml").delete();
    }

    public static class NotFound
    extends CompilerMessage.CompilerWarning {
        public String property;
        public String names;

        public NotFound(String property, String names) {
            this.property = property;
            this.names = names;
        }
    }

    public static class UnknownOS
    extends CompilerMessage.CompilerError {
    }

    public static class CouldNotCreate
    extends CompilerMessage.CompilerError {
        public String file;
        public String message;

        public CouldNotCreate(String file, String message) {
            this.file = file;
            this.message = message;
        }
    }
}

