/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.util.NameFormatter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.util.ObjectList;

public class ASDocExtension
implements Extension {
    private static String EXCLUDE_CLASS = "ExcludeClass";
    private StringBuffer out;
    private String xml;
    private List excludeClasses;
    private Set includeOnly;
    private Set packages;

    public ASDocExtension(List excludeClasses, Set includeOnly, Set packages) {
        this.excludeClasses = excludeClasses;
        this.includeOnly = includeOnly;
        this.packages = packages;
        this.out = new StringBuffer();
        this.out.append("<asdoc>\n");
    }

    public void finish() {
        this.out.append("\n</asdoc>\n");
        this.xml = this.out.toString();
        this.out = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveFile(File file) {
        BufferedOutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                outputStream.write(this.xml.getBytes("UTF-8"));
                outputStream.flush();
            }
            catch (IOException ex) {
                if (!Trace.error) throw new RuntimeException("Could not save " + file + ": " + ex);
                ex.printStackTrace();
                throw new RuntimeException("Could not save " + file + ": " + ex);
            }
            Object var5_3 = null;
            if (Trace.asdoc) {
                System.out.println("Wrote doc file: " + file);
            }
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (Trace.asdoc) {
                System.out.println("Wrote doc file: " + file);
            }
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        outputStream.close();
        return;
    }

    public String getXML() {
        return this.xml;
    }

    public void parse1(CompilationUnit unit, TypeTable typeTable) {
    }

    public void parse2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze1(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze3(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze4(CompilationUnit unit, TypeTable typeTable) {
    }

    public void generate(CompilationUnit unit, TypeTable typeTable) {
        Context flexCx = unit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)flexCx.getAttribute("cx");
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        String className = NameFormatter.toDot(unit.topLevelDefinitions.first());
        boolean exclude = false;
        if (this.includeOnly != null && !this.includeOnly.contains(className)) {
            exclude = true;
        } else if (this.excludeClasses.contains(className)) {
            this.excludeClasses.remove(className);
            exclude = true;
        } else if (unit.metadata != null) {
            Iterator iterator = unit.metadata.iterator();
            while (iterator.hasNext()) {
                MetaDataNode metaDataNode = (MetaDataNode)iterator.next();
                if (!EXCLUDE_CLASS.equals(metaDataNode.id)) continue;
                exclude = true;
                break;
            }
        }
        if (!exclude && !unit.getSource().isInternal()) {
            String n;
            if (Trace.asdoc) {
                System.out.println("Generating XML for " + unit.getSource().getName());
            }
            if (this.packages.size() != 0 && (n = unit.topLevelDefinitions.first().getNamespace()) != null) {
                this.packages.remove(n);
            }
            cx.pushScope(node.frame);
            MetaDataEvaluator printer = new MetaDataEvaluator();
            node.evaluate(cx, printer);
            ObjectList<DocCommentNode> comments = printer.doccomments;
            int numComments = comments.size();
            for (int x = 0; x < numComments; ++x) {
                ((DocCommentNode)comments.get(x)).emit(cx, this.out);
            }
            cx.popScope();
        } else if (Trace.asdoc) {
            System.out.println("Skipping generating XML for " + unit.getSource().getName());
        }
    }
}

