/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flash.util.FileUtils;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.ConfigurationException;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.common.MetadataConfiguration;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Configuration
implements flex2.linker.Configuration {
    private String debugPassword;
    private boolean scriptLimitsSet = false;
    private boolean useNetwork;
    private int backgroundColor = 5272190;
    private int frameRate = 24;
    private String height = null;
    private String heightPercent = null;
    private int defaultHeight = 375;
    private int scriptLimit = 60;
    private int scriptRecursionLimit = 1000;
    private String width = null;
    private String widthPercent = null;
    private int defaultWidth = 500;
    private boolean lazyInit = false;
    private String pageTitle = null;
    private Set externs = new HashSet();
    private Set includes = new HashSet();
    private Set unresolved = new HashSet();
    private SortedSet resourceBundles = new TreeSet();
    private MetadataConfiguration metadataConfiguration;
    protected ConfigurationPathResolver configResolver;
    private String metadata = null;
    private String linkReportFileName = null;
    private String rbListFileName = null;
    private static Map aliases = null;
    private CompilerConfiguration compiler;
    private FramesConfiguration frames;
    private String rootClassName;
    private String mainDefinition;
    public boolean generateFrameLoader = true;
    private List rslList = new LinkedList();
    private boolean benchmark = false;

    public Configuration() {
        this.compiler = new CompilerConfiguration();
        this.frames = new FramesConfiguration();
        this.metadataConfiguration = new MetadataConfiguration();
    }

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
        this.compiler.setConfigPathResolver(resolver);
    }

    public int backgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void cfgDefaultBackgroundColor(ConfigurationValue cv, int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static ConfigurationInfo getDefaultBackgroundColorInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "default background color (may be overridden by the application code)";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgUseNetwork(ConfigurationValue cv, boolean b) {
        this.useNetwork = b;
    }

    public boolean useNetwork() {
        return this.useNetwork;
    }

    public static ConfigurationInfo getUseNetworkInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "toggle whether the SWF is flagged for access to network resources";
            }
        };
    }

    public int getScriptTimeLimit() {
        return this.scriptLimit;
    }

    public boolean scriptLimitsSet() {
        return this.scriptLimitsSet;
    }

    public void setScriptTimeLimit(int scriptLimit) {
        this.scriptLimitsSet = true;
        this.scriptLimit = scriptLimit;
    }

    public int getScriptRecursionLimit() {
        return this.scriptRecursionLimit;
    }

    public void setScriptRecursionLimit(int recursionLimit) {
        this.scriptLimitsSet = true;
        this.scriptRecursionLimit = recursionLimit;
    }

    public void cfgDefaultScriptLimits(ConfigurationValue cv, int maxRecursionDepth, int maxExecutionTime) throws ConfigurationException {
        if (maxRecursionDepth <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        if (maxExecutionTime <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.scriptLimitsSet = true;
        this.scriptLimit = maxExecutionTime;
        this.scriptRecursionLimit = maxRecursionDepth;
    }

    public static ConfigurationInfo getDefaultScriptLimitsInfo() {
        return new ConfigurationInfo(new String[]{"max-recursion-depth", "max-execution-time"}){

            public String getDescription() {
                return "default script execution limits (may be overridden by root attributes)";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void setGenerateDebugTags(boolean generateDebugTags) {
        this.compiler.setGenerateDebugTags(generateDebugTags);
    }

    public boolean generateDebugTags() {
        return this.compiler.generateDebugTags();
    }

    public boolean optimize() {
        return this.compiler.optimize();
    }

    public boolean keepDebugOpcodes() {
        return this.compiler.debug();
    }

    public void setKeepDebugOpcodes(boolean keepDebugOpcodes) {
        this.compiler.setKeepDebugOpcodes(keepDebugOpcodes);
    }

    public String debugPassword() {
        return this.debugPassword;
    }

    public void cfgDebugPassword(ConfigurationValue cv, String debugPassword) {
        this.debugPassword = debugPassword;
    }

    public void setDebugPassword(String debugPassword) {
        this.debugPassword = debugPassword;
    }

    public static ConfigurationInfo getDebugPasswordInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }

            public String getDescription() {
                return "the password to include in debuggable SWFs";
            }
        };
    }

    public MetadataConfiguration getMetadataConfiguration() {
        return this.metadataConfiguration;
    }

    public void cfgRawMetadata(ConfigurationValue cv, String xml) throws ConfigurationException {
        if (this.metadata != null) {
            throw new ConfigurationException.BadMetadataCombo(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.metadata = xml;
    }

    public String getMetadata() {
        return this.metadata == null ? this.getMetadataConfiguration().toString() : this.metadata;
    }

    public static ConfigurationInfo getRawMetadataInfo() {
        return new ConfigurationInfo(1, "text"){

            public String getDescription() {
                return "XML text to store in the SWF metadata (overrides metadata.* configuration)";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgDefaultSize(ConfigurationValue cv, int width, int height) throws ConfigurationException {
        if (width < 1 || width > 4096 || height < 1 || height > 4096) {
            throw new ConfigurationException.IllegalDimensions(width, height, cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.defaultWidth = width;
        this.defaultHeight = height;
    }

    public static ConfigurationInfo getDefaultSizeInfo() {
        return new ConfigurationInfo(new String[]{"width", "height"}){

            public String getDescription() {
                return "default application size (may be overridden by root attributes in the application)";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public String width() {
        return this.width;
    }

    public int defaultWidth() {
        return this.defaultWidth;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String height() {
        return this.height;
    }

    public int defaultHeight() {
        return this.defaultHeight;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String widthPercent() {
        return this.widthPercent;
    }

    public void setWidthPercent(String widthPercent) {
        this.widthPercent = widthPercent;
    }

    public String heightPercent() {
        return this.heightPercent;
    }

    public void setHeightPercent(String heightPercent) {
        this.heightPercent = heightPercent;
    }

    public String pageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String title) {
        this.pageTitle = title;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int rate) {
        this.frameRate = rate;
    }

    public void cfgDefaultFrameRate(ConfigurationValue cv, int rate) throws ConfigurationException {
        if (rate <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.frameRate = rate;
    }

    public static ConfigurationInfo getDefaultFrameRateInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "default frame rate to be used in the SWF.";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public boolean lazyInit() {
        return this.lazyInit;
    }

    public void cfgLazyInit(ConfigurationValue cv, boolean b) {
        this.lazyInit = b;
    }

    public static ConfigurationInfo getLazyInitInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "Enable/Disable ABC bytecode lazy initialization";
            }

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgExterns(ConfigurationValue cfgval, List vals) {
        Iterator it = vals.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (name.indexOf(58) == -1 && name.indexOf(46) != -1) {
                int dot = name.lastIndexOf(46);
                name = name.substring(0, dot) + ':' + name.substring(dot + 1);
            }
            this.externs.add(name);
        }
    }

    public static ConfigurationInfo getExternsInfo() {
        return new ConfigurationInfo(-1, "symbol"){

            public boolean allowMultiple() {
                return true;
            }

            public String getDescription() {
                return "a list of symbols to omit from linking when building a SWF";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public Set getExterns() {
        Set compilerExterns = this.compiler.getExterns();
        if (compilerExterns != null) {
            this.externs.addAll(compilerExterns);
        }
        return this.externs;
    }

    public void addExterns(Collection externs) {
        this.externs.addAll(externs);
    }

    public void addIncludes(Collection includes) {
        this.includes.addAll(includes);
    }

    public Set getIncludes() {
        return this.includes;
    }

    public void cfgIncludes(ConfigurationValue cfgval, List vals) {
        Iterator it = vals.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (name.indexOf(58) == -1 && name.indexOf(46) != -1) {
                int dot = name.lastIndexOf(46);
                name = name.substring(0, dot) + ':' + name.substring(dot + 1);
            }
            this.includes.add(name);
        }
    }

    public static ConfigurationInfo getIncludesInfo() {
        return new ConfigurationInfo(-1, "symbol"){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgLoadExterns(ConfigurationValue cfgval, String filename) throws ConfigurationException {
        VirtualFile f = ConfigurationPathResolver.getVirtualFile(filename, this.configResolver, cfgval);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(f.getInputStream(), new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("def".equals(qName) || "pre".equals(qName) || "ext".equals(qName)) {
                        String id = attributes.getValue("id");
                        Configuration.this.externs.add(id);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new ConfigurationException.ConfigurationIOError(filename, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
    }

    public static ConfigurationInfo getLoadExternsInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean allowMultiple() {
                return true;
            }

            public String getDescription() {
                return "an XML file containing <def>, <pre>, and <ext> symbols to omit from linking when building a SWF";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public Set getUnresolved() {
        return this.unresolved;
    }

    public void cfgLinkReport(ConfigurationValue cv, String filename) {
        this.linkReportFileName = cv.getContext() == null ? filename : FileUtils.addPathComponents((String)cv.getContext(), (String)filename, (char)File.separatorChar);
    }

    public static ConfigurationInfo getLinkReportInfo() {
        return new ConfigurationInfo(new String[]{"filename"}){

            public String getDescription() {
                return "Output a XML-formatted report of all definitions linked into the application.";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public String getLinkReportFileName() {
        return this.linkReportFileName;
    }

    public boolean generateLinkReport() {
        return this.linkReportFileName != null;
    }

    public void cfgResourceBundleList(ConfigurationValue cv, String filename) {
        this.rbListFileName = cv.getContext() == null ? filename : FileUtils.addPathComponents((String)cv.getContext(), (String)filename, (char)File.separatorChar);
    }

    public static ConfigurationInfo getResourceBundleListInfo() {
        return new ConfigurationInfo(new String[]{"filename"}){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public String getRBListFileName() {
        return this.rbListFileName;
    }

    public boolean generateRBList() {
        return this.rbListFileName != null;
    }

    public SortedSet getResourceBundles() {
        return this.resourceBundles;
    }

    public static Map getAliases() {
        if (aliases == null) {
            aliases = new HashMap();
            aliases.put("l", "compiler.library-path");
            aliases.put("el", "compiler.external-library-path");
            aliases.put("sp", "compiler.source-path");
            aliases.put("rsl", "runtime-shared-libraries");
            aliases.put("keep", "compiler.keep-generated-actionscript");
            aliases.put("o", "output");
        }
        return aliases;
    }

    public CompilerConfiguration getCompilerConfiguration() {
        return this.compiler;
    }

    public FramesConfiguration getFramesConfiguration() {
        return this.frames;
    }

    public List getFrameList() {
        return this.frames.getFrameList();
    }

    public void setRootClassName(String rootClassName) {
        this.rootClassName = rootClassName;
    }

    public String getRootClassName() {
        return this.rootClassName != null ? this.rootClassName : this.mainDefinition;
    }

    public void setMainDefinition(String mainDefinition) {
        this.mainDefinition = mainDefinition;
    }

    public String getMainDefinition() {
        return this.mainDefinition;
    }

    public void cfgGenerateFrameLoader(ConfigurationValue cv, boolean value) {
        this.generateFrameLoader = value;
    }

    public static ConfigurationInfo getGenerateFrameLoaderInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "toggle generation of an IFlexModuleFactory-derived loader class";
            }

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public List getRuntimeSharedLibraries() {
        return this.rslList;
    }

    public void cfgRuntimeSharedLibraries(ConfigurationValue cfgval, String[] urls) throws ConfigurationException {
        for (int i = 0; i < urls.length; ++i) {
            this.rslList.add(urls[i]);
        }
    }

    public static ConfigurationInfo getRuntimeSharedLibrariesInfo() {
        return new ConfigurationInfo(-1, new String[]{"url"}){

            public String getDescription() {
                return "a list of runtime shared library URLs to be loaded before the application starts";
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public boolean benchmark() {
        return this.benchmark;
    }

    public void cfgBenchmark(ConfigurationValue cv, boolean b) {
        this.benchmark = b;
    }

    public static ConfigurationInfo getBenchmarkInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "output performance benchmark";
            }

            public boolean isAdvanced() {
                return false;
            }
        };
    }

    public String[] getMetadataToKeep() {
        return this.getCompilerConfiguration().getKeepAs3Metadata();
    }
}

