/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flash.fonts.FontManager;
import flash.fonts.JREFontManager;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class FontsConfiguration {
    private String max_cached_fonts;
    private String max_glyphs_per_face;
    private List managers;
    private FontManager topLevelManager;
    private Languages languages = new Languages();
    private CompilerConfiguration compilerConfig;
    private boolean flashType;
    private ConfigurationPathResolver configResolver;
    private VirtualFile localFontsSnapshot = null;

    public void setCompilerConfiguration(CompilerConfiguration compilerConfig) {
        this.compilerConfig = compilerConfig;
    }

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public void cfgLocalFontsSnapshot(ConfigurationValue cv, String localFontsSnapshotPath) throws ConfigurationException {
        this.localFontsSnapshot = ConfigurationPathResolver.getVirtualFile(localFontsSnapshotPath, this.configResolver, cv);
    }

    public static ConfigurationInfo getLocalFontsSnapshotInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public VirtualFile getLocalFontsSnapshot() {
        return this.localFontsSnapshot;
    }

    public void cfgFlashType(ConfigurationValue cv, boolean val) {
        this.flashType = val;
    }

    public boolean getFlashType() {
        return this.flashType;
    }

    public static ConfigurationInfo getFlashTypeInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "Enables FlashType for embedded fonts, which provides greater clarity for small fonts.";
            }
        };
    }

    public void cfgMaxCachedFonts(ConfigurationValue cv, String val) {
        this.max_cached_fonts = val;
    }

    public static ConfigurationInfo getMaxCachedFontsInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public String getMaxCachedFonts() {
        return this.max_cached_fonts;
    }

    public void cfgMaxGlyphsPerFace(ConfigurationValue cv, String val) {
        this.max_glyphs_per_face = val;
    }

    public String getMaxGlyphsPerFace() {
        return this.max_glyphs_per_face;
    }

    public void cfgManagers(ConfigurationValue cv, List l) {
        this.managers = l;
    }

    public List getManagers() {
        return this.managers;
    }

    public FontManager getTopLevelManager() {
        if (this.topLevelManager == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("max-cached-fonts", this.max_cached_fonts);
            map.put("max-glyphs-per-face", this.max_glyphs_per_face);
            if (this.localFontsSnapshot != null) {
                map.put(JREFontManager.LOCAL_FONTS_SNAPSHOT, this.localFontsSnapshot.getName());
            }
            this.topLevelManager = FontManager.create((List)this.managers, map);
            if (this.topLevelManager != null) {
                this.topLevelManager.setLanguageRange((Properties)this.languages);
            }
        }
        return this.topLevelManager;
    }

    public static ConfigurationInfo getManagersInfo() {
        return new ConfigurationInfo(-1, "manager-class"){

            public boolean isAdvanced() {
                return true;
            }

            public String getDescription() {
                return "Compiler font manager classes, in policy resolution order";
            }
        };
    }

    public Languages getLanguagesConfiguration() {
        return this.languages;
    }

    public static class Languages
    extends Properties {
        public void cfgLanguageRange(ConfigurationValue cv, String lang, String range) {
            this.setProperty(lang, range);
        }

        public static ConfigurationInfo getLanguageRangeInfo() {
            return new ConfigurationInfo(new String[]{"lang", "range"}){

                public boolean allowMultiple() {
                    return true;
                }

                public boolean isAdvanced() {
                    return true;
                }

                public String getDescription() {
                    return "a range to restrict the number of font glyphs embedded into the SWF";
                }
            };
        }
    }
}

