/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.FontFaceRule;
import flash.css.Rule;
import flash.css.StyleDeclaration;
import flash.util.Trace;
import flex2.compiler.Source;
import flex2.compiler.css.StyleDef;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.util.DualModeLineNumberMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StyleModule {
    private String name;
    private List fontFaceRules;
    private Map styleDefs;
    private Source source;
    private Object perCompileData;
    private Map atEmbeds = new HashMap();
    private DualModeLineNumberMap lineNumberMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StyleModule(String name, Source source, Object perCompileData) {
        this.name = name;
        this.source = source;
        this.perCompileData = perCompileData;
        this.fontFaceRules = new ArrayList();
        this.styleDefs = new HashMap();
    }

    public void addFontFaceRule(FontFaceRule fontFaceRule) {
        boolean italic;
        boolean bold;
        if (!$assertionsDisabled && fontFaceRule == null) {
            throw new AssertionError();
        }
        String family = fontFaceRule.getFamily();
        if (FontFaceRule.getRule(this.fontFaceRules, family, bold = fontFaceRule.isBold(), italic = fontFaceRule.isItalic()) == null) {
            this.fontFaceRules.add(fontFaceRule);
            String propName = "_embed__font_" + family + "_" + (bold ? "bold" : "medium") + "_" + (italic ? "italic" : "normal");
            Map embedParams = fontFaceRule.getEmbedParams();
            StyleDeclaration styleDeclaration = fontFaceRule.getStyle();
            String path = styleDeclaration.getPath();
            if (path.indexOf(92) > -1) {
                embedParams.put("_file", path.replace('\\', '/'));
                embedParams.put("_pathsep", "true");
            } else {
                embedParams.put("_file", path);
            }
            embedParams.put("_line", Integer.toString(styleDeclaration.getLineNumber()));
            AtEmbed atEmbed = AtEmbed.create(propName, fontFaceRule.getStyle().getLineNumber(), embedParams, false);
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        } else if (Trace.font) {
            Trace.trace((String)("Font face already existed for " + family + " bold? " + bold + " italic? " + italic));
        }
    }

    public void addSelector(String name, boolean isTypeSelector, Rule rule) {
        StyleDef styleDef = (StyleDef)this.styleDefs.get(name);
        if (styleDef == null) {
            styleDef = new StyleDef(name, isTypeSelector, this.source, this.perCompileData);
            this.styleDefs.put(name, styleDef);
        }
        styleDef.addRule(rule);
    }

    public Collection getAtEmbeds() {
        Iterator styleDefIterator = this.styleDefs.values().iterator();
        while (styleDefIterator.hasNext()) {
            StyleDef styleDef = (StyleDef)styleDefIterator.next();
            Iterator atEmbedIterator = styleDef.getAtEmbeds().iterator();
            while (atEmbedIterator.hasNext()) {
                AtEmbed atEmbed = (AtEmbed)atEmbedIterator.next();
                if (this.atEmbeds.containsKey(atEmbed.getPropName())) continue;
                this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
            }
        }
        return this.atEmbeds.values();
    }

    public List getFontFaceRules() {
        return this.fontFaceRules;
    }

    public Set getImports() {
        HashSet result = new HashSet();
        Iterator styleDefIterator = this.styleDefs.values().iterator();
        while (styleDefIterator.hasNext()) {
            StyleDef styleDef = (StyleDef)styleDefIterator.next();
            result.addAll(styleDef.getImports());
        }
        return result;
    }

    public DualModeLineNumberMap getLineNumberMap() {
        return this.lineNumberMap;
    }

    public String getName() {
        return this.name;
    }

    public Collection getStyleDefs() {
        return this.styleDefs.values();
    }

    public void setLineNumberMap(DualModeLineNumberMap lineNumberMap) {
        this.lineNumberMap = lineNumberMap;
    }

    static {
        $assertionsDisabled = !StyleModule.class.desiredAssertionStatus();
    }
}

