/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.i18n;

import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.Source;
import flex2.compiler.SourcePath;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.i18n.TranslationFormat;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.IOException;

public class I18nUtils {
    public static String CLASS_SUFFIX = "_properties";

    public static Source getResourceBundleSource(String packageName, String className, ResourceBundlePath bundlePath, SourcePath sourcePath, CompilerSwcContext swcContext) throws CompilerException {
        Source s;
        if (className.endsWith(CLASS_SUFFIX)) {
            className = className.substring(0, className.length() - CLASS_SUFFIX.length());
        }
        if ((s = bundlePath.findSource(packageName, className)) == null && (s = swcContext.getSource(packageName, className + CLASS_SUFFIX)) == null && (s = sourcePath.findSource(packageName, className)) == null) {
            s = swcContext.getSource(packageName, className);
        }
        return s;
    }

    public static Source getGeneratedLocale(Configuration configuration) {
        Source source = null;
        String locale = configuration.getCompilerConfiguration().locale();
        if (locale != null) {
            String packageName = "mx.generated";
            String className = "GeneratedLocale";
            String lineSep = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            sb.append("package " + packageName + lineSep + "{" + lineSep + "    import mx.resources.Locale;" + lineSep + "    [ExcludeClass]" + lineSep + "    public class " + className + " extends mx.resources.Locale" + lineSep + "    {" + lineSep + "        public function " + className + "()" + lineSep + "        {" + lineSep + "\t\t      super(\"" + locale + "\");" + lineSep + "        }" + lineSep + "    }" + lineSep + "}");
            String parentName = "mx" + File.separator + "generated";
            String relativePath = "mx/generated";
            source = new Source((VirtualFile)new TextFile(sb.toString(), parentName + File.separator + className + ".as", parentName, "text/as"), relativePath, null, false, false, false);
            source.setPathResolver(null);
            String generatedDir = configuration.getCompilerConfiguration().getGeneratedDirectory();
            if (generatedDir != null) {
                try {
                    FileUtils.writeClassToFile((String)generatedDir, (String)packageName, (String)(className + ".as"), (String)sb.toString());
                }
                catch (IOException ioe) {
                    if (Trace.error) {
                        ioe.printStackTrace();
                    }
                    ThreadLocalToolkit.logError(ioe.toString());
                }
            }
        }
        return source;
    }

    public static TranslationFormat getTranslationFormat(CompilerConfiguration config) {
        TranslationFormat format = null;
        try {
            Class<?> formatCls = Class.forName(config.getTranslationFormat(), true, Thread.currentThread().getContextClassLoader());
            format = (TranslationFormat)formatCls.newInstance();
        }
        catch (Exception e) {
            ThreadLocalToolkit.logError(e.toString());
        }
        return format;
    }
}

