/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.swf.Action;
import flash.swf.Dictionary;
import flash.swf.Header;
import flash.swf.Tag;
import flash.swf.TagDecoder;
import flash.swf.TagHandler;
import flash.swf.TagValues;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineScalingGrid;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.swf.tags.DoAction;
import flash.swf.tags.DoInitAction;
import flash.swf.tags.ExportAssets;
import flash.swf.tags.PlaceObject;
import flash.swf.types.ButtonCondAction;
import flash.swf.types.Rect;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.media.AbstractTranscoder;
import flex2.compiler.media.FontTranscoder;
import flex2.compiler.media.ImageTranscoder;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MovieTranscoder
extends AbstractTranscoder {
    public static final String SYMBOL = "symbol";
    private Map dictionaryMap = new HashMap();
    private Map embedProps = new HashMap();

    public MovieTranscoder() {
        super(new String[]{"application/x-shockwave-flash"}, null, false);
    }

    public boolean isSupportedAttribute(String attr) {
        return SYMBOL.equals(attr) || "scaleGridTop".equals(attr) || "scaleGridLeft".equals(attr) || "scaleGridBottom".equals(attr) || "scaleGridRight".equals(attr) || "fontName".equals(attr) || "fontFamily".equals(attr) || "fontWeight".equals(attr) || "fontStyle".equals(attr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transcoder.TranscodingResults doTranscode(PathResolver context, Map args, String className, boolean generateSource) throws TranscoderException {
        Transcoder.TranscodingResults transcodingResults;
        Transcoder.TranscodingResults results = new Transcoder.TranscodingResults(this.resolveSource(context, args));
        BufferedInputStream swfIn = null;
        try {
            try {
                swfIn = new BufferedInputStream(results.assetSource.getInputStream());
                String symbolName = (String)args.get(SYMBOL);
                String fontName = (String)args.get("fontName");
                String fontFamily = (String)args.get("fontFamily");
                String fontWeight = (String)args.get("fontWeight");
                String fontStyle = (String)args.get("fontStyle");
                if (fontName == null) {
                    fontName = fontFamily;
                }
                if (fontName != null) {
                    if (symbolName != null) {
                        throw new AbstractTranscoder.IncompatibleTranscoderParameters(SYMBOL, "fontName");
                    }
                    this.extractDefineFont(results, swfIn, fontName, FontTranscoder.isBold(fontWeight), FontTranscoder.isItalic(fontStyle));
                    if (generateSource) {
                        this.generateSource(results, className, args, this.embedProps);
                    }
                } else if (symbolName != null) {
                    if (fontWeight != null) {
                        throw new AbstractTranscoder.IncompatibleTranscoderParameters(SYMBOL, "fontWeight");
                    }
                    if (fontStyle != null) {
                        throw new AbstractTranscoder.IncompatibleTranscoderParameters(SYMBOL, "fontStyle");
                    }
                    this.extractDefineTag(results, swfIn, symbolName, args);
                    if (generateSource) {
                        this.generateSource(results, className, args, this.embedProps);
                    }
                } else {
                    results.defineTag = new DefineSprite();
                    if (!generateSource) throw new AbstractTranscoder.EmbedRequiresCodegen(results.assetSource.getName(), className);
                    this.generateTopLevelLoaderSource(results, className, args, this.getSwfSize(swfIn));
                }
                if (args.containsKey("scaleGridLeft") || args.containsKey("scaleGridRight") || args.containsKey("scaleGridTop") || args.containsKey("scaleGridBottom")) {
                    if (!(results.defineTag instanceof DefineSprite)) {
                        throw new BadScalingGridTarget(TagValues.names[results.defineTag.code]);
                    }
                    DefineSprite sprite = (DefineSprite)results.defineTag;
                    DefineSprite spriteCopy = new DefineSprite(sprite);
                    MovieTranscoder.defineScalingGrid(spriteCopy, args);
                    results.defineTag = spriteCopy;
                }
                transcodingResults = results;
                Object var15_15 = null;
                if (swfIn == null) return transcodingResults;
            }
            catch (IOException ex) {
                throw new AbstractTranscoder.ExceptionWhileTranscoding(ex);
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (swfIn == null) throw throwable;
            try {
                swfIn.close();
                throw throwable;
            }
            catch (IOException ex2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ex2) {
            // empty catch block
            return transcodingResults;
        }
        swfIn.close();
        return transcodingResults;
    }

    private Rect getSwfSize(InputStream swfIn) throws IOException {
        TagDecoder t = new TagDecoder(swfIn);
        HeaderSnarfer snarf = new HeaderSnarfer();
        t.parse((TagHandler)snarf);
        return snarf.swfHeader.size;
    }

    private Dictionary getDictionary(Transcoder.TranscodingResults results, InputStream swfIn) throws IOException {
        Dictionary dict = (Dictionary)this.dictionaryMap.get(results.assetSource.getName());
        if (dict == null) {
            TagLocator locator = new TagLocator();
            new TagDecoder(swfIn).parse((TagHandler)locator);
            dict = locator.dict;
            this.dictionaryMap.put(results.assetSource.getName(), dict);
        }
        return dict;
    }

    public void extractDefineFont(Transcoder.TranscodingResults results, InputStream swfIn, String fontName, boolean bold, boolean italic) throws IOException, TranscoderException {
        Dictionary dict = this.getDictionary(results, swfIn);
        DefineFont font = dict.getFontFace(fontName, bold, italic);
        if (font == null) {
            throw new MissingFontFace(fontName, bold, italic);
        }
        results.defineTag = font;
    }

    public void extractDefineTag(Transcoder.TranscodingResults results, InputStream swfIn, String symbolName, Map args) throws TranscoderException, IOException {
        Dictionary dict = this.getDictionary(results, swfIn);
        DefineTag definition = dict.getTag(symbolName);
        if (definition != null) {
            if (this.purge(definition)) {
                IgnoringAS2 ignoringAS2 = new IgnoringAS2(symbolName);
                String path = (String)args.get("_file");
                String pathSep = (String)args.get("_pathsep");
                if ("true".equals(pathSep)) {
                    path = path.replace('/', '\\');
                }
                ignoringAS2.path = path;
                if (args.containsKey("_line")) {
                    int line;
                    ignoringAS2.line = line = Integer.parseInt((String)args.get("_line"));
                }
                ThreadLocalToolkit.log(ignoringAS2);
            }
            results.defineTag = definition;
            if (definition instanceof DefineText) {
                DefineSprite s = new DefineSprite();
                PlaceObject po = new PlaceObject(definition, 0);
                s.tagList.tags.add(po);
                results.defineTag = s;
            }
        } else {
            throw new MissingSymbolDefinition(symbolName);
        }
    }

    public void generateTopLevelLoaderSource(Transcoder.TranscodingResults asset, String fullClassName, Map embedMap, Rect size) throws TranscoderException {
        String packageName = "";
        String className = fullClassName;
        int dot = fullClassName.lastIndexOf(46);
        if (dot != -1) {
            packageName = fullClassName.substring(0, dot);
            className = fullClassName.substring(dot + 1);
        }
        String resolvedSource = asset.assetSource.getName().replace('\\', '/');
        ThreadLocalToolkit.addResolvedPath(resolvedSource, asset.assetSource);
        StringBuffer source = new StringBuffer(1024);
        source.append("package ");
        source.append(packageName);
        source.append("\n{\nimport mx.core.MovieClipLoaderAsset;\n");
        source.append("import flash.utils.ByteArray;\n\n");
        source.append("public class ");
        source.append(className);
        source.append(" extends MovieClipLoaderAsset\n{\n");
        source.append("\tpublic function ");
        source.append(className);
        source.append("()\n\t{\n\t\tsuper();\n");
        source.append("\t\tinitialWidth=");
        source.append(size.getWidth());
        source.append("/20;\n\t\tinitialHeight=");
        source.append(size.getHeight());
        source.append("/20;\n\t}\n");
        source.append("\tprivate static var bytes:ByteArray = null;\n\n");
        source.append("\toverride public function get movieClipData():ByteArray\n\t{\n");
        source.append("\t\tif (bytes == null)\n\t\t{\n\t\t\tbytes = ByteArray( new dataClass() );\n\t\t}\n");
        source.append("\t\treturn bytes;\n\t}\n\n");
        source.append("\t[Embed(_resolvedSource='");
        source.append(resolvedSource);
        source.append("', mimeType='application/octet-stream')]\n\tpublic var dataClass:Class;\n");
        source.append("}\n}\n");
        asset.generatedCode = source.toString();
    }

    public static void defineScalingGrid(DefineSprite sprite, Map args) throws TranscoderException {
        if (args.get("scaleGridLeft") == null || args.get("scaleGridRight") == null || args.get("scaleGridTop") == null || args.get("scaleGridBottom") == null) {
            throw new ImageTranscoder.ScalingGridException();
        }
        if (sprite.scalingGrid != null) {
            ScalingGridAlreadyDefined scalingGridAlreadyDefined = new ScalingGridAlreadyDefined();
            String path = (String)args.get("_file");
            String pathSep = (String)args.get("_pathsep");
            if ("true".equals(pathSep)) {
                path = path.replace('/', '\\');
            }
            scalingGridAlreadyDefined.path = path;
            if (args.containsKey("_line")) {
                int line;
                scalingGridAlreadyDefined.line = line = Integer.parseInt((String)args.get("_line"));
            }
            ThreadLocalToolkit.log(scalingGridAlreadyDefined);
        }
        sprite.scalingGrid = new DefineScalingGrid();
        sprite.scalingGrid.scalingTarget = sprite;
        String left = (String)args.get("scaleGridLeft");
        sprite.scalingGrid.rect.xMin = Integer.parseInt(left) * 20;
        String right = (String)args.get("scaleGridRight");
        sprite.scalingGrid.rect.xMax = Integer.parseInt(right) * 20;
        String top = (String)args.get("scaleGridTop");
        sprite.scalingGrid.rect.yMin = Integer.parseInt(top) * 20;
        String bottom = (String)args.get("scaleGridBottom");
        sprite.scalingGrid.rect.yMax = Integer.parseInt(bottom) * 20;
        if (sprite.scalingGrid.rect.xMin < 0 || sprite.scalingGrid.rect.xMax < 0 || sprite.scalingGrid.rect.xMin >= sprite.scalingGrid.rect.xMax) {
            throw new ScalingGridRange();
        }
        if (sprite.scalingGrid.rect.yMin < 0 || sprite.scalingGrid.rect.yMax < 0 || sprite.scalingGrid.rect.yMin >= sprite.scalingGrid.rect.yMax) {
            throw new ScalingGridRange();
        }
    }

    private boolean purge(DefineTag tag) {
        boolean ret = false;
        if (tag instanceof DefineSprite) {
            DefineSprite sprite = (DefineSprite)tag;
            if (sprite.initAction != null) {
                ret = true;
                sprite.initAction = null;
            }
            Iterator iter = sprite.tagList.tags.iterator();
            while (iter.hasNext()) {
                Tag tag1 = (Tag)iter.next();
                if (tag1 instanceof DoAction || tag1 instanceof DoInitAction) {
                    ret = true;
                    iter.remove();
                }
                if (!(tag1 instanceof PlaceObject)) continue;
                PlaceObject placeObject = (PlaceObject)tag1;
                if (placeObject.hasClipAction()) {
                    placeObject.setClipActions(null);
                    ret = true;
                }
                if (placeObject.hasCharID()) {
                    ret |= this.purge(placeObject.ref);
                }
                if (placeObject.name == null) continue;
                this.embedProps.put(placeObject.name, "flash.display.DisplayObject");
            }
        } else if (tag instanceof DefineButton) {
            DefineButton button = (DefineButton)tag;
            if (button.condActions.length > 0) {
                ret = true;
                button.condActions = new ButtonCondAction[0];
            }
        }
        return ret;
    }

    public void clear() {
        super.clear();
        if (this.dictionaryMap.size() != 0) {
            this.dictionaryMap = new HashMap();
        }
        if (this.embedProps.size() != 0) {
            this.embedProps = new HashMap();
        }
    }

    public static final class ScalingGridAlreadyDefined
    extends CompilerMessage.CompilerError
    implements ILocalizableMessage {
    }

    public static final class IgnoringAS2
    extends CompilerMessage.CompilerWarning
    implements ILocalizableMessage {
        public String symbol;

        public IgnoringAS2(String symbol) {
            this.symbol = symbol;
        }
    }

    public static final class ScalingGridRange
    extends TranscoderException {
    }

    public static final class BadScalingGridTarget
    extends TranscoderException {
        public String resourceType;

        public BadScalingGridTarget(String resourceType) {
            this.resourceType = resourceType;
        }
    }

    public static final class UnableToBuildRootSprite
    extends TranscoderException {
    }

    public static final class MissingFontFace
    extends TranscoderException {
        public String fontName;
        public String weight;
        public String style;

        public MissingFontFace(String fontName, boolean bold, boolean italic) {
            this.fontName = fontName;
            this.weight = bold ? "bold" : "normal";
            this.style = italic ? "italic" : "regular";
        }
    }

    public static final class MissingSymbolDefinition
    extends TranscoderException {
        public String symbol;

        public MissingSymbolDefinition(String symbol) {
            this.symbol = symbol;
        }
    }

    static class TagLocator
    extends TagHandler {
        public Dictionary dict;

        TagLocator() {
        }

        public void setDecoderDictionary(Dictionary dict) {
            this.dict = dict;
        }
    }

    static class HeaderSnarfer
    extends TagHandler {
        public Header swfHeader;

        HeaderSnarfer() {
        }

        public void header(Header h) {
            this.swfHeader = h;
        }
    }

    class RootSpriteBuilder
    extends TagHandler {
        DefineSprite root = new DefineSprite();
        boolean strip;

        RootSpriteBuilder(String name, boolean strip) {
            this.root.name = name;
            this.strip = strip;
        }

        DefineSprite getRoot() {
            return this.root;
        }

        public void any(Tag tag) {
            if (!(tag instanceof DefineTag || tag instanceof DoInitAction || tag instanceof ExportAssets)) {
                PlaceObject placeObject;
                boolean keep = true;
                if (tag instanceof DoAction) {
                    if (this.strip) {
                        keep = false;
                    }
                    DoAction doAction = (DoAction)tag;
                    for (int i = 0; i < doAction.actionList.size(); ++i) {
                        Action action = doAction.actionList.getAction(i);
                        if (action.code == 7) continue;
                        keep = false;
                        break;
                    }
                } else if (tag instanceof PlaceObject && (placeObject = (PlaceObject)tag).hasName()) {
                    placeObject.setName(null);
                }
                if (keep) {
                    this.root.tagList.tags.add(tag);
                }
            }
        }
    }
}

