/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.lang;

import flash.css.Descriptor;
import flash.util.StringUtils;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TextParser {
    private static final Pattern percentagePattern;
    private static final Pattern qualifiedNamePattern;
    private static final Pattern regExpPattern;
    public static final int Ok = 0;
    public static final int ErrTypeNotEmbeddable = 1;
    public static final int ErrInvalidTextForType = 2;
    public static final int ErrInvalidPercentage = 3;
    public static final int ErrTypeNotSerializable = 4;
    public static final int ErrPercentagesNotAllowed = 5;
    public static final int ErrTypeNotContextRootable = 6;
    public static final int ErrUnrecognizedAtFunction = 7;
    public static final int ErrUndefinedContextRoot = 8;
    public static final int FlagInCDATA = 1;
    public static final int FlagCollapseWhiteSpace = 2;
    public static final int FlagConvertColorNames = 4;
    public static final int FlagAllowPercentages = 8;
    private final TypeTable typeTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TextParser(TypeTable typeTable) {
        this.typeTable = typeTable;
    }

    protected abstract String contextRoot(String var1);

    protected abstract Object embed(String var1, Type var2);

    protected abstract Object resource(String var1, Type var2);

    protected abstract Object bindingExpression(String var1);

    protected abstract Object percentage(String var1);

    protected abstract Object array(Collection var1, Type var2);

    protected abstract Object functionText(String var1);

    protected abstract Object className(String var1, Type var2);

    protected abstract void error(int var1, String var2, Type var3, Type var4);

    protected Object parse(String text, Type type, Type arrayElementType, int flags) {
        if (!TextParser.inCDATA(flags)) {
            String bindingExpressionText = TextParser.getBindingExpressionFromString(text);
            if (bindingExpressionText != null) {
                return this.bindingExpression(bindingExpressionText);
            }
            String atFunctionName = TextParser.getAtFunctionName(text = TextParser.cleanupBindingEscapes(text));
            if (atFunctionName != null) {
                return this.parseAtFunction(atFunctionName, text, type, arrayElementType, flags);
            }
        }
        return this.parseValue(text, type, arrayElementType, flags);
    }

    private Object parseValue(String text, Type type, Type arrayElementType, int flags) {
        String f;
        Collection c;
        boolean isint = false;
        boolean isuint = false;
        Object result = null;
        result = type.equals(this.typeTable.noType) || type.equals(this.typeTable.objectType) ? this.parseObject(text, arrayElementType, flags) : (type.equals(this.typeTable.stringType) ? this.parseString(text, flags) : (type.equals(this.typeTable.numberType) || (isint = type.equals(this.typeTable.intType)) || (isuint = type.equals(this.typeTable.uintType)) ? (text.indexOf(37) >= 0 ? (TextParser.allowPercentages(flags) ? ((result = TextParser.parsePercentage(text)) != null ? this.percentage((String)result) : new ParseError(3)) : new ParseError(5)) : (isint ? (Number)this.parseInt(text, flags) : (Number)(isuint ? (Number)this.parseUInt(text, flags) : (Number)this.parseNumber(text, flags)))) : (type.equals(this.typeTable.booleanType) ? TextParser.parseBoolean(text) : (type.equals(this.typeTable.regExpType) ? TextParser.parseRegExp(text) : (type.equals(this.typeTable.arrayType) ? ((c = this.parseArray(text, arrayElementType, true)) != null ? this.array(c, arrayElementType) : null) : (type.equals(this.typeTable.functionType) ? ((f = TextParser.parseFunction(text)) != null ? this.functionText(f) : null) : (this.acceptsClassRef(type) ? ((c = TextParser.parseClassName(text)) != null ? this.className(c, type) : null) : new ParseError(4))))))));
        if (result == null) {
            result = new ParseError(2);
        }
        if (result instanceof ParseError) {
            this.error(((ParseError)result).errno, text, type, arrayElementType);
            return null;
        }
        return result;
    }

    private boolean acceptsClassRef(Type type) {
        return type.equals(this.typeTable.classType) || StandardDefs.isInstanceGenerator(type);
    }

    private Object parseObject(String text, Type arrayElementType, int flags) {
        String temp = text.trim();
        Object result = TextParser.parseBoolean(temp);
        if (result != null) {
            return result;
        }
        result = this.parseArray(temp, arrayElementType, false);
        if (result != null) {
            return this.array((Collection)result, arrayElementType);
        }
        result = this.parseNumber(temp, flags);
        if (result != null) {
            return result;
        }
        return text;
    }

    private Collection parseArray(String text, Type elementType, boolean coerceSingleton) {
        if (!TextParser.isArray(text = text.trim())) {
            if (coerceSingleton) {
                Object element = this.parseValue(text, elementType, this.typeTable.objectType, 0);
                return element != null ? Collections.singleton(element) : null;
            }
            return null;
        }
        if (TextParser.isEmptyArray(text)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        StringBuffer buffer = new StringBuffer();
        char quoteChar = '\'';
        boolean inQuotes = false;
        int length = text.length();
        block5: for (int index = 1; index < length; ++index) {
            char c = text.charAt(index);
            switch (c) {
                case '[': {
                    if (!inQuotes) continue block5;
                    buffer.append(c);
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    if (inQuotes) {
                        if (quoteChar == c) {
                            inQuotes = false;
                            continue block5;
                        }
                        buffer.append(c);
                        continue block5;
                    }
                    inQuotes = true;
                    quoteChar = c;
                    continue block5;
                }
                case ',': 
                case ']': {
                    if (inQuotes) {
                        buffer.append(c);
                        continue block5;
                    }
                    String elementText = buffer.toString().trim();
                    buffer = new StringBuffer();
                    Object element = this.parseValue(elementText, elementType, this.typeTable.objectType, 0);
                    if (element != null) {
                        result.add(element);
                        continue block5;
                    }
                    return null;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return result;
    }

    private boolean hasLeadingZeros(String s) {
        boolean result = false;
        int n = s.length();
        if (!(n <= 1 || s.charAt(0) != '0' || s.startsWith("0x") || s.startsWith("0X") || s.startsWith("0."))) {
            result = true;
        }
        return result;
    }

    private Integer parseInt(String s, int flags) {
        String c;
        if (TextParser.convertColorNames(flags) && (c = Descriptor.convertColorName(s)) != null) {
            s = c;
        }
        try {
            if (this.hasLeadingZeros(s)) {
                return null;
            }
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Long parseUInt(String s, int flags) {
        String c;
        if (TextParser.convertColorNames(flags) && (c = Descriptor.convertColorName(s)) != null) {
            s = c;
        }
        try {
            if (this.hasLeadingZeros(s)) {
                return null;
            }
            Long l = Long.decode(s);
            long val = l;
            return val == Math.abs(val) && val <= 0xFFFFFFFFL ? l : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Number parseNumber(String s, int flags) {
        if (this.hasLeadingZeros(s)) {
            return null;
        }
        Integer integer = this.parseInt(s, flags);
        if (integer != null) {
            return integer;
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String parseString(String text, int flags) {
        if (TextParser.collapseWhiteSpace(flags) && !TextParser.inCDATA(flags)) {
            text = StringUtils.collapseWhitespace((String)text, (char)' ');
        }
        if (text.length() > 1 && text.charAt(0) == '\\' && "\\@".indexOf(text.charAt(1)) >= 0) {
            text = text.substring(1);
        }
        return text;
    }

    private static Boolean parseBoolean(String text) {
        Boolean b = Boolean.valueOf(StringUtils.collapseWhitespace((String)text, (char)' '));
        return b != false || text.equalsIgnoreCase("false") ? b : null;
    }

    private static String parseRegExp(String text) {
        Matcher m = regExpPattern.matcher(text);
        return m.matches() ? m.group(0) : null;
    }

    private static String parsePercentage(String text) {
        Matcher m = percentagePattern.matcher(text);
        return m.matches() ? m.group(1) + '%' : null;
    }

    private static String parseFunction(String text) {
        return text.trim();
    }

    public static String parseClassName(String text) {
        String name = text.trim();
        return TextParser.isQualifiedName(name) ? name : null;
    }

    private static final boolean inCDATA(int flags) {
        return (flags & 1) == 1;
    }

    private static final boolean collapseWhiteSpace(int flags) {
        return (flags & 2) == 2;
    }

    private static final boolean convertColorNames(int flags) {
        return (flags & 4) == 4;
    }

    private static final boolean allowPercentages(int flags) {
        return (flags & 8) == 8;
    }

    public static String cleanupBindingEscapes(String toClean) {
        toClean = StringUtils.cleanupEscapedChar((char)'{', (String)toClean);
        toClean = StringUtils.cleanupEscapedChar((char)'}', (String)toClean);
        return toClean;
    }

    public static boolean isBindingExpression(String s) {
        int openBraceIdx = StringUtils.findNthUnescaped((char)'{', (int)1, (String)s);
        if (openBraceIdx == -1) {
            return false;
        }
        int closeBraceIdx = StringUtils.findClosingToken((char)'{', (char)'}', (String)s, (int)openBraceIdx);
        return closeBraceIdx != -1;
    }

    public static String getBindingExpressionFromString(String s) {
        if (!$assertionsDisabled && s == null) {
            throw new AssertionError();
        }
        int openBraceIdx = StringUtils.findNthUnescaped((char)'{', (int)1, (String)s);
        if (openBraceIdx == -1) {
            return null;
        }
        int closeBraceIdx = StringUtils.findClosingToken((char)'{', (char)'}', (String)s, (int)openBraceIdx);
        if (closeBraceIdx == -1) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        String lead = s.substring(0, openBraceIdx);
        if (!lead.trim().equals("")) {
            buf.append(StringUtils.formatString((String)TextParser.cleanupBindingEscapes(lead)));
            buf.append(" + ");
        }
        while (openBraceIdx != -1) {
            buf.append("(");
            String contents = s.substring(openBraceIdx + 1, closeBraceIdx);
            if (contents.trim().equals("")) {
                contents = "''";
            }
            buf.append(contents);
            buf.append(")");
            int lastClose = closeBraceIdx;
            openBraceIdx = StringUtils.findNextUnescaped((char)'{', (int)lastClose, (String)s);
            if (openBraceIdx != -1) {
                buf.append(" + ");
                closeBraceIdx = StringUtils.findClosingToken((char)'{', (char)'}', (String)s, (int)openBraceIdx);
                if (closeBraceIdx != -1) {
                    buf.append(StringUtils.formatString((String)TextParser.cleanupBindingEscapes(s.substring(lastClose + 1, openBraceIdx))));
                    buf.append(" + ");
                    continue;
                }
                buf.append(StringUtils.formatString((String)s.substring(lastClose + 1)));
                openBraceIdx = -1;
                continue;
            }
            String tail = s.substring(lastClose + 1);
            if (tail.trim().equals("")) continue;
            buf.append(" + ");
            buf.append(StringUtils.formatString((String)TextParser.cleanupBindingEscapes(tail)));
        }
        return buf.toString();
    }

    private static String getAtFunctionName(String value) {
        int openParen;
        if ((value = value.trim()).length() > 1 && value.charAt(0) == '@' && (openParen = value.indexOf(40)) > 1 && value.indexOf(41) > openParen) {
            return value.substring(1, openParen);
        }
        return null;
    }

    private Object parseAtFunction(String functionName, String text, Type type, Type arrayElementType, int flags) {
        Object result = null;
        if ("Embed".equals(functionName)) {
            if (this.typeTable.stringType.isAssignableTo(type) || this.acceptsClassRef(type)) {
                result = this.embed(text, type);
            } else {
                this.error(1, text, type, arrayElementType);
            }
        } else if ("ContextRoot".equals(functionName)) {
            if (this.typeTable.stringType.isAssignableTo(type)) {
                result = this.contextRoot(text);
            } else {
                this.error(6, text, type, arrayElementType);
            }
        } else if ("Resource".equals(functionName)) {
            result = this.resource(text, type);
        } else {
            this.error(7, text, type, arrayElementType);
        }
        return result;
    }

    private static boolean isArray(String text) {
        boolean result = true;
        if (text.length() < 2 || text.charAt(0) != '[' || text.charAt(text.length() - 1) != ']') {
            result = false;
        }
        return result;
    }

    private static boolean isEmptyArray(String text) {
        boolean result = false;
        if (TextParser.isArray(text) && text.substring(1, text.length() - 1).trim().length() == 0) {
            result = true;
        }
        return result;
    }

    public static boolean isValidIdentifier(String id) {
        if (id.length() == 0 || !TextParser.isIdentifierFirstChar(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (TextParser.isIdentifierChar(id.charAt(i))) continue;
            return false;
        }
        return !StandardDefs.isReservedWord(id);
    }

    private static boolean isIdentifierFirstChar(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    private static boolean isIdentifierChar(int ch) {
        return ch != -1 && Character.isJavaIdentifierPart((char)ch);
    }

    private static boolean isQualifiedName(String text) {
        return qualifiedNamePattern.matcher(text).matches() && !StandardDefs.isReservedWord(text);
    }

    static {
        $assertionsDisabled = !TextParser.class.desiredAssertionStatus();
        percentagePattern = Pattern.compile("\\s*((\\d+)(.(\\d)+)?)\\s*%\\s*");
        qualifiedNamePattern = Pattern.compile("([a-zA-Z_]\\w*)(\\.([a-zA-Z_]\\w*))*");
        regExpPattern = Pattern.compile("/.*/[gimsx]*");
    }

    private static class ParseError {
        final int errno;

        ParseError(int errno) {
            this.errno = errno;
        }
    }
}

