/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.reflect;

import flex2.compiler.SymbolTable;
import flex2.compiler.abc.Attributes;
import flex2.compiler.abc.Class;
import flex2.compiler.abc.MetaData;
import flex2.compiler.abc.Method;
import flex2.compiler.abc.Variable;
import flex2.compiler.css.Styles;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Deprecated;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Inspectable;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class TypeTable {
    private SymbolTable symbolTable;
    private NameMappings manifest;
    public final Type noType;
    public final Type stringType;
    public final Type booleanType;
    public final Type classType;
    public final Type functionType;
    public final Type numberType;
    public final Type intType;
    public final Type uintType;
    public final Type arrayType;
    public final Type objectType;
    public final Type xmlType;
    public final Type xmlListType;
    public final Type regExpType;
    private Map typeMap;
    private Map nonRepeaters;
    static /* synthetic */ java.lang.Class class$flex2$compiler$mxml$reflect$TypeTable;

    public TypeTable(SymbolTable symbolTable, NameMappings manifest) {
        this.symbolTable = symbolTable;
        this.manifest = manifest;
        this.nonRepeaters = new WeakHashMap();
        this.typeMap = new HashMap();
        this.noType = this.getType("*");
        this.objectType = this.getType("Object");
        this.stringType = this.getType("String");
        this.booleanType = this.getType("Boolean");
        this.classType = this.getType("Class");
        this.functionType = this.getType("Function");
        this.numberType = this.getType("Number");
        this.intType = this.getType("int");
        this.uintType = this.getType("uint");
        this.arrayType = this.getType("Array");
        this.xmlType = this.getType("XML");
        this.xmlListType = this.getType("XMLList");
        this.regExpType = this.getType("RegExp");
    }

    public Type getType(String namespaceURI, String localPart) {
        String className = this.manifest.resolveClassName(namespaceURI, localPart);
        return this.getType(className);
    }

    public Type getType(QName qName) {
        return this.getType(qName.getNamespace(), qName.getLocalPart());
    }

    public Type getType(String className) {
        Class classInfo;
        Type t = (Type)this.typeMap.get(className);
        if (t == null && (classInfo = this.symbolTable.getClass(className)) != null) {
            t = new TypeHelper(classInfo);
            this.typeMap.put(className, t);
        }
        return t;
    }

    public Style getStyle(String styleName) {
        MetaData md = this.symbolTable.getStyle(styleName);
        return md == null ? null : new StyleHelper(styleName, md.getValue("type"), md.getValue("enumeration"), md.getValue("format"), md.getValue("inherit"));
    }

    public Styles getStyles() {
        return this.symbolTable.getStyles();
    }

    public Object getPerCompileData() {
        return this.symbolTable.perCompileData;
    }

    private final class DeprecatedHelper
    implements Deprecated {
        private String replacement;
        private String message;

        private DeprecatedHelper(String replacement, String message) {
            this.replacement = replacement;
            this.message = message;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private final class InspectableHelper
    implements Inspectable {
        private String[] enumeration;
        private String defaultValue;
        private boolean isDefault;
        private String category;
        private boolean isVerbose;
        private String type;
        private String objectType;
        private String arrayType;
        private String environment;
        private String format;

        private InspectableHelper(String enumeration, String defaultValue, String isDefault, String category, String isVerbose, String type, String objectType, String arrayType, String environment, String format) {
            if (enumeration != null) {
                StringTokenizer t = new StringTokenizer(enumeration, ",");
                this.enumeration = new String[t.countTokens()];
                int i = 0;
                while (t.hasMoreTokens()) {
                    this.enumeration[i] = t.nextToken();
                    ++i;
                }
            }
            this.defaultValue = defaultValue;
            this.isDefault = "yes".equalsIgnoreCase(isDefault);
            this.category = category;
            this.isVerbose = "yes".equalsIgnoreCase(isVerbose);
            this.type = type;
            this.objectType = objectType;
            this.arrayType = arrayType;
            this.environment = environment;
            this.format = format;
        }

        public String[] getEnumeration() {
            return this.enumeration;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String getCategory() {
            return this.category;
        }

        public boolean isVerbose() {
            return this.isVerbose;
        }

        public String getType() {
            return this.type;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getArrayType() {
            return this.arrayType;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getFormat() {
            return this.format;
        }
    }

    private final class EffectHelper
    implements Effect {
        private final String name;
        private final String event;

        private EffectHelper(String name, String event) {
            this.name = name;
            this.event = event;
        }

        public String getName() {
            return this.name;
        }

        public String getEvent() {
            return this.event;
        }
    }

    private final class StyleHelper
    implements Style {
        private String name;
        private String type;
        private String[] enumeration;
        private String format;
        private boolean isInherit;

        private StyleHelper(String name, String type, String enumeration, String format, String inherit) {
            Object t;
            if (type == null) {
                type = enumeration == null ? "Object" : "String";
            } else {
                t = TypeTable.this.getType(NameFormatter.toColon(type));
                if (t == null) {
                    type = "Object";
                }
            }
            this.name = name;
            this.type = NameFormatter.toColon(type).intern();
            if (enumeration != null) {
                t = new StringTokenizer(enumeration, ",");
                this.enumeration = new String[((StringTokenizer)t).countTokens()];
                int i = 0;
                while (((StringTokenizer)t).hasMoreTokens()) {
                    this.enumeration[i] = ((StringTokenizer)t).nextToken();
                    ++i;
                }
            }
            this.format = format;
            this.isInherit = "yes".equalsIgnoreCase(inherit);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return TypeTable.this.getType(this.type);
        }

        public String[] getEnumeration() {
            return this.enumeration;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean isInherit() {
            return this.isInherit;
        }
    }

    private final class EventHelper
    implements Event {
        private final String name;
        private final String typeName;
        private Type type;

        private EventHelper(String name, String typeName) {
            this.name = name;
            this.typeName = typeName;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Type getType() {
            return this.type != null ? this.type : (this.type = TypeTable.this.getType(this.typeName));
        }
    }

    private final class PropertyHelper
    implements Property {
        private boolean readOnly;
        private boolean writeOnly;
        private Variable var;
        private Method setter;
        private Method getter;

        private PropertyHelper(Variable var) {
            this.var = var;
            this.readOnly = this.getAttributes() != null && this.getAttributes().hasConst();
            this.writeOnly = false;
        }

        PropertyHelper(Method setter, Method getter) {
            this.setter = setter;
            this.getter = getter;
            this.readOnly = setter == null && getter != null;
            this.writeOnly = setter != null && getter == null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Property) {
                Property p = (Property)obj;
                return this.getName().equals(p.getName());
            }
            return false;
        }

        public String getName() {
            if (this.var != null) {
                return this.var.getName();
            }
            if (this.setter != null) {
                return this.setter.getName();
            }
            return this.getter.getName();
        }

        public Type getType() {
            String className = this.var != null ? this.var.getTypeName() : (this.setter != null ? this.setter.getParameterTypeNames()[0] : this.getter.getReturnTypeName());
            return TypeTable.this.getType(className);
        }

        public boolean readOnly() {
            return this.readOnly;
        }

        public boolean writeOnly() {
            return this.writeOnly;
        }

        public boolean hasStatic() {
            Attributes attrs = this.getAttributes();
            return attrs != null && attrs.hasStatic();
        }

        public boolean hasOverride() {
            Attributes attrs = this.getAttributes();
            return attrs != null && attrs.hasOverride();
        }

        public boolean hasPrivate() {
            Attributes attrs = this.getAttributes();
            return attrs != null && attrs.hasPrivate();
        }

        public boolean hasPublic() {
            Attributes attrs = this.getAttributes();
            return attrs != null && attrs.hasPublic();
        }

        public boolean hasProtected() {
            Attributes attrs = this.getAttributes();
            return attrs != null && attrs.hasProtected();
        }

        public boolean hasInternal() {
            Attributes attrs = this.getAttributes();
            return attrs == null || attrs.hasInternal();
        }

        public boolean hasNamespace(String nsValue) {
            Attributes attrs = this.getAttributes();
            return attrs != null && attrs.hasNamespace(nsValue);
        }

        private Attributes getAttributes() {
            return this.var != null ? this.var.getAttributes() : (this.setter != null ? this.setter.getAttributes() : this.getter.getAttributes());
        }

        public Inspectable getInspectable() {
            List mdList = this.getMetaDataList("Inspectable");
            if (mdList != null) {
                MetaData md = (MetaData)mdList.get(0);
                return new InspectableHelper(md.getValue("enumeration"), md.getValue("defaultValue"), md.getValue("isDefault"), md.getValue("category"), md.getValue("isVerbose"), md.getValue("type"), md.getValue("objectType"), md.getValue("arrayType"), md.getValue("environment"), md.getValue("format"));
            }
            return null;
        }

        public Deprecated getDeprecated() {
            List mdList = this.getMetaDataList("Deprecated");
            if (mdList != null) {
                MetaData md = (MetaData)mdList.get(0);
                String replacement = md.getValue("replacement");
                String message = null;
                if (replacement == null) {
                    message = md.getValue(0);
                }
                return new DeprecatedHelper(replacement, message);
            }
            return null;
        }

        public boolean hasChangeEvent(String name) {
            List mdList;
            if (this.var != null && (mdList = this.var.getMetaData("ChangeEvent")) != null) {
                int size = mdList.size();
                for (int i = 0; i < size; ++i) {
                    MetaData md = (MetaData)mdList.get(i);
                    if (!name.equals(md.getValue(0))) continue;
                    return true;
                }
            }
            return false;
        }

        public String getArrayElementType() {
            MetaData metaData;
            List mdList = this.getMetaDataList("ArrayElementType");
            if (mdList != null && (metaData = (MetaData)mdList.get(0)).count() > 0) {
                String typeName = metaData.getValue(0);
                return typeName == null ? null : NameFormatter.toColon(typeName);
            }
            return null;
        }

        public String getPercentProxy() {
            MetaData metaData;
            List metaDataList = this.getMetaDataList("PercentProxy");
            if (metaDataList != null && !metaDataList.isEmpty() && (metaData = (MetaData)metaDataList.get(0)).count() > 0) {
                return metaData.getValue(0);
            }
            return null;
        }

        public String getInstanceType() {
            MetaData metaData;
            List mdList = this.getMetaDataList("InstanceType");
            if (mdList != null && (metaData = (MetaData)mdList.get(0)).count() > 0) {
                return NameFormatter.toColon(metaData.getValue(0));
            }
            return null;
        }

        public boolean collapseWhiteSpace() {
            return this.getMetaDataList("CollapseWhiteSpace") != null;
        }

        private List getMetaDataList(String name) {
            List mdList = null;
            if (this.var != null) {
                mdList = this.var.getMetaData(name);
            } else {
                if (this.getter != null) {
                    mdList = this.getter.getMetaData(name);
                }
                if (mdList == null && this.setter != null) {
                    mdList = this.setter.getMetaData(name);
                }
            }
            return mdList != null && mdList.size() > 0 ? mdList : null;
        }
    }

    private final class EventListHelper {
        private Map eventTypes;

        private EventListHelper(List events) {
            if (events.size() == 0) {
                return;
            }
            this.eventTypes = new HashMap(events.size());
            int length = events.size();
            for (int i = 0; i < length; ++i) {
                MetaData md = (MetaData)events.get(i);
                String name = md.getValue("name");
                String typeName = md.getValue("type");
                if (name != null) {
                    typeName = typeName == null ? "flash.events:Event" : NameFormatter.toColon(typeName);
                } else {
                    name = md.getValue(0);
                    typeName = "flash.events:Event";
                }
                this.eventTypes.put(name, typeName);
            }
        }

        Event getEvent(String name) {
            String typeName = this.eventTypes == null ? null : this.eventTypes.get(name);
            return typeName != null ? new EventHelper(name, typeName) : null;
        }
    }

    private final class TypeHelper
    implements Type {
        private Class classInfo;
        private EventListHelper events;
        private List effects;
        private List styles;
        static final /* synthetic */ boolean $assertionsDisabled;

        private TypeHelper(Class classInfo) {
            if (!$assertionsDisabled && classInfo == null) {
                throw new AssertionError();
            }
            this.classInfo = classInfo;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Type) {
                return this.getName().equals(((Type)obj).getName());
            }
            return false;
        }

        public TypeTable getTypeTable() {
            return TypeTable.this;
        }

        public String getName() {
            return this.classInfo.getName();
        }

        public Type getSuperType() {
            return this.classInfo.getSuperTypeName() != null ? TypeTable.this.getType(this.classInfo.getSuperTypeName()) : null;
        }

        public Type[] getInterfaces() {
            String[] ifaces = this.classInfo.getInterfaceNames();
            if (ifaces != null) {
                Type[] types = new Type[ifaces.length];
                int length = types.length;
                for (int i = 0; i < length; ++i) {
                    types[i] = TypeTable.this.getType(ifaces[i]);
                }
                return types;
            }
            return null;
        }

        public Property getProperty(String name) {
            return this.getProperty(SymbolTable.VISIBILITY_NAMESPACES, name);
        }

        public Property getProperty(String namespace, String name) {
            return this.getProperty(new String[]{namespace}, name);
        }

        public Property getProperty(String[] namespaces, String name) {
            Class cls = this.classInfo;
            Class superClass = null;
            while (cls != null) {
                Variable var = cls.getVariable(namespaces, name, false);
                if (var != null) {
                    Attributes attrs = var.getAttributes();
                    if (attrs == null || !attrs.hasStatic()) {
                        return new PropertyHelper(var);
                    }
                    superClass = TypeTable.this.symbolTable.getClass(cls.getSuperTypeName());
                } else {
                    Method setter = cls.getSetter(namespaces, name, false);
                    Method getter = cls.getGetter(namespaces, name, false);
                    if (setter != null && getter != null) {
                        return new PropertyHelper(setter, getter);
                    }
                    superClass = TypeTable.this.symbolTable.getClass(cls.getSuperTypeName());
                    if (setter != null && superClass != null) {
                        getter = this.findGetter(superClass, setter);
                        return new PropertyHelper(setter, getter);
                    }
                    if (getter != null && superClass != null) {
                        setter = this.findSetter(superClass, getter);
                        return new PropertyHelper(setter, getter);
                    }
                }
                cls = superClass;
            }
            return null;
        }

        public boolean hasStaticMember(String name) {
            Class cls = this.classInfo;
            while (cls != null) {
                Attributes attrs;
                Method method;
                Attributes attrs2;
                Variable var = cls.getVariable(SymbolTable.VISIBILITY_NAMESPACES, name, false);
                if (var != null ? (attrs2 = var.getAttributes()) != null && attrs2.hasStatic() : (method = cls.getMethod(new String[]{""}, name, false)) != null && (attrs = method.getAttributes()) != null && attrs.hasStatic()) {
                    return true;
                }
                cls = TypeTable.this.symbolTable.getClass(cls.getSuperTypeName());
            }
            return false;
        }

        public Event getEvent(String name) {
            Event e;
            if (this.events == null) {
                this.events = new EventListHelper(this.classInfo.getMetaData("Event", false));
            }
            if ((e = this.events.getEvent(name)) != null) {
                return e;
            }
            Type st = this.getSuperType();
            return st != null ? st.getEvent(name) : null;
        }

        public Effect getEffect(String name) {
            if (this.effects == null) {
                this.effects = this.classInfo.getMetaData("Effect", true);
            }
            int length = this.effects.size();
            for (int i = 0; i < length; ++i) {
                MetaData md = (MetaData)this.effects.get(i);
                if (!name.equals(md.getValue(0))) continue;
                return new EffectHelper(name, md.getValue("event"));
            }
            return null;
        }

        public Style getStyle(String name) {
            if (this.styles == null) {
                this.styles = this.classInfo.getMetaData("Style", true);
            }
            int length = this.styles.size();
            for (int i = 0; i < length; ++i) {
                MetaData md = (MetaData)this.styles.get(i);
                if (!name.equals(md.getValue("name"))) continue;
                return new StyleHelper(name, md.getValue("type"), md.getValue("enumeration"), md.getValue("format"), md.getValue("inherit"));
            }
            return null;
        }

        public Property getDefaultProperty() {
            List metadata = this.classInfo.getMetaData("DefaultProperty", true);
            if (metadata.size() > 0) {
                String defaultPropertyName = ((MetaData)metadata.get(0)).getValue(0);
                return defaultPropertyName != null ? this.getProperty(defaultPropertyName) : null;
            }
            return null;
        }

        public boolean hasObsolete(String name) {
            List metadata = this.classInfo.getMetaData("Obsolete", false);
            int length = metadata.size();
            for (int i = 0; i < length; ++i) {
                MetaData md = (MetaData)metadata.get(i);
                if (!name.equals(md.getValue(0))) continue;
                return true;
            }
            return false;
        }

        public int getMaxChildren() {
            List metadata = this.classInfo.getMetaData("MaxChildren", true);
            if (!metadata.isEmpty()) {
                MetaData md = (MetaData)metadata.get(0);
                return Integer.parseInt(md.getValue(0));
            }
            return 0;
        }

        public String getLoaderClass() {
            List metadata = this.classInfo.getMetaData("Frame", true);
            if (!metadata.isEmpty()) {
                MetaData md = (MetaData)metadata.get(0);
                return md.getValue("factoryClass");
            }
            return null;
        }

        public boolean hasDynamic() {
            return this.classInfo.getAttributes() != null && this.classInfo.getAttributes().hasDynamic();
        }

        public boolean isSubclassOf(Type baseType) {
            if (baseType == this) {
                return true;
            }
            if (baseType == TypeTable.this.noType) {
                return false;
            }
            if (baseType != null) {
                return this.isSubclassOf(baseType.getName());
            }
            return false;
        }

        public boolean isSubclassOf(String baseName) {
            if ("*".equals(baseName)) {
                return false;
            }
            return this.isAssignableTo(baseName);
        }

        public boolean isAssignableTo(Type baseType) {
            if (baseType == this || baseType == TypeTable.this.noType) {
                return true;
            }
            if (baseType != null) {
                return this.isAssignableTo(baseType.getName());
            }
            return false;
        }

        public boolean isAssignableTo(String baseName) {
            int i;
            int length;
            String name = this.getName();
            if (StandardDefs.CLASS_REPEATER.equals(baseName) && TypeTable.this.nonRepeaters.containsKey(name)) {
                return false;
            }
            if ("*".equals(baseName) || name.equals(baseName)) {
                return true;
            }
            Type superType = this.getSuperType();
            if (superType != null && superType.getName().equals(baseName)) {
                return true;
            }
            Type[] interfaces = this.getInterfaces();
            int n = length = interfaces == null ? 0 : interfaces.length;
            for (i = 0; i < length; ++i) {
                if (baseName == null || interfaces[i] == null || !baseName.equals(interfaces[i].getName())) continue;
                return true;
            }
            if (superType != null && superType.isAssignableTo(baseName)) {
                return true;
            }
            int n2 = length = interfaces == null ? 0 : interfaces.length;
            for (i = 0; i < length; ++i) {
                if (interfaces[i] == null || !interfaces[i].isAssignableTo(baseName)) continue;
                return true;
            }
            if (StandardDefs.CLASS_REPEATER.equals(baseName)) {
                TypeTable.this.nonRepeaters.put(name, name);
            }
            return false;
        }

        private Method findGetter(Class cls, Method setter) {
            while (cls != null) {
                Method getter = cls.getGetter(new String[]{""}, setter.getName(), true);
                if (getter != null) {
                    return getter;
                }
                cls = TypeTable.this.symbolTable.getClass(cls.getSuperTypeName());
            }
            return null;
        }

        private Method findSetter(Class cls, Method getter) {
            while (cls != null) {
                Method setter = cls.getSetter(new String[]{""}, getter.getName(), true);
                if (setter != null) {
                    return setter;
                }
                cls = TypeTable.this.symbolTable.getClass(cls.getSuperTypeName());
            }
            return null;
        }

        static {
            $assertionsDisabled = !(class$flex2$compiler$mxml$reflect$TypeTable == null ? (class$flex2$compiler$mxml$reflect$TypeTable = TypeTable.class$("flex2.compiler.mxml.reflect.TypeTable")) : class$flex2$compiler$mxml$reflect$TypeTable).desiredAssertionStatus();
        }
    }
}

