/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.Source;
import flex2.compiler.as3.MetaDataParser;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.LineNumberMapped;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;

public class AtResource
implements LineNumberMapped {
    private String bundle;
    private String key;
    private String type;
    private String propertyName;
    private int lineNumber;

    public AtResource(String bundle, String key, String type, String propertyName, int lineNumber) {
        this.bundle = bundle;
        this.key = key;
        this.type = type;
        this.propertyName = propertyName;
        this.lineNumber = lineNumber;
    }

    public String getBundle() {
        return this.bundle;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getValueExpression() {
        return this.propertyName + ".get" + this.type + "(\"" + this.key + "\")";
    }

    public int getXmlLineNumber() {
        return this.lineNumber;
    }

    public void setXmlLineNumber(int xmlLineNumber) {
        this.lineNumber = xmlLineNumber;
    }

    public static AtResource create(TypeTable typeTable, Source sourceFile, int beginLine, String value, Type type) {
        String bundle;
        String typeStr = null;
        typeStr = type.isAssignableTo(typeTable.stringType) ? "String" : (type.isAssignableTo(typeTable.booleanType) ? "Boolean" : (type.isAssignableTo(typeTable.numberType) ? "Number" : "*"));
        MetaData metaData = MetaDataParser.parse(typeTable.getPerCompileData(), sourceFile, beginLine, value.substring(1));
        if (metaData == null) {
            return null;
        }
        if (metaData.count() == 0) {
            ThreadLocalToolkit.log((CompilerMessage)new NoResourceParams(), sourceFile.getNameForReporting(), beginLine);
            return null;
        }
        String key = metaData.getValue("key");
        if (key == null) {
            if (metaData.getKey(0) == null && metaData.count() == 1) {
                key = metaData.getValue(0);
            } else {
                ThreadLocalToolkit.log((CompilerMessage)new NoResourceKeyParam(), sourceFile.getNameForReporting(), beginLine);
                return null;
            }
        }
        if ((bundle = metaData.getValue("bundle")) == null) {
            if (metaData.count() > 1) {
                ThreadLocalToolkit.log((CompilerMessage)new NoResourceBundleParam(), sourceFile.getNameForReporting(), beginLine);
                return null;
            }
            bundle = NameFormatter.classNameFromSource(sourceFile);
        }
        String propertyName = "rb_" + bundle;
        return new AtResource(bundle, key, typeStr, propertyName, beginLine);
    }

    public static class NoResourceBundleParam
    extends CompilerMessage.CompilerError {
    }

    public static class NoResourceKeyParam
    extends CompilerMessage.CompilerError {
    }

    public static class NoResourceParams
    extends CompilerMessage.CompilerError {
    }
}

