/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.Source;
import flex2.compiler.SourcePath;
import flex2.compiler.common.ConfigurationException;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Component;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcDirectoryArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcLazyReadArchive;
import flex2.compiler.swc.SwcMovie;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.Configuration;
import flex2.linker.LinkerException;
import flex2.tools.CompcConfiguration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class API {
    public static void setupResourceBundles(ResourceBundlePath bundlePath, SourcePath sourcePath, CompilerSwcContext swcContext, CompcConfiguration configuration, Map bundles) throws CompilerException {
        API.setupResourceBundles(bundlePath, sourcePath, swcContext, configuration.getIncludeResourceBundles(), bundles);
    }

    public static void setupResourceBundles(ResourceBundlePath bundlePath, SourcePath sourcePath, CompilerSwcContext swcContext, List list, Map bundles) throws CompilerException {
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String className;
                String name = (String)iterator.next();
                String packageName = NameFormatter.retrievePackageName(name);
                Source s = I18nUtils.getResourceBundleSource(packageName, className = NameFormatter.retrieveClassName(name), bundlePath, sourcePath, swcContext);
                if (s == null) {
                    SwcException.NoResourceBundleSource e = new SwcException.NoResourceBundleSource(name);
                    ThreadLocalToolkit.log(e);
                    throw e;
                }
                bundles.put(s.getName(), s);
            }
        }
        catch (CompilerException ce) {
            ThreadLocalToolkit.logError(ce.getMessage());
            throw ce;
        }
    }

    public static List setupNamespaceComponents(CompcConfiguration configuration, NameMappings mappings, SourcePath sourcePath, Map classes) throws ConfigurationException, CompilerException {
        return API.setupNamespaceComponents(configuration.getNamespaces(), mappings, sourcePath, classes, configuration.getIncludeLookupOnly());
    }

    public static List setupNamespaceComponents(List targets, NameMappings mappings, SourcePath sourcePath, Map classes) throws ConfigurationException, CompilerException {
        return API.setupNamespaceComponents(targets, mappings, sourcePath, classes, false);
    }

    public static List setupNamespaceComponents(List targets, NameMappings mappings, SourcePath sourcePath, Map classes, boolean includeLookupOnly) throws ConfigurationException, CompilerException {
        LinkedList<Component> nsComponents = new LinkedList<Component>();
        try {
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                String nsTarget = (String)iterator.next();
                if (nsTarget == null) continue;
                Map map = mappings.getNamespace(nsTarget);
                if (map == null) {
                    throw new ConfigurationException.UnknownNamespace(nsTarget, null, null, -1);
                }
                Iterator iter2 = map.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry entry = iter2.next();
                    String compName = (String)entry.getKey();
                    String className = (String)entry.getValue();
                    String packageName = NameFormatter.retrievePackageName(className);
                    String leafName = NameFormatter.retrieveClassName(className);
                    if (!mappings.isLookupOnly(className)) {
                        Source s = sourcePath.findSource(packageName, leafName);
                        if (s == null) {
                            SwcException.NoSourceForClass e = new SwcException.NoSourceForClass(className, nsTarget);
                            ThreadLocalToolkit.log(e);
                            throw e;
                        }
                        classes.put(s.getName(), s);
                        Component component = new Component(className, compName, nsTarget);
                        nsComponents.add(component);
                        continue;
                    }
                    if (!includeLookupOnly) continue;
                    nsComponents.add(new Component(className, compName, nsTarget));
                }
            }
        }
        catch (CompilerException ce) {
            ThreadLocalToolkit.logError(ce.getMessage());
            throw ce;
        }
        return nsComponents;
    }

    public static void setupClasses(CompcConfiguration configuration, SourcePath sourcePath, Map classes) throws CompilerException {
        API.setupClasses(configuration.getClasses(), sourcePath, classes);
    }

    public static void setupClasses(List list, SourcePath sourcePath, Map classes) throws CompilerException {
        if (list != null) {
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String leafName;
                    String className = (String)iterator.next();
                    String tempName = className.replace('/', '.').replace('\\', '.');
                    String packageName = NameFormatter.retrievePackageName(tempName);
                    Source s = sourcePath.findSource(packageName, leafName = NameFormatter.retrieveClassName(tempName));
                    if (s == null) {
                        SwcException msg = className.endsWith(".as") || className.endsWith(".mxml") ? new SwcException.CouldNotFindFileSource(className) : new SwcException.CouldNotFindSource(className);
                        ThreadLocalToolkit.log(msg);
                        throw msg;
                    }
                    classes.put(s.getName(), s);
                }
            }
            catch (CompilerException ce) {
                ThreadLocalToolkit.logError(ce.getMessage());
                throw ce;
            }
        }
    }

    public static SwcMovie link(Configuration configuration, List units) throws LinkerException {
        SwcMovie movie = new SwcMovie(configuration);
        movie.generate(units);
        return movie;
    }

    public static void exportSwc(CompcConfiguration configuration, List units, List nsComponents, SwcCache cache) throws Exception {
        API.exportSwc(configuration.getOutput(), configuration.isDirectory(), configuration.getFiles(), configuration, units, nsComponents, cache);
    }

    public static void exportSwc(String swcStr, boolean isDirectory, Map files, Configuration configuration, List units, List nsComponents, SwcCache cache) throws Exception {
        SwcArchive archive = isDirectory ? new SwcDirectoryArchive(swcStr) : new SwcLazyReadArchive(swcStr);
        API.exportSwc(archive, files, configuration, units, nsComponents, cache);
    }

    public static void exportSwc(SwcArchive archive, Map files, Configuration configuration, List units, List nsComponents, SwcCache cache) throws Exception {
        SwcMovie m = API.link(configuration, units);
        API.exportSwc(archive, files, configuration, m, nsComponents, cache);
    }

    public static void exportSwc(SwcArchive archive, Map files, Configuration configuration, SwcMovie m, List nsComponents, SwcCache cache) throws Exception {
        try {
            CompilationUnit unit;
            Swc swc = new Swc(archive);
            if (configuration.generateLinkReport() && configuration.getLinkReportFileName() != null) {
                FileUtil.writeFile(configuration.getLinkReportFileName(), m.getLinkReport());
            }
            if (configuration.generateRBList() && configuration.getRBListFileName() != null) {
                FileUtil.writeFile(configuration.getRBListFileName(), m.getRBList());
            }
            if (ThreadLocalToolkit.errorCount() > 0) {
                return;
            }
            HashMap<String, Component> allClassComp = new HashMap<String, Component>();
            HashMap refClassComp = new HashMap();
            Iterator e = m.getExportedUnits().iterator();
            while (e.hasNext()) {
                unit = (CompilationUnit)e.next();
                if (!unit.getSource().isSwcScriptOwner()) continue;
                Swc unitswc = ((SwcScript)unit.getSource().getOwner()).getLibrary().getSwc();
                Iterator ci = unitswc.getComponentIterator();
                while (ci.hasNext()) {
                    Component c = (Component)ci.next();
                    allClassComp.put(c.getClassName(), c);
                }
            }
            Iterator nsc = nsComponents.iterator();
            while (nsc.hasNext()) {
                Component c = (Component)nsc.next();
                allClassComp.put(c.getClassName(), c);
            }
            e = m.getExportedUnits().iterator();
            while (e.hasNext()) {
                unit = (CompilationUnit)e.next();
                int s = unit.topLevelDefinitions.size();
                for (int i = 0; i < s; ++i) {
                    String def = unit.topLevelDefinitions.get(i).toString();
                    if (!allClassComp.containsKey(def)) continue;
                    swc.addComponent((Component)allClassComp.get(def));
                }
            }
            swc.buildLibrary("library", configuration, m);
            Iterator iterator = files.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String fileName = (String)entry.getKey();
                VirtualFile f = (VirtualFile)entry.getValue();
                if (swc.getArchive().getFile(fileName) != null) continue;
                InMemoryFile swcFile = new InMemoryFile(f.getInputStream(), fileName, f.getMimeType(), f.getLastModified());
                swc.addFile(swcFile);
            }
            cache.export(swc);
            if (ThreadLocalToolkit.errorCount() > 0) {
                return;
            }
        }
        catch (Exception e) {
            if (e instanceof CompilerException || e instanceof LinkerException || e instanceof SwcException.SwcNotExported) {
                throw e;
            }
            if (Trace.error) {
                e.printStackTrace();
            }
            SwcException.SwcNotExported ex = new SwcException.SwcNotExported(archive.getLocation(), e);
            ThreadLocalToolkit.log(ex);
            throw ex;
        }
        if (ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark("Exporting " + archive.getLocation() + "...");
        }
    }
}

