/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SwcDirectoryArchive
implements SwcArchive {
    private final String dir;
    private Set fileList = new HashSet();

    public SwcDirectoryArchive(String path) {
        this.dir = path;
    }

    public String getLocation() {
        return this.dir;
    }

    public void load() {
        String swcPath = this.filePath(Swc.CATALOG_XML);
        File c = new File(swcPath);
        if (!c.exists()) {
            throw new SwcException.NotASwcDirectory(this.dir);
        }
        this.readFiles(this.fileList, "", new File(this.dir));
    }

    private void readFiles(Set s, String current, File f) {
        if (f.isDirectory()) {
            File[] files = FileUtils.listFiles((File)f);
            for (int i = 0; i < files.length; ++i) {
                String relpath = FileUtils.addPathComponents((String)current, (String)files[i].getName(), (char)File.separatorChar);
                File absFile = new File(this.filePath(relpath));
                this.readFiles(s, relpath, absFile);
            }
        } else {
            s.add(current);
        }
    }

    public void save() {
    }

    public void close() {
    }

    public Map getFiles() {
        HashMap<String, RelativeLocalFile> map = new HashMap<String, RelativeLocalFile>();
        Iterator it = this.fileList.iterator();
        while (it.hasNext()) {
            String filename = (String)it.next();
            map.put(filename, new RelativeLocalFile(new File(this.filePath(filename)), this.dir + "$" + filename));
        }
        return map;
    }

    public VirtualFile getFile(String path) {
        if (this.fileList.contains(path)) {
            return new RelativeLocalFile(new File(this.filePath(path)), this.dir + "$" + path);
        }
        return null;
    }

    private String filePath(String path) {
        return FileUtils.addPathComponents((String)this.dir, (String)path, (char)File.separatorChar);
    }

    public void putFile(VirtualFile file) {
        this.makeDirectory();
        try {
            File tmp = new File(this.filePath(file.getName() + ".tmp"));
            tmp = FileUtils.getAbsoluteFile((File)tmp);
            if (tmp == null) {
                throw new SwcException.FileNotWritten(file.getName(), "");
            }
            tmp.getParentFile().mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            FileUtil.streamOutput(file.getInputStream(), out);
            ((OutputStream)out).close();
            File f = new File(this.filePath(file.getName()));
            FileUtils.renameFile((File)tmp, (File)f);
            this.fileList.add(file.getName());
        }
        catch (SwcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SwcException.FileNotWritten(file.getName(), e.getMessage());
        }
    }

    public void putFile(String path, byte[] data, long lastModified) {
        this.makeDirectory();
        try {
            File tmp = new File(this.filePath(path + ".tmp"));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
            File f = new File(this.filePath(path));
            FileUtils.renameFile((File)tmp, (File)f);
            this.fileList.add(path);
        }
        catch (Exception e) {
            if (Trace.error) {
                e.printStackTrace();
            }
            throw new SwcException.FileNotWritten(path, e.getMessage());
        }
    }

    public long getLastModified() {
        return 0L;
    }

    private void makeDirectory() {
        File d = new File(this.dir);
        if (d.exists() && !d.isDirectory()) {
            throw new SwcException.NotADirectory(this.dir);
        }
        if (!d.exists()) {
            try {
                d.mkdir();
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                throw new SwcException.DirectoryNotCreated(this.dir);
            }
        }
        if (!d.exists() || !d.isDirectory()) {
            throw new SwcException.DirectoryNotCreated(this.dir);
        }
    }

    private static class RelativeLocalFile
    extends LocalFile {
        private String name;

        public RelativeLocalFile(File f, String name) {
            super(f);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

