/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.TagDecoder;
import flash.swf.TagHandler;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoABC;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.NameFormatter;
import flex2.linker.SimpleMovie;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SwcLibrary {
    private final Swc swc;
    private final String path;
    private List scripts;
    private Map name2script;
    private Map def2symbol;
    private boolean parsed;
    private Set externs;
    private String location = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SwcLibrary(Swc swc, String path) {
        this.swc = swc;
        this.path = path;
        this.scripts = new LinkedList();
        this.parsed = false;
        this.name2script = new HashMap();
        this.externs = new HashSet();
    }

    public Swc getSwc() {
        return this.swc;
    }

    public String getPath() {
        return this.path;
    }

    public String getSwcLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.swc.getLocation();
    }

    public long getSwcCreationTime() {
        return this.swc.getLastModified();
    }

    public void clear() {
        this.scripts = null;
        this.def2symbol = null;
    }

    public Set getExterns() {
        return this.externs;
    }

    public SwcScript addScript(String name, Set defs, SwcDependencySet deps, long modtime) {
        SwcScript script = new SwcScript(this, name, defs, deps, modtime);
        this.scripts.add(script);
        this.name2script.put(script.getName(), script);
        if (!($assertionsDisabled || name != null && name.length() > 0)) {
            throw new AssertionError();
        }
        return script;
    }

    public Iterator getScriptIterator() {
        return this.scripts.iterator();
    }

    public DefineTag getSymbol(String name) {
        name = name.replace(':', '.');
        return (DefineTag)this.def2symbol.get(name);
    }

    private SwcScript getScript(DoABC doABC) {
        if (!$assertionsDisabled && doABC.code != 82) {
            throw new AssertionError();
        }
        return (SwcScript)this.name2script.get(doABC.name);
    }

    protected void parse() {
        if (this.parsed) {
            return;
        }
        VirtualFile swcFile = this.swc.getArchive().getFile(this.path);
        if (swcFile == null) {
            throw new SwcException.CatalogNotFound();
        }
        Movie movie = new Movie();
        MovieDecoder movieDecoder = new MovieDecoder(movie);
        try {
            TagDecoder tagDecoder = new TagDecoder(swcFile.getInputStream());
            tagDecoder.parse((TagHandler)movieDecoder);
        }
        catch (IOException e) {
            // empty catch block
        }
        int c1 = 0;
        this.def2symbol = new HashMap();
        Iterator frames = movie.frames.iterator();
        while (frames.hasNext()) {
            int c2;
            Frame frame = (Frame)frames.next();
            Iterator abcit = frame.doABCs.iterator();
            while (abcit.hasNext()) {
                DoABC doABC = (DoABC)abcit.next();
                SwcScript script = this.getScript(doABC);
                script.setDoABC(doABC);
            }
            Iterator it = frame.symbolClass.class2tag.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String className = (String)e.getKey();
                DefineTag tag = (DefineTag)e.getValue();
                this.def2symbol.put(className, tag);
            }
            if (!Swc.FNORD) continue;
            if (frame.label != null) {
                try {
                    c1 = Integer.parseInt(frame.label.label);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (c1 == (c2 = SimpleMovie.getCodeHash(frame))) continue;
            this.location = " " + this.swc.getLocation();
        }
        this.parsed = true;
    }

    void getSymbolClasses(String def, Set symbolClasses) {
        DefineTag t = this.getSymbol(def);
        if (t != null) {
            Iterator i = t.getReferences();
            while (i != null && i.hasNext()) {
                DefineTag r = (DefineTag)i.next();
                if (r == null) continue;
                Iterator j = this.def2symbol.keySet().iterator();
                while (j.hasNext()) {
                    String className = (String)j.next();
                    if (this.def2symbol.get(className) != r) continue;
                    symbolClasses.add(NameFormatter.toColon(className));
                }
            }
        }
    }

    static {
        $assertionsDisabled = !SwcLibrary.class.desiredAssertionStatus();
    }
}

