/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.IntegerPool;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public class LocalLogger
implements Logger {
    private Logger original;
    private Source source;
    private int errorCount;
    private int warningCount;
    private List warnings;
    private LocalizationManager l10n;

    public LocalLogger(Logger original, Source source) {
        this(original);
        this.source = source;
    }

    public LocalLogger(Logger original) {
        while (original instanceof LocalLogger) {
            original = ((LocalLogger)original).original;
        }
        this.original = original;
        this.errorCount = 0;
        this.warningCount = 0;
        this.warnings = null;
    }

    public void setSource(Source s) {
        this.source = s;
    }

    public void disconnect() {
        this.original = null;
        this.source = null;
        this.l10n = null;
    }

    public boolean isConnected() {
        return this.original != null;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public void logInfo(String info) {
        if (this.original != null) {
            this.original.logInfo(info);
        }
    }

    public void logDebug(String debug) {
        if (this.original != null) {
            this.original.logDebug(debug);
        }
    }

    public void logWarning(String warning) {
        if (this.original != null) {
            this.original.logWarning(warning);
        }
        this.recordWarning(warning);
    }

    public void logError(String error) {
        if (this.original != null) {
            this.original.logError(error);
        }
        ++this.errorCount;
    }

    public void logInfo(String path, String info) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, null, null, info, null, null);
            if (misrouteInfo == null) {
                this.original.logInfo(path, info);
            } else {
                this.original.logInfo(this.source.getNameForReporting(), info + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
    }

    public void logDebug(String path, String debug) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, null, null, debug, null, null);
            if (misrouteInfo == null) {
                this.original.logDebug(path, debug);
            } else {
                this.original.logDebug(this.source.getNameForReporting(), debug + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
    }

    public void logWarning(String path, String warning) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, null, null, warning, null, null);
            if (misrouteInfo == null) {
                this.original.logWarning(path, warning);
            } else {
                this.original.logWarning(this.source.getNameForReporting(), warning + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        this.recordWarning(path, warning);
    }

    public void logWarning(String path, String warning, int errorCode) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, null, null, warning, null, IntegerPool.getNumber(errorCode));
            if (misrouteInfo == null) {
                this.original.logWarning(path, warning, errorCode);
            } else {
                this.original.logWarning(this.source.getNameForReporting(), warning + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        this.recordWarning(path, warning, errorCode);
    }

    public void logError(String path, String error) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, null, null, error, null, null);
            if (misrouteInfo == null) {
                this.original.logError(path, error);
            } else {
                this.original.logError(this.source.getNameForReporting(), error + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        ++this.errorCount;
    }

    public void logError(String path, String error, int errorCode) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, null, null, error, null, IntegerPool.getNumber(errorCode));
            if (misrouteInfo == null) {
                this.original.logError(path, error, errorCode);
            } else {
                this.original.logError(this.source.getNameForReporting(), error + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        ++this.errorCount;
    }

    public void logInfo(String path, int line, String info) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), null, info, null, null);
            if (misrouteInfo == null) {
                this.original.logInfo(path, line, info);
            } else {
                this.original.logInfo(this.source.getNameForReporting(), info + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
    }

    public void logDebug(String path, int line, String debug) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), null, debug, null, null);
            if (misrouteInfo == null) {
                this.original.logDebug(path, line, debug);
            } else {
                this.original.logDebug(this.source.getNameForReporting(), debug + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
    }

    public void logWarning(String path, int line, String warning) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), null, warning, null, null);
            if (misrouteInfo == null) {
                this.original.logWarning(path, line, warning);
            } else {
                this.original.logWarning(this.source.getNameForReporting(), warning + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        this.recordWarning(path, line, warning);
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), null, warning, null, IntegerPool.getNumber(errorCode));
            if (misrouteInfo == null) {
                this.original.logWarning(path, line, warning, errorCode);
            } else {
                this.original.logWarning(this.source.getNameForReporting(), warning + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        this.recordWarning(path, line, warning, errorCode);
    }

    public void logError(String path, int line, String error) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), null, error, null, null);
            if (misrouteInfo == null) {
                this.original.logError(path, line, error);
            } else {
                this.original.logError(this.source.getNameForReporting(), error + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        ++this.errorCount;
    }

    public void logError(String path, int line, String error, int errorCode) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), null, error, null, IntegerPool.getNumber(errorCode));
            if (misrouteInfo == null) {
                this.original.logError(path, line, error, errorCode);
            } else {
                this.original.logError(this.source.getNameForReporting(), error + misrouteInfo);
            }
        }
        ++this.errorCount;
    }

    public void logInfo(String path, int line, int col, String info) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), info, null, null);
            if (misrouteInfo == null) {
                this.original.logInfo(path, line, col, info);
            } else {
                this.original.logInfo(this.source.getNameForReporting(), info + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
    }

    public void logDebug(String path, int line, int col, String debug) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), debug, null, null);
            if (misrouteInfo == null) {
                this.original.logDebug(path, line, col, debug);
            } else {
                this.original.logDebug(this.source.getNameForReporting(), debug + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
    }

    public void logWarning(String path, int line, int col, String warning) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), warning, null, null);
            if (misrouteInfo == null) {
                this.original.logWarning(path, line, col, warning);
            } else {
                this.original.logWarning(this.source.getNameForReporting(), warning + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        this.recordWarning(path, line, col, warning);
    }

    public void logError(String path, int line, int col, String error) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), error, null, null);
            if (misrouteInfo == null) {
                this.original.logError(path, line, col, error);
            } else {
                this.original.logError(this.source.getNameForReporting(), error + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        ++this.errorCount;
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), warning, source, null);
            if (misrouteInfo == null) {
                this.original.logWarning(path, line, col, warning, source);
            } else {
                this.original.logWarning(this.source.getNameForReporting(), warning + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        this.recordWarning(path, line, col, warning, source);
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), source, null, IntegerPool.getNumber(errorCode));
            if (misrouteInfo == null) {
                this.original.logWarning(path, line, col, warning, source, errorCode);
            } else {
                this.original.logWarning(this.source.getNameForReporting(), warning + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        this.recordWarning(path, line, col, warning, source, errorCode);
    }

    public void logError(String path, int line, int col, String error, String source) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), error, source, null);
            if (misrouteInfo == null) {
                this.original.logError(path, line, col, error, source);
            } else {
                this.original.logError(this.source.getNameForReporting(), error + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        ++this.errorCount;
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        if (this.original != null) {
            String misrouteInfo = this.checkPath(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), error, source, IntegerPool.getNumber(errorCode));
            if (misrouteInfo == null) {
                this.original.logError(path, line, col, error, source, errorCode);
            } else {
                this.original.logError(this.source.getNameForReporting(), error + misrouteInfo);
                this.logUnmappedError(misrouteInfo);
            }
        }
        ++this.errorCount;
    }

    public void log(ILocalizableMessage m) {
        this.log(m, null);
    }

    public void log(ILocalizableMessage m, String source) {
        if (m.getLevel() == "error") {
            ++this.errorCount;
        } else if (m.getLevel() == "warning") {
            ++this.warningCount;
            this.recordWarning(m.getPath(), m.getLine(), m.getColumn(), this.l10n.getLocalizedTextString((Object)m));
        }
        if (this.original != null) {
            String misrouteInfo = null;
            if (m.isPathAvailable()) {
                misrouteInfo = this.checkPath(m.getPath(), IntegerPool.getNumber(m.getLine()), IntegerPool.getNumber(m.getColumn()), null, null, null);
            }
            if (misrouteInfo == null) {
                if (source == null) {
                    this.original.log(m);
                } else {
                    this.original.log(m, source);
                }
            } else {
                m.setPath(this.source.getNameForReporting());
                m.setLine(-1);
                m.setColumn(-1);
                this.original.log(m);
                this.logUnmappedError(misrouteInfo);
            }
        }
    }

    public void needsCompilation(String path, String reason) {
        if (this.original != null) {
            this.original.needsCompilation(path, reason);
        }
    }

    public void includedFileUpdated(String path) {
        if (this.original != null) {
            this.original.includedFileUpdated(path);
        }
    }

    public void includedFileAffected(String path) {
        if (this.original != null) {
            this.original.includedFileAffected(path);
        }
    }

    public void setLocalizationManager(LocalizationManager mgr) {
        this.l10n = mgr;
    }

    private String checkPath(String p, Integer line, Integer col, String msg, String source, Integer errorCode) {
        boolean result;
        boolean bl = result = !this.source.getNameForReporting().equals(p) && !this.source.isIncludedFile(p);
        if (result) {
            return " [" + new GeneratedCodeMarker().getMessage() + ": " + new PathInfo(p).getMessage() + ", " + new LineInfo(line).getMessage() + ", " + new ColumnInfo(col).getMessage() + "]";
        }
        return null;
    }

    private void logUnmappedError(String misrouteInfo) {
    }

    private String checkPathFull(String p, Integer line, Integer col, String msg, String source, Integer errorCode) {
        boolean result;
        boolean bl = result = !this.source.getNameForReporting().equals(p) && !this.source.isIncludedFile(p);
        if (result) {
            StringWriter misrouteInfo = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)misrouteInfo, true);
            pw.println(new ErrMsgBug().getMessage());
            pw.println(new PathInfo(p).getMessage());
            if (line != null) {
                pw.println(new LineInfo(line).getMessage());
            }
            if (col != null) {
                pw.println(new ColumnInfo(col).getMessage());
            }
            if (msg != null) {
                pw.println(new MessageInfo(msg).getMessage());
            }
            if (source != null) {
                pw.println(new SourceInfo(source).getMessage());
            }
            if (errorCode != null) {
                pw.println(new ErrorCodeInfo(errorCode).getMessage());
            }
            new Exception(new StackTraceInfo().getMessage()).printStackTrace(pw);
            return misrouteInfo.toString();
        }
        return null;
    }

    public void displayWarnings(Logger logger) {
        int size;
        int n = size = this.warnings == null ? 0 : this.warnings.size();
        for (int i = 0; i < size; ++i) {
            Warning w = (Warning)this.warnings.get(i);
            if (w.path != null) {
                if (w.line == null && w.col == null && w.source == null && w.errorCode == null) {
                    logger.logWarning(w.path, w.warning);
                    continue;
                }
                if (w.line == null && w.col == null && w.source == null && w.errorCode != null) {
                    logger.logWarning(w.path, w.warning, w.errorCode);
                    continue;
                }
                if (w.line == null && w.col == null && w.source != null && w.errorCode == null) {
                    logger.logWarning(w.path, w.warning);
                    continue;
                }
                if (w.line == null && w.col == null && w.source != null && w.errorCode != null) {
                    logger.logWarning(w.path, w.warning, w.errorCode);
                    continue;
                }
                if (w.line == null && w.col != null && w.source == null && w.errorCode == null) {
                    logger.logWarning(w.path, w.warning);
                    continue;
                }
                if (w.line == null && w.col != null && w.source == null && w.errorCode != null) {
                    logger.logWarning(w.path, w.warning, w.errorCode);
                    continue;
                }
                if (w.line == null && w.col != null && w.source != null && w.errorCode == null) {
                    logger.logWarning(w.path, w.warning);
                    continue;
                }
                if (w.line == null && w.col != null && w.source != null && w.errorCode != null) {
                    logger.logWarning(w.path, w.warning, w.errorCode);
                    continue;
                }
                if (w.line != null && w.col == null && w.source == null && w.errorCode == null) {
                    logger.logWarning(w.path, w.line, w.warning);
                    continue;
                }
                if (w.line != null && w.col == null && w.source == null && w.errorCode != null) {
                    logger.logWarning(w.path, (int)w.line, w.warning, w.errorCode);
                    continue;
                }
                if (w.line != null && w.col == null && w.source != null && w.errorCode == null) {
                    logger.logWarning(w.path, w.line, w.warning);
                    continue;
                }
                if (w.line != null && w.col == null && w.source != null && w.errorCode != null) {
                    logger.logWarning(w.path, (int)w.line, w.warning, w.errorCode);
                    continue;
                }
                if (w.line != null && w.col != null && w.source == null && w.errorCode == null) {
                    logger.logWarning(w.path, (int)w.line, w.col, w.warning);
                    continue;
                }
                if (w.line != null && w.col != null && w.source == null && w.errorCode != null) {
                    logger.logWarning(w.path, (int)w.line, w.warning, w.errorCode);
                    continue;
                }
                if (w.line != null && w.col != null && w.source != null && w.errorCode == null) {
                    logger.logWarning(w.path, w.line, w.col, w.warning, w.source);
                    continue;
                }
                if (w.line == null || w.col == null || w.source == null || w.errorCode == null) continue;
                logger.logWarning(w.path, w.line, w.col, w.warning, w.source, w.errorCode);
                continue;
            }
            logger.logWarning(w.warning);
        }
    }

    public List getWarnings() {
        return this.warnings;
    }

    private void recordWarning(String warning) {
        this.recordWarning(null, null, null, warning, null, null);
    }

    private void recordWarning(String path, String warning) {
        this.recordWarning(path, null, null, warning, null, null);
    }

    private void recordWarning(String path, String warning, int errorCode) {
        this.recordWarning(path, null, null, warning, null, IntegerPool.getNumber(errorCode));
    }

    private void recordWarning(String path, int line, String warning) {
        this.recordWarning(path, IntegerPool.getNumber(line), null, warning, null, null);
    }

    private void recordWarning(String path, int line, String warning, int errorCode) {
        this.recordWarning(path, IntegerPool.getNumber(line), null, warning, null, IntegerPool.getNumber(errorCode));
    }

    private void recordWarning(String path, int line, int col, String warning) {
        this.recordWarning(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), warning, null, null);
    }

    private void recordWarning(String path, int line, int col, String warning, String source) {
        this.recordWarning(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), warning, source, null);
    }

    private void recordWarning(String path, int line, int col, String warning, String source, int errorCode) {
        this.recordWarning(path, IntegerPool.getNumber(line), IntegerPool.getNumber(col), warning, source, IntegerPool.getNumber(errorCode));
    }

    public void recordWarning(String path, Integer line, Integer col, String warning, String source, Integer errorCode) {
        Warning w = new Warning();
        w.path = path;
        w.warning = warning;
        w.source = source;
        w.line = line;
        w.col = col;
        w.errorCode = errorCode;
        if (this.warnings == null) {
            this.warnings = new LinkedList();
        }
        this.warnings.add(w);
        ++this.warningCount;
    }

    public static class Warning {
        public String path;
        public String warning;
        public String source;
        public Integer line;
        public Integer col;
        public Integer errorCode;
    }

    public static class StackTraceInfo
    extends CompilerMessage.CompilerInfo {
    }

    public static class ErrorCodeInfo
    extends CompilerMessage.CompilerInfo {
        public final int fileerrorCode;

        public ErrorCodeInfo(int e) {
            this.fileerrorCode = e;
        }
    }

    public static class SourceInfo
    extends CompilerMessage.CompilerInfo {
        public final String filesource;

        public SourceInfo(String s) {
            this.filesource = s;
        }
    }

    public static class MessageInfo
    extends CompilerMessage.CompilerInfo {
        public final String filemsg;

        public MessageInfo(String m) {
            this.filemsg = m;
        }
    }

    public static class ColumnInfo
    extends CompilerMessage.CompilerInfo {
        public final int filecol;

        public ColumnInfo(int c) {
            this.filecol = c;
        }
    }

    public static class LineInfo
    extends CompilerMessage.CompilerInfo {
        public final int fileline;

        public LineInfo(int l) {
            this.fileline = l;
        }
    }

    public static class PathInfo
    extends CompilerMessage.CompilerInfo {
        public final String filepath;

        public PathInfo(String p) {
            this.filepath = p;
        }
    }

    public static class ErrMsgBug
    extends CompilerMessage.CompilerInfo {
    }

    public static class GeneratedCodeMarker
    extends CompilerMessage.CompilerInfo {
    }
}

