/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.Source;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import java.io.File;

public class NameFormatter {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String toDot(String ns, String n) {
        return ns.length() > 0 ? ns + '.' + n : n;
    }

    public static String toColon(String ns, String n) {
        return ns.length() > 0 ? (ns + ':' + n).intern() : n;
    }

    public static String toDot(String n) {
        if (!$assertionsDisabled && n.indexOf(47) != -1) {
            throw new AssertionError();
        }
        return NameFormatter.toDot(n, ':');
    }

    public static String toDot(QName qname) {
        return NameFormatter.toDot(qname.getNamespace(), qname.getLocalPart());
    }

    public static String toDot(String n, char delimiter) {
        return n.replace(delimiter, '.');
    }

    public static String toColon(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i > 0 ? (n.substring(0, i) + ':' + n.substring(i + 1)).intern() : n;
    }

    public static String toDotStar(String pkg) {
        return pkg + ".*";
    }

    public static String retrievePackageName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i == -1 ? "" : n.substring(0, i);
    }

    public static String normalizePackageName(String n) {
        return n.endsWith("$internal") ? n.substring(0, n.length() - "$internal".length()) : n;
    }

    public static String retrieveClassName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i == -1 ? n : n.substring(i + 1);
    }

    public static MultiName toMultiName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i >= 0 ? new MultiName(new String[]{n.substring(0, i)}, n.substring(i + 1)) : new MultiName(new String[]{""}, n);
    }

    public static MultiName toMultiName(QName qname) {
        return new MultiName(qname.getNamespace(), qname.getLocalPart());
    }

    public static QName toQName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i >= 0 ? new QName(n.substring(0, i), n.substring(i + 1)) : new QName("", n);
    }

    public static String classNameFromSource(Source source) {
        String path = source.getName();
        String cn = null;
        if (source.isSwcScriptOwner()) {
            if (path.endsWith(")")) {
                int ind = path.lastIndexOf(40);
                if (ind != -1) {
                    cn = path.substring(ind + 1, path.length() - 1);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unknown source name format for SWC source " + path));
            }
        }
        if (cn == null) {
            String fileName;
            String sourceName = NameFormatter.stripDrive(path);
            int sep = sourceName.lastIndexOf(File.separatorChar);
            String string = fileName = sep == -1 ? sourceName : sourceName.substring(sep + 1);
            if (!$assertionsDisabled && fileName.length() <= 0) {
                throw new AssertionError();
            }
            sep = fileName.indexOf(".");
            String string2 = cn = sep > 0 ? fileName.substring(0, sep) : fileName;
            if (source.isResourceBundlePathOwner()) {
                cn = cn + I18nUtils.CLASS_SUFFIX;
            }
        }
        return cn;
    }

    private static String stripDrive(String path) {
        int sep = path.lastIndexOf(58);
        if (sep >= 0) {
            path = path.substring(sep + 1);
        }
        if (path.length() > 0 && path.charAt(0) == File.separatorChar) {
            path = path.substring(1);
        }
        return path;
    }

    public static String nameFromSource(Source src) {
        String rel = src.getRelativePath();
        return (rel == null || rel.equals("") ? "" : rel + "/") + NameFormatter.classNameFromSource(src);
    }

    public static QName qNameFromSource(Source src) {
        String rel = src.getRelativePath();
        String name = (rel == null || rel.equals("") ? "" : rel.replace('/', '.').replace('\\', '.') + ":") + NameFormatter.classNameFromSource(src);
        return new QName(name);
    }

    static {
        $assertionsDisabled = !NameFormatter.class.desiredAssertionStatus();
    }
}

