/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoABC;
import flash.swf.tags.EnableDebugger;
import flash.swf.tags.FileAttributes;
import flash.swf.tags.Metadata;
import flash.swf.tags.ProductInfo;
import flash.swf.tags.ScriptLimits;
import flash.swf.tags.SetBackgroundColor;
import flash.swf.types.FlashUUID;
import flash.swf.types.Rect;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.DependencyGraph;
import flex2.compiler.Source;
import flex2.compiler.util.Algorithms;
import flex2.compiler.util.MD5Crypt;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.Vertex;
import flex2.compiler.util.Visitor;
import flex2.linker.Configuration;
import flex2.linker.LinkerException;
import flex2.tools.PreLink;
import flex2.tools.VersionInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleMovie
extends Movie {
    protected boolean lazyInit;
    protected String rootClassName;
    protected Map exportedUnits;
    protected boolean generateLinkReport;
    protected boolean generateRBList;
    protected String linkReport;
    protected String rbList;

    public SimpleMovie(Configuration configuration) {
        if (configuration.width() != null) {
            try {
                this.width = Integer.parseInt(configuration.width());
            }
            catch (NumberFormatException nfe) {
                ThreadLocalToolkit.log(new PreLink.CouldNotParseNumber(configuration.width(), "width"));
            }
            this.userSpecifiedWidth = true;
        } else if (configuration.widthPercent() != null) {
            this.width = configuration.defaultWidth();
            this.widthPercent = configuration.widthPercent();
        } else {
            this.width = configuration.defaultWidth();
        }
        if (configuration.height() != null) {
            try {
                this.height = Integer.parseInt(configuration.height());
            }
            catch (NumberFormatException nfe) {
                ThreadLocalToolkit.log(new PreLink.CouldNotParseNumber(configuration.height(), "height"));
            }
            this.userSpecifiedHeight = true;
        } else if (configuration.heightPercent() != null) {
            this.height = configuration.defaultHeight();
            this.heightPercent = configuration.heightPercent();
        } else {
            this.height = configuration.defaultHeight();
        }
        this.size = new Rect(this.width * 20, this.height * 20);
        if (configuration.scriptLimitsSet()) {
            this.scriptLimits = new ScriptLimits(configuration.getScriptRecursionLimit(), configuration.getScriptTimeLimit());
        }
        this.framerate = configuration.getFrameRate();
        this.version = 9;
        this.bgcolor = new SetBackgroundColor(configuration.backgroundColor());
        if (configuration.generateDebugTags()) {
            this.enableDebugger = new EnableDebugger(MD5Crypt.md5Crypt(configuration.debugPassword()));
            this.uuid = new FlashUUID();
        }
        if (this.version >= 8) {
            String metadataStr;
            this.fileAttributes = new FileAttributes();
            boolean bl = this.fileAttributes.actionScript3 = this.version >= 9;
            if (configuration.useNetwork()) {
                this.fileAttributes.useNetwork = true;
                boolean bl2 = this.fileAttributes.actionScript3 = this.version >= 9;
            }
            if ((metadataStr = configuration.getMetadata()) != null) {
                this.metadata = new Metadata();
                this.metadata.xml = metadataStr;
                this.fileAttributes.hasMetadata = true;
            }
        }
        long build = 0L;
        try {
            build = Long.parseLong(VersionInfo.getBuild());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.productInfo = new ProductInfo(1, 0, 2, 0, build, System.currentTimeMillis());
        this.pageTitle = configuration.pageTitle();
        this.lazyInit = configuration.lazyInit();
        this.rootClassName = SimpleMovie.formatSymbolClassName(configuration.getRootClassName());
        if (this.rootClassName == null) {
            this.rootClassName = SimpleMovie.formatSymbolClassName(configuration.getMainDefinition());
        }
        this.exportedUnits = new LinkedHashMap();
    }

    protected static String formatSymbolClassName(String className) {
        return className == null ? null : className.replace(':', '.');
    }

    public void generate(List units) throws LinkerException {
        DependencyGraph dependencies = this.extractCompilationUnitInfo(units);
        Frame frame = new Frame();
        this.frames = new ArrayList();
        this.frames.add(frame);
        this.exportDependencies(dependencies, frame);
        this.topLevelClass = SimpleMovie.formatSymbolClassName(this.rootClassName);
        if (ThreadLocalToolkit.errorCount() > 0) {
            throw new LinkerException.LinkingFailed();
        }
    }

    private DependencyGraph extractCompilationUnitInfo(List units) {
        DependencyGraph dependencies = new DependencyGraph();
        CompilationUnit main = null;
        int length = units.size();
        for (int i = 0; i < length; ++i) {
            CompilationUnit u = (CompilationUnit)units.get(i);
            Source s = u.getSource();
            String path = s.getName();
            if (!u.isRoot()) {
                dependencies.put(path, u);
                dependencies.addVertex(new Vertex(path));
                continue;
            }
            main = u;
        }
        if (main != null) {
            dependencies.put(main.getSource().getName(), main);
            dependencies.addVertex(new Vertex(main.getSource().getName()));
        }
        return dependencies;
    }

    protected void exportUnitOnFrame(CompilationUnit u, Frame frame, boolean lazy) {
        if (u == null || u.getSource().isInternal()) {
            return;
        }
        Iterator it = u.getAssets().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String className = (String)entry.getKey();
            DefineTag tag = (DefineTag)entry.getValue();
            if (Trace.dependency) {
                Trace.trace((String)(u.getSource().getName() + " depends on symbolClass " + className));
            }
            frame.addSymbolClass(SimpleMovie.formatSymbolClassName(className), tag);
            if (tag.name == null) continue;
            frame.addExport(tag);
        }
        List fonts = u.getAssets().getFonts();
        if (fonts != null) {
            Iterator iterator = fonts.iterator();
            while (iterator.hasNext()) {
                DefineFont font = (DefineFont)iterator.next();
                frame.addFont(font);
            }
        }
        DoABC tag = null;
        String name = NameFormatter.nameFromSource(u.getSource());
        tag = u.getSource().isEntryPoint() || !lazy ? new DoABC(name, 0) : new DoABC(name, 1);
        tag.abc = u.getByteCodes();
        frame.doABCs.add(tag);
        this.exportedUnits.put(u, frame);
    }

    private void exportDependencies(final DependencyGraph dependencies, final Frame frame) {
        Set cycles = Algorithms.detectCycles(dependencies);
        if (cycles.size() == 0) {
            Algorithms.topologicalSort(dependencies, new Visitor(){

                public void visit(Object v) {
                    String fileName = (String)((Vertex)v).getWeight();
                    CompilationUnit u = (CompilationUnit)dependencies.get(fileName);
                    SimpleMovie.this.exportUnitOnFrame(u, frame, SimpleMovie.this.lazyInit);
                }
            });
        } else {
            ThreadLocalToolkit.logError("The following forms a cycle in the dependency graph: " + cycles.toString());
        }
    }

    public static int getCodeHash(Frame f) {
        int h = f.symbolClass.hashCode();
        Iterator ci = f.doABCs.iterator();
        while (ci.hasNext()) {
            DoABC doABC = (DoABC)ci.next();
            for (int i = 0; i < doABC.abc.length; ++i) {
                h += doABC.abc[i] * 1000003;
            }
        }
        return h & 0xFFFFFF;
    }

    public List getExportedUnits() {
        return new ArrayList(this.exportedUnits.keySet());
    }

    public List getExportedUnitsByFrame(Frame f) {
        ArrayList<CompilationUnit> a = new ArrayList<CompilationUnit>();
        Iterator i = this.exportedUnits.keySet().iterator();
        while (i.hasNext()) {
            CompilationUnit u = (CompilationUnit)i.next();
            Frame frame = (Frame)this.exportedUnits.get(u);
            if (f != frame) continue;
            a.add(u);
        }
        return a;
    }

    public String getLinkReport() {
        return this.linkReport;
    }

    public String getRBList() {
        return this.rbList;
    }
}

