/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.MovieEncoder;
import flash.swf.TagDecoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.LicenseException;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.as3.EmbedExtension;
import flex2.compiler.as3.StyleExtension;
import flex2.compiler.as3.binding.BindableExtension;
import flex2.compiler.as3.managed.ManagedExtension;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.css.Compiler;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.DataTranscoder;
import flex2.compiler.media.FontTranscoder;
import flex2.compiler.media.JPEGTranscoder;
import flex2.compiler.media.LosslessImageTranscoder;
import flex2.compiler.media.MovieTranscoder;
import flex2.compiler.media.SVGTranscoder;
import flex2.compiler.media.SoundTranscoder;
import flex2.compiler.media.XMLTranscoder;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.Compiler;
import flex2.tools.PostLink;
import flex2.tools.PreLink;
import flex2.tools.Target;
import flex2.tools.Tool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class API
extends Tool {
    public static Target compile(VirtualFile targetFile, Configuration configuration, SwcCache swcCache, Map licenseMap) throws CompilerException, LicenseException {
        Target target = new Target();
        try {
            if (configuration.benchmark()) {
                flex2.compiler.API.runBenchmark();
            } else {
                flex2.compiler.API.disableBenchmark();
            }
            target.configuration = configuration;
            flex2.compiler.API.useAS3();
            flex2.compiler.API.usePathResolver();
            flex2.compiler.API.setupHeadless(configuration);
            LocalizationManager l10n = new LocalizationManager();
            l10n.addLocalizer((ILocalizer)new XLRLocalizer());
            l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
            ThreadLocalToolkit.setLocalizationManager(l10n);
            API.checkSupportedTargetMimeType(targetFile);
            ArrayList<VirtualFile> virtualFileList = new ArrayList<VirtualFile>();
            virtualFileList.add(targetFile);
            CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
            NameMappings mappings = flex2.compiler.API.getNameMappings(configuration);
            Transcoder[] transcoders = API.getTranscoders(configuration);
            flex2.compiler.Compiler[] compilers = API.getCompilers(compilerConfig, mappings, transcoders);
            target.fileSpec = new FileSpec(Collections.EMPTY_LIST, API.getFileSpecMimeTypes());
            VirtualFile[] asClasspath = compilerConfig.getSourcePath();
            target.sourceList = new SourceList(virtualFileList, asClasspath, targetFile, API.getSourcePathMimeTypes());
            target.sourcePath = new SourcePath(asClasspath, targetFile, API.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
            target.resources = new ResourceContainer();
            target.bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), targetFile);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.InitialSetup()));
            }
            CompilerSwcContext swcContext = new CompilerSwcContext();
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, swcCache);
            configuration.addExterns(swcContext.getExterns());
            configuration.addIncludes(swcContext.getIncludes());
            configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.LoadedSWCs(swcContext.getNumberLoaded())));
            }
            boolean strict = configuration.getCompilerConfiguration().strict();
            flex2.compiler.API.validateCompilationUnits(target.fileSpec, target.sourceList, target.sourcePath, target.bundlePath, target.resources, swcContext, null, false, strict);
            SymbolTable symbolTable = new SymbolTable(strict, configuration.getCompilerConfiguration().dialect(), configuration.getCompilerConfiguration().suppressWarningsInIncremental());
            target.perCompileData = symbolTable.perCompileData;
            target.units = flex2.compiler.API.compile(target.fileSpec, target.sourceList, null, target.sourcePath, target.resources, target.bundlePath, swcContext, symbolTable, configuration, compilers, new PreLink(), licenseMap, new ArrayList());
            Target target2 = target;
            return target2;
        }
        catch (LicenseException ex) {
            throw ex;
        }
        catch (CompilerException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message == null) {
                message = t.getClass().getName();
            }
            ThreadLocalToolkit.logError(message);
            throw new CompilerException(message);
        }
        finally {
            flex2.compiler.API.removePathResolver();
        }
    }

    public static OutputStream optimize(InputStream in) throws IOException {
        Movie movie = new Movie();
        TagDecoder tagDecoder = new TagDecoder(in);
        MovieDecoder movieDecoder = new MovieDecoder(movie);
        tagDecoder.parse((TagHandler)movieDecoder);
        API.optimize(movie);
        TagEncoder handler = new TagEncoder();
        MovieEncoder encoder = new MovieEncoder((TagHandler)handler);
        encoder.export(movie);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        handler.writeTo((OutputStream)baos);
        return baos;
    }

    public static void optimize(Movie m) {
        PostLink postLink = new PostLink(false, true);
        postLink.run(m);
    }

    public static Transcoder[] getTranscoders(Configuration cfg) {
        return new Transcoder[]{new JPEGTranscoder(), new LosslessImageTranscoder(), new SVGTranscoder(), new SoundTranscoder(), new MovieTranscoder(), new FontTranscoder(cfg), new DataTranscoder(), new XMLTranscoder()};
    }

    public static flex2.compiler.Compiler[] getCompilers(CompilerConfiguration compilerConfig, NameMappings mappings, Transcoder[] transcoders) {
        flex2.compiler.as3.Compiler asc = new flex2.compiler.as3.Compiler(compilerConfig);
        String gendir = compilerConfig.keepGeneratedActionScript() ? compilerConfig.getGeneratedDirectory() : null;
        asc.addCompilerExtension(new EmbedExtension(transcoders, gendir));
        asc.addCompilerExtension(new StyleExtension());
        asc.addCompilerExtension(new BindableExtension(gendir));
        asc.addCompilerExtension(new ManagedExtension(gendir, compilerConfig.getServicesDependencies()));
        flex2.compiler.mxml.Compiler mxmlc = new flex2.compiler.mxml.Compiler(compilerConfig, compilerConfig, mappings, transcoders);
        flex2.compiler.abc.Compiler abc = new flex2.compiler.abc.Compiler(compilerConfig);
        abc.addCompilerExtension(new StyleExtension());
        flex2.compiler.i18n.Compiler prop = new flex2.compiler.i18n.Compiler(compilerConfig);
        Compiler css = new Compiler(compilerConfig, transcoders);
        return new flex2.compiler.Compiler[]{asc, mxmlc, abc, prop, css};
    }

    public static void checkSupportedTargetMimeType(VirtualFile targetFile) throws CompilerException {
        String[] mimeTypes = API.getTargetMimeTypes();
        int length = mimeTypes.length;
        for (int i = 0; i < length; ++i) {
            if (!mimeTypes[i].equals(targetFile.getMimeType())) continue;
            return;
        }
        SourceList.UnsupportedFileType ex = new SourceList.UnsupportedFileType(targetFile.getName());
        ThreadLocalToolkit.log(ex);
        throw ex;
    }

    public static String[] getFileSpecMimeTypes() {
        return new String[]{"text/as", "text/mxml", "application/x-actionscript-bytecode"};
    }

    public static String[] getSourcePathMimeTypes() {
        return new String[]{"text/as", "text/mxml"};
    }

    public static String[] getTargetMimeTypes() {
        return new String[]{"text/as", "text/mxml", "text/css"};
    }
}

