/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.swf.tags.DefineFont;
import flash.util.FileUtils;
import flash.util.Trace;
import flex.messaging.config.ServicesDependencies;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.abc.Class;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.css.StylesContainer;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.linker.CULinkable;
import flex2.linker.DependencyWalker;
import flex2.linker.LinkerException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PreLink
implements flex2.compiler.PreLink {
    static final /* synthetic */ boolean $assertionsDisabled;

    public void run(List sources, List units, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, SymbolTable symbolTable, CompilerSwcContext swcContext, Configuration configuration) {
        this.processMainUnit(sources, units, resources, symbolTable, configuration);
        this.postGenerateExtraCode(sources, units, configuration);
    }

    private void processMainUnit(List sources, List units, ResourceContainer resources, SymbolTable symbolTable, Configuration configuration) {
        CompilationUnit u;
        int i;
        int length = units.size();
        for (i = 0; i < length; ++i) {
            QName qName;
            u = (CompilationUnit)units.get(i);
            if (!u.isRoot()) continue;
            PreLink.swfmetadata(u, configuration);
            if (u.loaderClass != null) {
                configuration.setRootClassName(u.loaderClass);
            }
            if ((qName = u.topLevelDefinitions.last()) != null) {
                String def = qName.toString();
                configuration.setMainDefinition(def);
                u.getContext().setAttribute("mainDefinition", def);
                if (u.loaderClass == null) break;
                StylesContainer stylesContainer = new StylesContainer(configuration.getCompilerConfiguration(), u, symbolTable.perCompileData);
                LinkedList<CULinkable> linkables = new LinkedList<CULinkable>();
                Iterator it2 = units.iterator();
                while (it2.hasNext()) {
                    linkables.add(new CULinkable((CompilationUnit)it2.next()));
                }
                try {
                    int j;
                    DependencyWalker.LinkState state = new DependencyWalker.LinkState(linkables, new HashSet(), configuration.getIncludes(), new HashSet());
                    List styleSources = stylesContainer.processDependencies(state.getDefNames(), resources);
                    if (u.getStylesContainer() != null) {
                        u.getStylesContainer().checkForUnusedTypeSelectors(state.getDefNames());
                    }
                    HashSet<String> sourceSet = new HashSet<String>(sources.size());
                    int size = sources.size();
                    for (j = 0; j < size; ++j) {
                        Source s = (Source)sources.get(j);
                        sourceSet.add(s.getName());
                    }
                    size = styleSources.size();
                    for (j = 0; j < size; ++j) {
                        Source styleSrc = (Source)styleSources.get(j);
                        if (sourceSet.contains(styleSrc.getName())) continue;
                        sources.add(styleSrc);
                    }
                    break;
                }
                catch (LinkerException e) {
                    ThreadLocalToolkit.log(e);
                    break;
                }
            }
            ThreadLocalToolkit.log((CompilerMessage)new NoExternalVisibleDefinition(), u.getSource());
            break;
        }
        length = units.size();
        for (i = 0; i < length; ++i) {
            u = (CompilationUnit)units.get(i);
            if (!u.isDone()) continue;
            u.setStylesContainer(null);
        }
    }

    private static boolean isApplication(SymbolTable symbolTable, String def) {
        String superTypeName;
        boolean result = false;
        Class topLevelClass = symbolTable.getClass(def);
        if (topLevelClass != null && (superTypeName = topLevelClass.getSuperTypeName()) != null) {
            result = superTypeName.equals("mx.core:Application") || superTypeName.endsWith(":Module") ? true : PreLink.isApplication(symbolTable, superTypeName);
        }
        return result;
    }

    private static void swfmetadata(CompilationUnit u, Configuration cfg) {
        if (u.swfMetaData != null) {
            String pageTitle;
            String backgroundColor;
            String frameRate;
            String scriptTimeLimit;
            String scriptRecursionLimit;
            String heightPercent;
            String widthPercent;
            String heightString;
            String widthString = u.swfMetaData.getValue("width");
            if (widthString != null) {
                cfg.setWidth(widthString);
            }
            if ((heightString = u.swfMetaData.getValue("height")) != null) {
                cfg.setHeight(heightString);
            }
            if ((widthPercent = u.swfMetaData.getValue("widthPercent")) != null) {
                cfg.setWidthPercent(widthPercent);
            }
            if ((heightPercent = u.swfMetaData.getValue("heightPercent")) != null) {
                cfg.setHeightPercent(heightPercent);
            }
            if ((scriptRecursionLimit = u.swfMetaData.getValue("scriptRecursionLimit")) != null) {
                try {
                    cfg.setScriptRecursionLimit(Integer.parseInt(scriptRecursionLimit));
                }
                catch (NumberFormatException nfe) {
                    ThreadLocalToolkit.log(new CouldNotParseNumber(scriptRecursionLimit, "scriptRecursionLimit"));
                }
            }
            if ((scriptTimeLimit = u.swfMetaData.getValue("scriptTimeLimit")) != null) {
                try {
                    cfg.setScriptTimeLimit(Integer.parseInt(scriptTimeLimit));
                }
                catch (NumberFormatException nfe) {
                    ThreadLocalToolkit.log(new CouldNotParseNumber(scriptTimeLimit, "scriptTimeLimit"));
                }
            }
            if ((frameRate = u.swfMetaData.getValue("frameRate")) != null) {
                try {
                    cfg.setFrameRate(Integer.parseInt(frameRate));
                }
                catch (NumberFormatException nfe) {
                    ThreadLocalToolkit.log(new CouldNotParseNumber(frameRate, "frameRate"));
                }
            }
            if ((backgroundColor = u.swfMetaData.getValue("backgroundColor")) != null) {
                try {
                    cfg.setBackgroundColor(Integer.decode(backgroundColor));
                }
                catch (NumberFormatException numberFormatException) {
                    ThreadLocalToolkit.log((CompilerMessage)new InvalidBackgroundColor(backgroundColor), u.getSource());
                }
            }
            if ((pageTitle = u.swfMetaData.getValue("pageTitle")) != null) {
                cfg.setPageTitle(pageTitle);
            }
        }
    }

    private void postGenerateExtraCode(List sources, List units, Configuration configuration) {
        LinkedList extraSources = new LinkedList();
        LinkedList mixins = new LinkedList();
        LinkedList fonts = new LinkedList();
        this.processInitClass(units, configuration, extraSources, mixins, fonts);
        this.processLoaderClass(units, configuration, extraSources, mixins, fonts);
        sources.addAll(extraSources);
    }

    private String codegenFlexInit(String flexInitClassName, Set accessibilityList, Map remoteClassAliases, Map effectTriggers, Set inheritingStyles, Configuration configuration) {
        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
        ServicesDependencies servicesDependencies = compilerConfig.getServicesDependencies();
        StringBuffer sb = new StringBuffer();
        sb.append("package {\n");
        sb.append("import flash.utils.*;\n");
        sb.append("import mx.core.IFlexModuleFactory;\n");
        sb.append(this.codegenAccessibilityImports(accessibilityList));
        sb.append(this.codegenRemoteClassImports(remoteClassAliases));
        sb.append(this.codegenEffectTriggerImports(effectTriggers));
        if (servicesDependencies != null) {
            sb.append(servicesDependencies.getImports());
        }
        sb.append("\n[Mixin]\n");
        sb.append("public class " + flexInitClassName + "\n");
        sb.append("{\n");
        sb.append("   public function " + flexInitClassName + "()\n");
        sb.append("   {\n");
        sb.append("       super();\n");
        sb.append("   }\n");
        sb.append("   public static function init(fbs:IFlexModuleFactory):void\n");
        sb.append("   {\n");
        sb.append(this.codegenEffectTriggerRegistration(effectTriggers));
        sb.append(this.codegenAccessibilityList(accessibilityList));
        sb.append(this.codegenRemoteClassAliases(remoteClassAliases));
        sb.append(this.codegenInheritingStyleRegistration(inheritingStyles));
        if (servicesDependencies != null) {
            sb.append(servicesDependencies.getServerConfigXmlInit());
        }
        sb.append("   }\n");
        if (servicesDependencies != null) {
            sb.append(servicesDependencies.getReferences());
        }
        sb.append("}  // FlexInit\n");
        sb.append("}  // package\n");
        return sb.toString();
    }

    private void processInitClass(List units, Configuration configuration, List extraSources, LinkedList mixins, LinkedList fonts) {
        HashSet accessibilityList = null;
        TreeMap remoteClassAliases = new TreeMap();
        TreeMap effectTriggers = new TreeMap();
        HashSet inheritingStyles = new HashSet();
        CompilationUnit mainUnit = null;
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            Set unitAccessibilityList;
            List fontList;
            CompilationUnit u = (CompilationUnit)units.get(i);
            if (u.isRoot()) {
                mainUnit = u;
            }
            if ((fontList = u.getAssets().getFonts()) != null) {
                fonts.addAll(fontList);
            }
            remoteClassAliases.putAll(u.remoteClassAliases);
            effectTriggers.putAll(u.effectTriggers);
            mixins.addAll(u.mixins);
            inheritingStyles.addAll(u.styles.getInheritingStyles());
            if (!configuration.getCompilerConfiguration().accessible() || (unitAccessibilityList = u.getAccessibilityClasses()) == null) continue;
            if (accessibilityList == null) {
                accessibilityList = new HashSet();
            }
            accessibilityList.addAll(unitAccessibilityList);
        }
        String flexInitClass = null;
        if (mainUnit != null) {
            Iterator it = mainUnit.extraClasses.iterator();
            while (it.hasNext()) {
                String extraClass = (String)it.next();
                if (extraClass.indexOf("FlexInit") == -1) continue;
                flexInitClass = extraClass;
                break;
            }
        }
        if (flexInitClass != null) {
            String code = this.codegenFlexInit(flexInitClass, accessibilityList, remoteClassAliases, effectTriggers, inheritingStyles, configuration);
            String name = flexInitClass + "-generated.as";
            if (configuration.getCompilerConfiguration().keepGeneratedActionScript()) {
                this.saveGenerated(name, code, configuration.getCompilerConfiguration().getGeneratedDirectory());
            }
            Source s = new Source((VirtualFile)new TextFile(code, name, null, MimeMappings.getMimeType(name)), "", null, false, false, false);
            s.setPathResolver(null);
            extraSources.add(s);
            mixins.addFirst(flexInitClass);
        }
    }

    private void processLoaderClass(List units, Configuration configuration, List sources, List mixins, List fonts) {
        if (!configuration.generateFrameLoader) {
            return;
        }
        LinkedList frames = new LinkedList();
        frames.addAll(configuration.getFrameList());
        CompilationUnit mainUnit = null;
        Iterator it = units.iterator();
        while (it.hasNext()) {
            CompilationUnit unit = (CompilationUnit)it.next();
            if (!unit.isRoot()) continue;
            mainUnit = unit;
            break;
        }
        if (mainUnit == null) {
            return;
        }
        String generateLoaderClass = null;
        String baseLoaderClass = null;
        String windowClass = null;
        String preloaderClass = null;
        Map rootAttributes = null;
        boolean usePreloader = false;
        List rsls = configuration.getRuntimeSharedLibraries();
        if (mainUnit.loaderClass != null && mainUnit.auxGenerateInfo != null) {
            generateLoaderClass = (String)mainUnit.auxGenerateInfo.get("generateLoaderClass");
            baseLoaderClass = (String)mainUnit.auxGenerateInfo.get("baseLoaderClass");
            windowClass = (String)mainUnit.auxGenerateInfo.get("windowClass");
            preloaderClass = (String)mainUnit.auxGenerateInfo.get("preloaderClass");
            Boolean b = (Boolean)mainUnit.auxGenerateInfo.get("usePreloader");
            rootAttributes = (Map)mainUnit.auxGenerateInfo.get("rootAttributes");
            if (!$assertionsDisabled && generateLoaderClass == null) {
                throw new AssertionError();
            }
        } else if (mainUnit.loaderClass == null && mainUnit.loaderClassBase != null) {
            baseLoaderClass = mainUnit.loaderClassBase;
            windowClass = mainUnit.topLevelDefinitions.last().toString();
            mainUnit.loaderClass = generateLoaderClass = (windowClass + "_" + mainUnit.loaderClassBase).replaceAll("[^A-Za-z0-9]", "_");
        } else {
            if (mainUnit.loaderClass == null && rsls.size() > 0) {
                ThreadLocalToolkit.log((CompilerMessage)new MissingFactoryClassInFrameMetadata(), mainUnit.getSource());
                return;
            }
            return;
        }
        String generatedLoaderCode = this.codegenModuleFactory(baseLoaderClass.replace(':', '.'), generateLoaderClass.replace(':', '.'), windowClass.replace(':', '.'), rootAttributes, rsls, mixins, fonts, frames);
        String generatedLoaderFile = generateLoaderClass + ".as";
        Source s = new Source((VirtualFile)new TextFile(generatedLoaderCode, generatedLoaderFile, null, MimeMappings.getMimeType(generatedLoaderFile)), "", null, false, false, false);
        s.setPathResolver(null);
        sources.add(s);
        if (configuration.getCompilerConfiguration().keepGeneratedActionScript()) {
            this.saveGenerated(generatedLoaderFile, generatedLoaderCode, configuration.getCompilerConfiguration().getGeneratedDirectory());
        }
    }

    private String codegenAccessibilityImports(Set accessibilityImplementations) {
        StringBuffer sb = new StringBuffer();
        sb.append("import flash.system.*\n");
        if (accessibilityImplementations != null) {
            Iterator it = accessibilityImplementations.iterator();
            while (it.hasNext()) {
                sb.append("import " + (String)it.next() + ";\n");
            }
        }
        return sb.toString();
    }

    private void saveGenerated(String name, String code, String dir) {
        String suffix = "-generated.as";
        String as3ext = ".as";
        if (!name.endsWith("-generated.as") && name.endsWith(".as")) {
            name = name.substring(0, name.length() - ".as".length()) + "-generated.as";
        }
        name = FileUtils.addPathComponents((String)dir, (String)name, (char)File.separatorChar);
        try {
            FileUtil.writeFile(name, code);
        }
        catch (IOException e) {
            ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(name, e.getLocalizedMessage()));
        }
    }

    private String codegenRslList(List rsls) {
        if (rsls != null && rsls.size() > 0) {
            StringBuffer rb = new StringBuffer();
            rb.append("[");
            Iterator it = rsls.iterator();
            while (it.hasNext()) {
                rb.append("{url: \"" + it.next() + "\", size: -1}");
                if (!it.hasNext()) continue;
                rb.append(", ");
            }
            rb.append("]\n");
            return rb.toString();
        }
        return "[]";
    }

    private String codegenMixinList(List mixins) {
        if (!($assertionsDisabled || mixins != null && mixins.size() > 0)) {
            throw new AssertionError();
        }
        StringBuffer mb = new StringBuffer();
        mb.append("[");
        Iterator it = mixins.iterator();
        while (it.hasNext()) {
            mb.append("\"" + it.next() + "\"");
            if (!it.hasNext()) continue;
            mb.append(", ");
        }
        mb.append("]\n");
        return mb.toString();
    }

    private String codegenFrameClassList(List frames) {
        if (!($assertionsDisabled || frames != null && frames.size() > 0)) {
            throw new AssertionError();
        }
        StringBuffer mb = new StringBuffer();
        mb.append("{");
        Iterator it = frames.iterator();
        while (it.hasNext()) {
            FramesConfiguration.FrameInfo frameInfo = (FramesConfiguration.FrameInfo)it.next();
            mb.append("\"");
            mb.append(frameInfo.label);
            mb.append("\":\"");
            mb.append(frameInfo.frameClasses.get(0));
            mb.append("\"");
            if (!it.hasNext()) continue;
            mb.append(", ");
        }
        mb.append("}\n");
        return mb.toString();
    }

    private String codegenFontList(List fonts) {
        if (fonts == null || fonts.size() == 0) {
            return "";
        }
        class FontInfo {
            boolean plain;
            boolean bold;
            boolean italic;
            boolean bolditalic;

            FontInfo() {
            }
        }
        TreeMap<String, FontInfo> fontMap = new TreeMap<String, FontInfo>();
        Iterator it = fonts.iterator();
        while (it.hasNext()) {
            DefineFont font = (DefineFont)it.next();
            FontInfo fi = (FontInfo)fontMap.get(font.fontName);
            if (fi == null) {
                fi = new FontInfo();
                fontMap.put(font.fontName, fi);
            }
            fi.plain = fi.plain | (!font.bold && !font.italic);
            fi.bolditalic = fi.bolditalic | (font.bold && font.italic);
            fi.bold |= font.bold;
            fi.italic |= font.italic;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("      {\n");
        Iterator it2 = fontMap.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry e = it2.next();
            String fontName = (String)e.getKey();
            FontInfo fontInfo = (FontInfo)e.getValue();
            sb.append("\"" + fontName + "\" : {" + "regular:" + (fontInfo.plain ? "true" : "false") + ", bold:" + (fontInfo.bold ? "true" : "false") + ", italic:" + (fontInfo.italic ? "true" : "false") + ", boldItalic:" + (fontInfo.bolditalic ? "true" : "false") + "}\n");
            if (!it2.hasNext()) continue;
            sb.append(",\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String codegenAccessibilityList(Set accessibilityImplementations) {
        if (accessibilityImplementations == null || accessibilityImplementations.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (accessibilityImplementations != null && accessibilityImplementations.size() != 0) {
            sb.append("      // trace(\"Flex accessibility startup: \" + Capabilities.hasAccessibility);\n");
            sb.append("      if (Capabilities.hasAccessibility) {\n");
            Iterator it = accessibilityImplementations.iterator();
            while (it.hasNext()) {
                sb.append("         " + (String)it.next() + ".enableAccessibility();\n");
            }
            sb.append("      }\n");
        }
        if (Trace.accessible) {
            Trace.trace((String)"codegenAccessibilityList");
            if (sb.length() > 0) {
                Trace.trace((String)sb.toString());
            } else {
                Trace.trace((String)"empty");
            }
        }
        return sb.toString();
    }

    private String codegenRemoteClassImports(Map remoteClassAliases) {
        StringBuffer sb = new StringBuffer();
        if (remoteClassAliases.size() > 0) {
            sb.append("import flash.net.registerClassAlias;\n");
        }
        Iterator it = remoteClassAliases.keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            sb.append("import " + className + ";\n");
        }
        return sb.toString();
    }

    private String codegenRemoteClassAliases(Map remoteClassAliases) {
        StringBuffer sb = new StringBuffer();
        Iterator it = remoteClassAliases.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String className = (String)e.getKey();
            String alias = (String)e.getValue();
            sb.append("      flash.net.registerClassAlias(\"" + alias + "\", " + className + ");\n");
        }
        return sb.toString();
    }

    private String codegenEffectTriggerImports(Map effectTriggers) {
        if (effectTriggers.size() > 0) {
            return "import mx.effects.EffectManager;\nimport mx.core.mx_internal;\n";
        }
        return "";
    }

    private String codegenEffectTriggerRegistration(Map effectTriggers) {
        StringBuffer sb = new StringBuffer();
        Iterator it = effectTriggers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String name = (String)e.getKey();
            String event = (String)e.getValue();
            sb.append("      EffectManager.mx_internal::registerEffectTrigger(\"" + name + "\", \"" + event + "\");\n");
        }
        return sb.toString();
    }

    private String codegenInheritingStyleRegistration(Set inheritingStyles) {
        StringBuffer sb = new StringBuffer();
        sb.append("      var styleNames:Array = [");
        Iterator iterator = inheritingStyles.iterator();
        while (iterator.hasNext()) {
            String styleName = (String)iterator.next();
            sb.append("\"" + styleName + "\"");
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("];\n\n");
        sb.append("      import mx.styles.StyleManager;\n\n");
        sb.append("      for (var i:int = 0; i < styleNames.length; i++)\n");
        sb.append("      {\n");
        sb.append("         StyleManager.registerInheritingStyle(styleNames[i]);\n");
        sb.append("      }\n");
        return sb.toString();
    }

    private String codegenModuleFactory(String base, String rootClassName, String topLevelWindowClass, Map rootAttributes, List rsls, List mixins, List fonts, List frames) {
        Map.Entry e;
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("package {\n");
        sb.append("import " + base + ";\n");
        sb.append("import flash.utils.*;\n");
        sb.append("import flash.system.ApplicationDomain;\n");
        sb.append("import mx.core.IFlexModuleFactory;\n");
        sb.append("import mx.core.IFlexModule;\n");
        if (rootAttributes != null && rootAttributes.containsKey("preloader")) {
            sb.append("import " + rootAttributes.get("preloader") + ";\n");
        }
        sb.append("public class " + rootClassName + " extends " + base + " implements IFlexModuleFactory {\n");
        sb.append("  public function " + rootClassName + "() {\n");
        sb.append("      super();\n");
        sb.append("}\n");
        sb.append("override public function create(... params):Object\n");
        sb.append("{\n");
        sb.append("  if ((params.length == 0) || (params[0] is String))\n");
        sb.append("  {\n");
        sb.append("    var mainClassName:String = null;\n");
        sb.append("    if (params.length == 0) mainClassName = '" + topLevelWindowClass + "';\n");
        sb.append("    else mainClassName = String(params[0]);\n");
        sb.append("    var clazz:Class = Class(getDefinitionByName(mainClassName));\n");
        sb.append("    if (clazz != null)\n");
        sb.append("    {\n");
        sb.append("      var inst:Object = new clazz();\n");
        sb.append("      if (inst is IFlexModule)\n");
        sb.append("      {\n");
        sb.append("         (IFlexModule(inst)).moduleFactory = this;\n");
        sb.append("      }\n");
        sb.append("      return inst;\n");
        sb.append("    }\n");
        sb.append("    else return null;\n");
        sb.append("  }\n");
        sb.append("  else return super.create.apply(this, params);\n");
        sb.append("}\n");
        TreeMap t = new TreeMap();
        if (rootAttributes != null) {
            it = rootAttributes.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                if ("preloader".equals(e.getKey()) || "usePreloader".equals(e.getKey())) {
                    t.put(e.getKey(), e.getValue());
                    continue;
                }
                t.put(e.getKey(), "\"" + e.getValue() + "\"");
            }
        }
        if (rsls != null && rsls.size() > 0) {
            t.put("rsls", this.codegenRslList(rsls));
        }
        if (fonts != null && fonts.size() > 0) {
            t.put("fonts", this.codegenFontList(fonts));
        }
        if (mixins != null && mixins.size() > 0) {
            t.put("mixins", this.codegenMixinList(mixins));
        }
        if (frames != null && frames.size() > 0) {
            t.put("frames", this.codegenFrameClassList(frames));
        }
        t.put("mainClassName", "\"" + topLevelWindowClass + "\"");
        sb.append("  override public function info():Object { return {\n");
        sb.append("\"currentDomain\": ApplicationDomain.currentDomain");
        if (t.size() > 0) {
            it = t.entrySet().iterator();
            while (it.hasNext()) {
                sb.append(",\n");
                e = it.next();
                sb.append("\"" + (String)e.getKey() + "\" : " + (String)e.getValue());
            }
            sb.append("}; }\n");
        }
        sb.append("}}\n");
        return sb.toString();
    }

    static {
        $assertionsDisabled = !PreLink.class.desiredAssertionStatus();
    }

    public static class CouldNotParseNumber
    extends CompilerMessage.CompilerError {
        public String num;
        public String attribute;

        public CouldNotParseNumber(String num, String attribute) {
            this.num = num;
            this.attribute = attribute;
        }
    }

    public static class InvalidBackgroundColor
    extends CompilerMessage.CompilerError {
        public String backgroundColor;

        public InvalidBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }
    }

    public static class MissingFactoryClassInFrameMetadata
    extends CompilerMessage.CompilerWarning {
    }

    public static class NoExternalVisibleDefinition
    extends CompilerMessage.CompilerError {
    }
}

