/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flex2.compiler.common.Configuration;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.LicensesConfiguration;
import java.io.File;

public class ToolsConfiguration
extends Configuration {
    private LicensesConfiguration licenses = new LicensesConfiguration();
    private VirtualFile licenseFile;

    public LicensesConfiguration getLicensesConfiguration() {
        return this.licenses;
    }

    public VirtualFile getLicenseFile() {
        return this.licenseFile;
    }

    public void validate(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        String licenseFileName = "license.properties";
        String flexlib = configurationBuffer.getToken("flexlib");
        if (flexlib != null) {
            licenseFileName = flexlib + File.separator + licenseFileName;
        }
        this.licenseFile = this.configResolver.resolve(licenseFileName);
        boolean strict = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.strict"));
        boolean as3 = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.as3"));
        boolean es = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.es"));
        if (as3 && es || !as3 && !es) {
            throw new BadAS3ESCombination(as3, es);
        }
        if (strict && es) {
            ThreadLocalToolkit.log(new BadESStrictCombination(es, strict));
        }
    }

    public static class BadESStrictCombination
    extends ConfigurationException {
        public final boolean es;
        public final boolean strict;

        public BadESStrictCombination(boolean es, boolean strict) {
            super("");
            this.es = es;
            this.strict = strict;
        }

        public String getLevel() {
            return "warning";
        }
    }

    public static class BadAS3ESCombination
    extends ConfigurationException {
        public final boolean as3;
        public final boolean es;

        public BadAS3ESCombination(boolean as3, boolean es) {
            super("");
            this.as3 = as3;
            this.es = es;
        }
    }
}

