/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import flash.fonts.CachedFontFace;
import flash.fonts.CachedFontManager;
import flash.fonts.FSType;
import flash.fonts.FontFace;
import flash.fonts.FontManager;
import flash.fonts.FontSet;
import flash.fonts.JREFontManager;
import flash.swf.builder.types.ShapeBuilder;
import flash.swf.builder.types.ShapeIterator;
import flash.swf.types.GlyphEntry;
import flash.swf.types.Shape;
import flash.util.Trace;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.Glyph;
import org.apache.batik.svggen.font.Point;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.CmapTable;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;
import org.apache.batik.svggen.font.table.GlyphDescription;
import org.apache.batik.svggen.font.table.HeadTable;
import org.apache.batik.svggen.font.table.HheaTable;
import org.apache.batik.svggen.font.table.HmtxTable;
import org.apache.batik.svggen.font.table.NameTable;
import org.apache.batik.svggen.font.table.Os2Table;

public class BatikFontManager
extends CachedFontManager {
    private JREFontManager jreManager;
    private Map initializeMap;

    public static String processLocation(Object location) {
        String path = null;
        if (location != null) {
            if (location instanceof URL) {
                URL url = (URL)location;
                if (url.getProtocol().toLowerCase().indexOf("file") > -1) {
                    path = url.getFile();
                }
            } else {
                File f = new File(location.toString());
                if (f.exists()) {
                    path = f.getAbsolutePath();
                }
            }
        }
        return path;
    }

    public void initialize(Map map) {
        super.initialize(map);
        this.initializeMap = map;
    }

    public FontFace getEntryFromSystem(String familyName, int style, boolean useTwips) {
        FontManager manager = this.parent;
        if (manager == null) {
            if (this.jreManager == null) {
                this.jreManager = new JREFontManager();
                this.jreManager.initialize(this.initializeMap);
            }
            manager = this.jreManager;
        }
        return manager.getEntryFromSystem(familyName, style, useTwips);
    }

    protected FontSet createSetForSystemFont(String family, int style, boolean useTwips) {
        FontManager manager = this.parent;
        if (manager == null || !(manager instanceof CachedFontManager)) {
            if (this.jreManager == null) {
                this.jreManager = new JREFontManager();
            }
            manager = this.jreManager;
        }
        return ((CachedFontManager)manager).createSetForSystemFont(family, style, useTwips);
    }

    public FontFace getEntryFromLocation(URL location, int style, boolean useTwips) {
        FontFace entry = null;
        Object fam = this.getFontFileCache().get(location);
        if (fam == null) {
            fam = this.createFontFromLocation(location, style, useTwips);
        }
        if (fam != null) {
            String family = fam.toString();
            FontSet fontSet = (FontSet)this.getFontCache().get(family);
            if (fontSet != null) {
                entry = fontSet.get(style);
            }
        }
        return entry;
    }

    protected String createFontFromLocation(Object location, int style, boolean useTwips) {
        String family = null;
        String path = BatikFontManager.processLocation(location);
        if (path != null) {
            try {
                Font font = Font.create((String)path);
                if (font != null) {
                    FSType type = FSType.getFSType(font);
                    if (!type.usableByFlex) {
                        throw new UnusableFontLicense(location + "", type.description);
                    }
                    String copyright = font.getNameTable().getRecord((short)0);
                    String trademark = font.getNameTable().getRecord((short)7);
                    BatikFontFace fontFace = new BatikFontFace(font, 0, this.maxEntries, type, copyright, trademark, useTwips);
                    family = fontFace.getFamily();
                    FontSet fontSet = (FontSet)this.getFontCache().get(family);
                    if (fontSet == null) {
                        fontSet = new FontSet(this.maxFacesPerFont);
                        this.getFontCache().put(family, fontSet);
                    }
                    fontSet.put(fontFace.style, fontFace);
                }
            }
            catch (UnusableFontLicense l) {
                throw l;
            }
            catch (Throwable t) {
                throw new RuntimeException("Unexpected exception encountered while reading font file '" + path + "'");
            }
        }
        return family;
    }

    public static class UnusableFontLicense
    extends RuntimeException {
        public UnusableFontLicense(String location, String description) {
            super("The font " + location + " has a license that prevents it from being embedded: " + description + ".");
        }
    }

    public static class GlyphIterator
    implements ShapeIterator {
        private final double emScale;
        private double[][] segments;
        private int index;

        public GlyphIterator(Glyph glyph, double emScale) {
            this.emScale = emScale;
            if (glyph != null) {
                this.readPoints(glyph);
            } else {
                this.segments = new double[0][];
            }
        }

        private void readPoints(Glyph glyph) {
            int count = glyph.getPointCount();
            int offset = 0;
            boolean newContour = true;
            ArrayList<double[]> aSegments = new ArrayList<double[]>(count);
            Point lastMove = null;
            while (offset < count - 1) {
                double[] segment;
                Point point = glyph.getPoint(offset);
                if (point.endOfContour) {
                    newContour = true;
                    ++offset;
                    continue;
                }
                Point point_plus1 = glyph.getPoint(offset + 1);
                Point point_plus2 = point_plus1.endOfContour ? lastMove : (offset <= count - 3 ? glyph.getPoint(offset + 2) : null);
                if (newContour) {
                    segment = new double[5];
                    segment[0] = (double)point.x * this.emScale;
                    segment[1] = (double)(-point.y) * this.emScale;
                    segment[4] = 0.0;
                    aSegments.add(segment);
                    newContour = false;
                    lastMove = point;
                    continue;
                }
                if (point.onCurve && point_plus1 != null && point_plus1.onCurve) {
                    segment = new double[5];
                    segment[0] = (double)point_plus1.x * this.emScale;
                    segment[1] = (double)(-point_plus1.y) * this.emScale;
                    segment[4] = 1.0;
                    aSegments.add(segment);
                    ++offset;
                    continue;
                }
                if (point.onCurve && !point_plus1.onCurve && point_plus2.onCurve) {
                    segment = new double[]{(double)point_plus1.x * this.emScale, (double)(-point_plus1.y) * this.emScale, (double)point_plus2.x * this.emScale, (double)(-point_plus2.y) * this.emScale, 2.0};
                    aSegments.add(segment);
                    if (point_plus1.endOfContour) {
                        ++offset;
                        newContour = true;
                        continue;
                    }
                    offset += 2;
                    continue;
                }
                if (point.onCurve && !point_plus1.onCurve && !point_plus2.onCurve) {
                    segment = new double[]{(double)point_plus1.x * this.emScale, (double)(-point_plus1.y) * this.emScale, GlyphIterator.midPoint(point_plus1.x, point_plus2.x) * this.emScale, -GlyphIterator.midPoint(point_plus1.y, point_plus2.y) * this.emScale, 2.0};
                    aSegments.add(segment);
                    if (point_plus1.endOfContour) {
                        ++offset;
                        newContour = true;
                        continue;
                    }
                    offset += 2;
                    continue;
                }
                if (!point.onCurve && !point_plus1.onCurve) {
                    segment = new double[]{(double)point.x * this.emScale, (double)(-point.y) * this.emScale, GlyphIterator.midPoint(point.x, point_plus1.x) * this.emScale, -GlyphIterator.midPoint(point.y, point_plus1.y) * this.emScale, 2.0};
                    aSegments.add(segment);
                    ++offset;
                    continue;
                }
                if (!point.onCurve && point_plus1.onCurve) {
                    segment = new double[]{(double)point.x * this.emScale, (double)(-point.y) * this.emScale, (double)point_plus1.x * this.emScale, (double)(-point_plus1.y) * this.emScale, 2.0};
                    aSegments.add(segment);
                    ++offset;
                    continue;
                }
                ++offset;
            }
            this.segments = new double[aSegments.size()][];
            this.segments = (double[][])aSegments.toArray((T[])this.segments);
        }

        private static double midPoint(int a, int b) {
            return (double)a + (double)(b - a) / 2.0;
        }

        public short currentSegment(double[] coords) {
            coords[0] = this.segments[this.index][0];
            coords[1] = this.segments[this.index][1];
            coords[2] = this.segments[this.index][2];
            coords[3] = this.segments[this.index][3];
            return (short)this.segments[this.index][4];
        }

        public boolean isDone() {
            return this.segments == null || this.index >= this.segments.length;
        }

        public void next() {
            ++this.index;
        }
    }

    public static class BatikFontFace
    extends CachedFontFace {
        static final short PLATFORM_APPLE_UNICODE = 0;
        static final short PLATFORM_MACINTOSH = 1;
        static final short PLATFORM_ISO = 2;
        static final short PLATFORM_MICROSOFT = 3;
        static final short ENCODING_UNDEFINED = 0;
        static final short ENCODING_UGL = 1;
        static final short ENCODING_ROMAN = 0;
        private CmapFormat cmapFmt = null;
        private GlyfTable glyf;
        private HmtxTable hmtx;
        private int horizAdvanceX;
        private String fontFamily;
        private String subFamilyName;
        private String postscriptName;
        private short unitsPerEm;
        private String panose;
        private short ascent;
        private short descent;
        private short lineGap;
        private int baseline;
        private boolean forceAscii;
        private double emScale;
        private int numGlyphs;
        private short platformID;
        private short encodingID;
        private int usFirstCharIndex;
        private int usLastCharIndex;
        private int missingGlyphCode = 0;

        public BatikFontFace(Font font, int style, int maxGlyphs, FSType fsType, String copyright, String trademark, boolean useTwips) {
            super(maxGlyphs, style, fsType, copyright, trademark, useTwips);
            this.init(font);
        }

        private void init(Font font) {
            this.numGlyphs = font.getNumGlyphs();
            this.processCmapTable(font);
            this.processNameTable(font);
            this.processHeadTable(font);
            this.processHheaTable(font);
            this.processOS2Table(font);
            this.hmtx = (HmtxTable)font.getTable(1752003704);
            this.glyf = (GlyfTable)font.getTable(1735162214);
        }

        private void processCmapTable(Font font) {
            CmapTable cmap = font.getCmapTable();
            if (cmap != null) {
                if (this.forceAscii) {
                    this.cmapFmt = cmap.getCmapFormat((short)1, (short)0);
                    this.platformID = 1;
                    this.encodingID = 0;
                } else {
                    this.cmapFmt = cmap.getCmapFormat((short)3, (short)1);
                    if (this.cmapFmt == null) {
                        this.cmapFmt = cmap.getCmapFormat((short)3, (short)0);
                        this.platformID = (short)3;
                        this.encodingID = 0;
                    } else {
                        this.platformID = (short)3;
                        this.encodingID = 1;
                    }
                }
            }
            if (this.cmapFmt == null) {
                throw new RuntimeException("Cannot find a suitable cmap table");
            }
        }

        private void processNameTable(Font font) {
            NameTable name = font.getNameTable();
            if (name != null) {
                this.fontFamily = name.getRecord((short)1);
                this.subFamilyName = name.getRecord((short)2);
                this.postscriptName = name.getRecord((short)6);
                if (this.subFamilyName != null) {
                    this.style = BatikFontFace.guessStyleFromSubFamilyName(this.subFamilyName);
                }
            } else if (Trace.font) {
                Trace.trace("Font " + this.fontFamily + " did not have a NAME Table.");
            }
        }

        private void processHeadTable(Font font) {
            HeadTable head = font.getHeadTable();
            this.baseline = 0;
            if (head != null) {
                this.unitsPerEm = head.getUnitsPerEm();
                short flags = head.getFlags();
                if ((flags & 1) == 0) {
                    this.baseline = 0;
                }
            } else if (Trace.font) {
                Trace.trace("Font " + this.fontFamily + " did not have an HEAD Table.");
            }
            this.emScale = 1024.0 / (double)this.unitsPerEm;
        }

        private void processHheaTable(Font font) {
            HheaTable hhea = font.getHheaTable();
            if (hhea != null) {
                this.ascent = (short)Math.rint((double)hhea.getAscender() * this.emScale * (double)(this.useTwips ? 20 : 1));
                this.descent = (short)Math.rint((double)hhea.getDescender() * this.emScale * (double)(this.useTwips ? 20 : 1));
                this.lineGap = (short)Math.rint((double)hhea.getLineGap() * this.emScale * (double)(this.useTwips ? 20 : 1));
            } else if (Trace.font) {
                Trace.trace("Font " + this.fontFamily + " did not have an HHEA Table.");
            }
        }

        private void processOS2Table(Font font) {
            Os2Table os2 = font.getOS2Table();
            if (os2 != null) {
                if (!this.forceAscii) {
                    int winAscent = os2.getWinAscent();
                    this.ascent = (short)Math.rint((double)winAscent * this.emScale * (double)(this.useTwips ? 20 : 1));
                    int winDescent = os2.getWinDescent();
                    this.descent = (short)Math.rint((double)winDescent * this.emScale * (double)(this.useTwips ? 20 : 1));
                    short winLeading = os2.getTypoLineGap();
                    this.lineGap = (short)Math.rint((double)winLeading * this.emScale * (double)(this.useTwips ? 20 : 1));
                }
                this.horizAdvanceX = os2.getAvgCharWidth();
                this.panose = os2.getPanose().toString();
                this.usFirstCharIndex = os2.getFirstCharIndex();
                this.usLastCharIndex = os2.getLastCharIndex();
            } else if (Trace.font) {
                Trace.trace("Font " + this.fontFamily + " did not have an OS2 Table.");
            }
        }

        public boolean canDisplay(char c) {
            return this.cmapFmt.mapCharCode(this.getCharIndex(c)) > 0;
        }

        public GlyphEntry getGlyphEntry(char c) {
            return (GlyphEntry)this.glyphCache.get(c);
        }

        protected GlyphEntry createGlyphEntry(char c) {
            return this.createGlyphEntry(c, c);
        }

        public GlyphEntry createGlyphEntry(char c, char referenceChar) {
            int index = this.getCharIndex(referenceChar);
            index = this.cmapFmt.mapCharCode(index);
            Glyph glyph = this.getGlyph(index);
            Shape s = this.getShapeFromGlyph(glyph);
            GlyphEntry ge = new GlyphEntry();
            ge.advance = (int)((double)this.getAdvance(referenceChar) * this.emScale * (double)(this.useTwips ? 20 : 1));
            ge.character = c;
            ge.setShape(s);
            ge.bounds = null;
            return ge;
        }

        public int getFirstChar() {
            if (this.platformID == 3 && this.encodingID == 0) {
                return this.usFirstCharIndex - 61440;
            }
            return this.usFirstCharIndex;
        }

        private int getCharIndex(char index) {
            if (this.platformID == 3 && this.encodingID == 0) {
                index = (char)(index + (this.usFirstCharIndex - (this.usFirstCharIndex - 61440)));
            }
            return index;
        }

        private Glyph getGlyph(int index) {
            Glyph glyph = null;
            GlyfDescript desc = this.glyf.getDescription(index);
            if (desc != null) {
                glyph = new Glyph((GlyphDescription)this.glyf.getDescription(index), this.hmtx.getLeftSideBearing(index), this.hmtx.getAdvanceWidth(index));
            }
            return glyph;
        }

        private Shape getShapeFromGlyph(Glyph glyph) {
            ShapeBuilder shape = new ShapeBuilder(this.useTwips);
            shape.setCurrentLineStyle(0);
            shape.setCurrentFillStyle1(1);
            shape.setUseFillStyle1(true);
            shape.processShape(new GlyphIterator(glyph, this.emScale));
            return shape.build();
        }

        public int getAdvance(char c) {
            if (this.hmtx != null) {
                int index = this.getCharIndex(c);
                index = this.cmapFmt.mapCharCode(index);
                return this.hmtx.getAdvanceWidth(index);
            }
            return this.horizAdvanceX;
        }

        public int getAscent() {
            return this.ascent;
        }

        public int getDescent() {
            return this.descent;
        }

        public String getFamily() {
            return this.fontFamily;
        }

        public int getLineGap() {
            return this.lineGap;
        }

        public int getMissingGlyphCode() {
            return this.missingGlyphCode;
        }

        public int getNumGlyphs() {
            return this.numGlyphs;
        }

        public double getPointSize() {
            return 1.0;
        }

        public String getPanose() {
            return this.panose;
        }

        public short getUnitsPerEm() {
            return this.unitsPerEm;
        }

        public double getEmScale() {
            return this.emScale;
        }

        public String getPostscriptName() {
            return this.postscriptName;
        }
    }
}

