/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.localization.LocalizationManager;
import flash.tools.debugger.ApolloLaunchInfo;
import flash.tools.debugger.CommandLineException;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.DefaultDebuggerCallbacks;
import flash.tools.debugger.IDebuggerCallbacks;
import flash.tools.debugger.IProgress;
import flash.tools.debugger.Player;
import flash.tools.debugger.Session;
import flash.tools.debugger.SessionManager;
import flash.tools.debugger.concrete.ActiveXPlayer;
import flash.tools.debugger.concrete.NetscapePluginPlayer;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.ProcessListener;
import flash.tools.debugger.concrete.StandalonePlayer;
import flash.tools.debugger.concrete.StreamListener;
import flash.util.URLHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PlayerSessionManager
implements SessionManager {
    ServerSocket m_serverSocket = null;
    HashMap m_prefs;
    boolean m_processDead;
    private IDebuggerCallbacks m_debuggerCallbacks = new DefaultDebuggerCallbacks();
    private static LocalizationManager m_localizationManager = new LocalizationManager();
    private StringWriter m_processMessages;
    private String[] m_launchCommand;

    public PlayerSessionManager() {
        this.m_prefs = new HashMap();
        this.setPreference("$accepttimeout", 120000);
        this.setPreference("$urimodification", 1);
        this.setPreference("$responsetimeout", 750);
        this.setPreference("$contextresponsetimeout", 1000);
        this.setPreference("$getvarresponsetimeout", 1500);
        this.setPreference("$setvarresponsetimeout", 5000);
        this.setPreference("$swfswdloadtimeout", 5000);
        this.setPreference("$suspendwait", 7000);
        this.setPreference("$invokegetters", 1);
    }

    public void setPreference(String pref, int value) {
        this.m_prefs.put(pref, new Integer(value));
    }

    public void setPreference(String pref, String value) {
        this.m_prefs.put(pref, value);
    }

    public Set keySet() {
        return this.m_prefs.keySet();
    }

    public Object getPreferenceAsObject(String pref) {
        return this.m_prefs.get(pref);
    }

    public int getPreference(String pref) {
        int val = 0;
        Integer i = (Integer)this.m_prefs.get(pref);
        if (i == null) {
            throw new NullPointerException();
        }
        val = i;
        return val;
    }

    public void startListening() throws IOException {
        if (this.m_serverSocket == null) {
            this.m_serverSocket = new ServerSocket(7935);
        }
    }

    public void stopListening() throws IOException {
        if (this.m_serverSocket != null) {
            this.m_serverSocket.close();
            this.m_serverSocket = null;
        }
    }

    public boolean isListening() {
        return this.m_serverSocket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session launch(String uri, ApolloLaunchInfo apolloLaunchInfo, boolean forDebugging, IProgress waitReporter) throws IOException {
        int launchAction;
        block37: {
            block38: {
                File playerExe;
                String osName;
                LaunchInfo launchInfo;
                block42: {
                    File httpExe;
                    block41: {
                        boolean isMacOSX;
                        boolean nativeLaunch;
                        block40: {
                            block39: {
                                int modify = this.getPreference("$urimodification");
                                launchInfo = new LaunchInfo(uri);
                                nativeLaunch = launchInfo.isWebBrowserNativeLaunch() || launchInfo.isPlayerNativeLaunch();
                                boolean NO_ACTION = false;
                                boolean SHOULD_LISTEN = true;
                                int WAIT_FOR_LAUNCH = 2;
                                uri = uri.trim();
                                osName = System.getProperty("os.name").toLowerCase();
                                isMacOSX = osName.startsWith("mac os x");
                                if (apolloLaunchInfo != null) break block38;
                                if (!launchInfo.isHttp()) break block39;
                                if (modify != 0 && forDebugging) {
                                    String originalQuery = URLHelper.getQueryString(uri = URLHelper.escapeSpace(uri));
                                    if (originalQuery != null) {
                                        uri = uri.substring(0, uri.indexOf(63));
                                    }
                                    Map params = URLHelper.getParameterMap(originalQuery);
                                    params.put("debug", "true");
                                    String query = URLHelper.encode(params, !nativeLaunch);
                                    if (query != null) {
                                        uri = uri + "?" + query;
                                    }
                                }
                                break block40;
                            }
                            File f = null;
                            if (uri.startsWith("file:")) {
                                try {
                                    f = new File(new URI(uri));
                                }
                                catch (URISyntaxException e) {
                                    IOException ioe = new IOException(e.getMessage());
                                    ioe.initCause(e);
                                    throw ioe;
                                }
                            } else {
                                f = new File(uri);
                            }
                            if (f == null) throw new FileNotFoundException(uri);
                            if (!f.exists()) throw new FileNotFoundException(uri);
                            uri = f.getCanonicalPath();
                        }
                        launchAction = nativeLaunch ? 0 : 0;
                        if (!isMacOSX) break block41;
                        if (launchInfo.isWebBrowserNativeLaunch()) {
                            httpExe = this.m_debuggerCallbacks.getHttpExe();
                            this.m_launchCommand = new String[]{"/usr/bin/open", "-a", httpExe.toString(), uri};
                            break block37;
                        } else if (launchInfo.isPlayerNativeLaunch()) {
                            playerExe = this.m_debuggerCallbacks.getPlayerExe();
                            this.m_launchCommand = new String[]{"/usr/bin/open", "-a", playerExe.toString(), uri};
                            break block37;
                        } else {
                            this.m_launchCommand = new String[]{"/usr/bin/open", uri};
                        }
                        break block37;
                    }
                    if (!launchInfo.isWebBrowserNativeLaunch()) break block42;
                    httpExe = this.m_debuggerCallbacks.getHttpExe();
                    this.m_launchCommand = new String[]{httpExe.toString(), uri};
                    break block37;
                }
                if (launchInfo.isPlayerNativeLaunch()) {
                    playerExe = this.m_debuggerCallbacks.getPlayerExe();
                    this.m_launchCommand = new String[]{playerExe.toString(), uri};
                    break block37;
                } else if (osName.startsWith("windows")) {
                    this.m_launchCommand = new String[]{"cmd", "/c", "start", uri};
                    break block37;
                } else {
                    String exeName;
                    if (launchInfo.isWebPage()) {
                        exeName = this.m_debuggerCallbacks.getHttpExeName();
                        throw new FileNotFoundException(exeName);
                    }
                    exeName = this.m_debuggerCallbacks.getPlayerExeName();
                    throw new FileNotFoundException(exeName);
                }
            }
            launchAction = forDebugging ? 1 : 0;
            LinkedList<String> cmdList = new LinkedList<String>();
            cmdList.add(apolloLaunchInfo.apolloDebugLauncher.getPath());
            if (apolloLaunchInfo.apolloRuntimeDir != null) {
                cmdList.add("-runtime");
                cmdList.add(apolloLaunchInfo.apolloRuntimeDir.getPath());
            }
            if (apolloLaunchInfo.apolloSecurityPolicy != null) {
                cmdList.add("-security-policy");
                cmdList.add(apolloLaunchInfo.apolloSecurityPolicy.getPath());
            }
            File f = null;
            if (uri.startsWith("file:")) {
                try {
                    f = new File(new URI(uri));
                    cmdList.add(f.getPath());
                }
                catch (URISyntaxException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
            } else {
                cmdList.add(uri);
            }
            this.m_launchCommand = cmdList.toArray(new String[cmdList.size()]);
        }
        ProcessListener pl = null;
        PlayerSession session = null;
        try {
            Process proc = this.m_debuggerCallbacks.launchDebugTarget(this.m_launchCommand);
            this.m_processMessages = new StringWriter();
            new StreamListener(new InputStreamReader(proc.getInputStream()), this.m_processMessages).start();
            new StreamListener(new InputStreamReader(proc.getErrorStream()), this.m_processMessages).start();
            try {
                OutputStream stm = proc.getOutputStream();
                if (stm != null) {
                    stm.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            switch (launchAction) {
                case 0: {
                    break;
                }
                case 1: {
                    pl = new ProcessListener(this, proc);
                    pl.start();
                    break;
                }
                case 2: {
                    boolean done = false;
                    while (!done) {
                        try {
                            proc.waitFor();
                            done = true;
                        }
                        catch (InterruptedException e) {}
                    }
                    if (proc.exitValue() == 0) break;
                    throw new IOException(this.m_processMessages.toString());
                }
            }
            if (!forDebugging) return session;
            session = (PlayerSession)this.accept(waitReporter);
            session.setProcess(proc);
            session.setLaunchUrl(uri);
            session.setApolloLaunchInfo(apolloLaunchInfo);
            return session;
        }
        finally {
            if (pl != null) {
                pl.finish();
            }
        }
    }

    public Player playerForUri(String url) {
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            File flashPlugin = new File("/Library/Internet Plug-Ins/Flash Player.plugin");
            return new NetscapePluginPlayer(this.m_debuggerCallbacks.getHttpExe(), flashPlugin);
        }
        LaunchInfo launchInfo = new LaunchInfo(url);
        if (launchInfo.isWebBrowserNativeLaunch()) {
            File pathFromRegistry;
            File pluginsDir;
            File flashPlugin;
            File httpExe = this.m_debuggerCallbacks.getHttpExe();
            if (httpExe.getName().equalsIgnoreCase("iexplore.exe")) {
                String activeXFile = null;
                try {
                    activeXFile = this.m_debuggerCallbacks.queryWindowsRegistry("HKEY_CLASSES_ROOT\\CLSID\\{D27CDB6E-AE6D-11cf-96B8-444553540000}\\InprocServer32", null);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (activeXFile == null) {
                    return null;
                }
                File file = new File(activeXFile);
                return new ActiveXPlayer(httpExe, file);
            }
            File browserDir = httpExe.getParentFile();
            if (httpExe.getName().equalsIgnoreCase("opera.exe")) {
                browserDir = new File(browserDir, "program");
            }
            if (!(flashPlugin = new File(pluginsDir = new File(browserDir, "plugins"), "NPSWF32.dll")).exists() && (pathFromRegistry = this.getWindowsMozillaPlayerPathFromRegistry()) != null) {
                flashPlugin = pathFromRegistry;
            }
            return new NetscapePluginPlayer(httpExe, flashPlugin);
        }
        if (launchInfo.isPlayerNativeLaunch()) {
            File playerExe = this.m_debuggerCallbacks.getPlayerExe();
            return new StandalonePlayer(playerExe);
        }
        return null;
    }

    private File getWindowsMozillaPlayerPathFromRegistry() {
        String KEY = "\\SOFTWARE\\MozillaPlugins\\@adobe.com/FlashPlayer";
        String PATH = "Path";
        String[] roots = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
        for (int i = 0; i < roots.length; ++i) {
            try {
                String path = this.m_debuggerCallbacks.queryWindowsRegistry(roots[i] + "\\SOFTWARE\\MozillaPlugins\\@adobe.com/FlashPlayer", "Path");
                if (path == null) continue;
                return new File(path);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean supportsLaunch() {
        return true;
    }

    public void setProcessDead() {
        this.m_processDead = true;
    }

    public Session accept(IProgress waitReporter) throws IOException {
        int timeout;
        int totalTimeout = timeout = this.getPreference("$accepttimeout");
        int iterateOn = 100;
        PlayerSession session = null;
        try {
            this.m_processDead = false;
            this.m_serverSocket.setSoTimeout(iterateOn);
            Socket s = null;
            while (s == null && !this.m_processDead) {
                block11: {
                    try {
                        s = this.m_serverSocket.accept();
                    }
                    catch (IOException ste) {
                        if ((timeout -= iterateOn) >= 0 && this.m_serverSocket != null && !this.m_serverSocket.isClosed()) break block11;
                        throw ste;
                    }
                }
                if (waitReporter == null) continue;
                waitReporter.setProgress(totalTimeout - timeout, totalTimeout);
            }
            if (s == null && this.m_processDead) {
                String commandLineMessage;
                IOException e = null;
                String detailMessage = PlayerSessionManager.getLocalizationManager().getLocalizedTextString("processTerminatedWithoutDebuggerConnection");
                if (this.m_processMessages != null && (commandLineMessage = this.m_processMessages.toString()).length() > 0) {
                    e = new CommandLineException(detailMessage, this.m_launchCommand, commandLineMessage);
                }
                if (e == null) {
                    e = new IOException(detailMessage);
                }
                throw e;
            }
            session = PlayerSession.createFromSocket(s);
            session.setPreferences(this.m_prefs);
        }
        catch (NullPointerException npe) {
            throw new BindException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("serverSocketNotListening"));
        }
        finally {
            this.m_processMessages = null;
            this.m_launchCommand = null;
        }
        return session;
    }

    public IDebuggerCallbacks getDebuggerCallbacks() {
        return this.m_debuggerCallbacks;
    }

    public void setDebuggerCallbacks(IDebuggerCallbacks debuggerCallbacks) {
        this.m_debuggerCallbacks = debuggerCallbacks;
    }

    public static LocalizationManager getLocalizationManager() {
        return m_localizationManager;
    }

    static {
        m_localizationManager.addLocalizer(new DebuggerLocalizer("flash.tools.debugger.concrete.djapi."));
    }

    private class LaunchInfo {
        private String m_uri;

        public LaunchInfo(String uri) {
            this.m_uri = uri;
        }

        public boolean isHttp() {
            return this.m_uri.startsWith("http:") || this.m_uri.startsWith("https:") || this.m_uri.startsWith("about:");
        }

        public boolean isWebPage() {
            return this.isHttp() || this.m_uri.endsWith(".htm") || this.m_uri.endsWith(".html");
        }

        public boolean isWebBrowserNativeLaunch() {
            return this.isWebPage() && PlayerSessionManager.this.m_debuggerCallbacks.getHttpExe() != null;
        }

        public boolean isPlayerNativeLaunch() {
            return this.m_uri.length() > 0 && !this.isWebPage() && PlayerSessionManager.this.m_debuggerCallbacks.getPlayerExe() != null;
        }
    }
}

