/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import macromedia.abc.AbcParser;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.Decoder;
import macromedia.abc.Encoder;
import macromedia.asc.embedding.Compiler;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.semantics.CodeGenerator;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.UnresolvedNamespace;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Names;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.StringPrintWriter;
import macromedia.asc.util.graph.Algorithms;
import macromedia.asc.util.graph.DependencyGraph;
import macromedia.asc.util.graph.Vertex;
import macromedia.asc.util.graph.Visitor;

public class ScriptCompiler {
    private static List<File> file;
    private static List<Context> cx;
    private static List<ActionBlockEmitter> emitter;
    private static List<ProgramNode> node;
    private static List<FlowAnalyzer> fa;
    private static Set<Pair> inheritance;
    private static Set<Pair> type;
    private static ContextStatics s;
    private static ActionBlockEmitter mainEmitter;
    private static Context mainContext;
    private static File mainFile;
    private static String outputFile;
    private static boolean builtinFlag;
    private static boolean debugFlag;

    public static void main(String[] args) throws Throwable {
        long startTime = System.currentTimeMillis();
        ScriptCompiler.init(args);
        int start = 0;
        int end = file.size();
        while (start < end) {
            ScriptCompiler.parse(start, end);
            ScriptCompiler.fa_part1(start, end);
            ScriptCompiler.resolveInheritance(start, end);
            start = end;
            end = file.size();
            if (start < end) continue;
            ScriptCompiler.sortInheritance();
            ScriptCompiler.fa_part2();
            ScriptCompiler.resolveType();
            start = end;
            end = file.size();
            if (start < end) continue;
            ScriptCompiler.importType();
            ScriptCompiler.md();
            ScriptCompiler.ce();
            ScriptCompiler.cg();
            ScriptCompiler.resolveExpression();
            start = end;
            end = file.size();
        }
        ScriptCompiler.clear();
        System.err.println("Files: " + file.size() + " Time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    private static void init(String[] args) throws Throwable {
        int i;
        ObjectList<String> filespecs = new ObjectList<String>();
        ObjectList<Boolean> imported = new ObjectList<Boolean>();
        boolean use_static_semantics = false;
        int length = args.length;
        for (i = 0; i < length; ++i) {
            if (args[i].equals("-builtin")) {
                builtinFlag = true;
                continue;
            }
            if (args[i].equals("-abcfuture")) {
                Features.FUTURE_ABC = true;
                continue;
            }
            if (args[i].equals("-strict")) {
                use_static_semantics = true;
                continue;
            }
            if (args[i].equals("-d")) {
                debugFlag = true;
                continue;
            }
            if (args[i].equals("-out")) {
                outputFile = args[++i];
                continue;
            }
            if (args[i].equals("-import")) {
                filespecs.add(args[++i]);
                imported.add(new Boolean(true));
                continue;
            }
            filespecs.add(args[i]);
            imported.add(new Boolean(false));
        }
        TypeValue.init();
        ObjectValue.init();
        s = new ContextStatics();
        ScriptCompiler.s.use_static_semantics = use_static_semantics;
        file = new ArrayList<File>(filespecs.size());
        cx = new ArrayList<Context>(filespecs.size());
        emitter = new ArrayList<ActionBlockEmitter>(filespecs.size());
        length = filespecs.size();
        for (i = 0; i < length; ++i) {
            boolean importFlag = (Boolean)imported.get(i);
            File f = new File((String)filespecs.get(i));
            if (!f.exists() || !f.isFile()) continue;
            f = f.getCanonicalFile();
            file.add(f);
            Context cxFile = new Context(s);
            cx.add(cxFile);
            if (!importFlag) {
                mainFile = f;
                mainContext = cxFile;
            }
            if (importFlag) {
                emitter.add(new ActionBlockEmitter(cxFile, f.getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, debugFlag));
                continue;
            }
            if (mainEmitter == null) {
                mainEmitter = new ActionBlockEmitter(cxFile, f.getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, debugFlag);
            }
            emitter.add(mainEmitter);
        }
        node = new ArrayList<ProgramNode>(file.size());
        fa = new ArrayList<FlowAnalyzer>(file.size());
        inheritance = new HashSet<Pair>();
        type = new HashSet<Pair>();
    }

    private static void parse(int start, int end) throws Throwable {
        for (int i = start; i < end; ++i) {
            cx.get(i).setEmitter(emitter.get(i));
            cx.get(i).setScriptName(file.get(i).getName());
            cx.get(i).setPath(file.get(i).getParent());
            if (file.get(i).getName().endsWith(".as")) {
                node.add(new Parser(cx.get(i), new FileInputStream(file.get(i)), file.get(i).getPath(), null).parseProgram());
            } else {
                node.add(new AbcParser(cx.get(i), file.get(i).getPath()).parseAbc());
            }
            ScriptCompiler.cx.get((int)i).getNodeFactory().pkg_defs.clear();
            ScriptCompiler.cx.get((int)i).getNodeFactory().compound_names.clear();
        }
    }

    private static void fa_part1(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (cx.get(i).errorCount() != 0 || ScriptCompiler.node.get((int)i).state != 1) continue;
            cx.get(i).pushScope(new ObjectValue(cx.get(i), new GlobalBuilder(), null));
            FlowGraphEmitter fgEmitter = new FlowGraphEmitter(cx.get(i), file.get(i).getPath(), false);
            fa.add(new FlowAnalyzer(fgEmitter));
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveInheritance(int start, int end) throws Throwable {
        for (int i = start; i < end; ++i) {
            Iterator<ReferenceValue> k = ScriptCompiler.node.get((int)i).fa_unresolved.iterator();
            while (k.hasNext()) {
                int size;
                ReferenceValue ref = k.next();
                boolean found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (int j = 0; j < size; ++j) {
                    Pair p;
                    QName qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    int where = ScriptCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !inheritance.contains(p = new Pair(i, where))) {
                        inheritance.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            ScriptCompiler.node.get((int)i).fa_unresolved.clear();
        }
    }

    private static void sortInheritance() throws Throwable {
        Iterator<Pair> i = inheritance.iterator();
        while (i.hasNext()) {
            Pair p = i.next();
            if (p.processed) continue;
            fa.get(p.i).inheritSlots(ScriptCompiler.node.get((int)p.where).frame, ScriptCompiler.node.get((int)p.i).frame, ScriptCompiler.node.get((int)p.i).frame.builder, cx.get(p.i));
            p.processed = true;
        }
        final DependencyGraph<Integer> g = new DependencyGraph<Integer>();
        int length = node.size();
        for (int i2 = 0; i2 < length; ++i2) {
            String path = file.get(i2).getPath();
            g.put(path, Boxing.valueOf(i2));
            if (!g.containsVertex(path)) {
                g.addVertex(new Vertex<String>(path));
            }
            Iterator<Pair> j = inheritance.iterator();
            while (j.hasNext()) {
                Pair p = j.next();
                if (p.i != i2) continue;
                g.addDependency(path, file.get(p.where).getPath());
            }
        }
        final ArrayList tsort = new ArrayList(node.size());
        Algorithms.topologicalSort(g, new Visitor<String>(){

            @Override
            public void visit(Vertex<String> v) {
                String name = v.getWeight();
                tsort.add(g.get(name));
            }
        });
        if (node.size() > tsort.size()) {
            int length2 = node.size();
            for (int i3 = 0; i3 < length2; ++i3) {
                int j;
                for (j = 0; j < tsort.size() && (Integer)tsort.get(j) != i3; ++j) {
                }
                if (j != tsort.size()) continue;
                String path = file.get(i3).getPath();
                System.out.println(path + " in circular reference");
            }
        } else {
            int j;
            int length3;
            ArrayList<File> tempFile = new ArrayList<File>(file.size());
            ArrayList<Context> tempCX = new ArrayList<Context>(cx.size());
            ArrayList<ActionBlockEmitter> tempEmitter = new ArrayList<ActionBlockEmitter>(emitter.size());
            ArrayList<ProgramNode> tempNode = new ArrayList<ProgramNode>(node.size());
            ArrayList<FlowAnalyzer> tempFA = new ArrayList<FlowAnalyzer>(fa.size());
            int length4 = tsort.size();
            for (int i4 = 0; i4 < length4; ++i4) {
                int loc = (Integer)tsort.get(i4);
                tempFile.add(file.get(loc));
                tempCX.add(cx.get(loc));
                tempEmitter.add(emitter.get(loc));
                tempNode.add(node.get(loc));
                tempFA.add(fa.get(loc));
            }
            file = tempFile;
            cx = tempCX;
            emitter = tempEmitter;
            node = tempNode;
            fa = tempFA;
            Iterator<Pair> i5 = type.iterator();
            block6: while (i5.hasNext()) {
                Pair p = i5.next();
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.i) continue;
                    p.i = j;
                    break;
                }
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.where) continue;
                    p.where = j;
                    continue block6;
                }
            }
            i5 = inheritance.iterator();
            block9: while (i5.hasNext()) {
                Pair p = i5.next();
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.i) continue;
                    p.i = j;
                    break;
                }
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.where) continue;
                    p.where = j;
                    continue block9;
                }
            }
        }
    }

    private static void fa_part2() {
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || ScriptCompiler.node.get((int)i).state != 2) continue;
            cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveType() throws Throwable {
        Pair p;
        int where;
        QName qname;
        int j;
        int size;
        boolean found;
        ReferenceValue ref;
        Iterator<ReferenceValue> k;
        int i;
        int length = node.size();
        for (i = 0; i < length; ++i) {
            k = ScriptCompiler.node.get((int)i).ce_unresolved.iterator();
            while (k.hasNext()) {
                ref = k.next();
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = ScriptCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            ScriptCompiler.node.get((int)i).ce_unresolved.clear();
        }
        length = node.size();
        for (i = 0; i < length; ++i) {
            k = ScriptCompiler.node.get((int)i).body_unresolved.iterator();
            while (k.hasNext()) {
                ref = k.next();
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = ScriptCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            ScriptCompiler.node.get((int)i).body_unresolved.clear();
        }
        length = node.size();
        for (i = 0; i < length; ++i) {
            k = ScriptCompiler.node.get((int)i).ns_unresolved.iterator();
            while (k.hasNext()) {
                ref = k.next();
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = ScriptCompiler.findDefinition(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            ScriptCompiler.node.get((int)i).ns_unresolved.clear();
        }
    }

    private static void importType() throws Throwable {
        Iterator<Pair> i = type.iterator();
        while (i.hasNext()) {
            Pair p = i.next();
            if (p.processed) continue;
            if (!inheritance.contains(p)) {
                fa.get(p.i).inheritSlots(ScriptCompiler.node.get((int)p.where).frame, ScriptCompiler.node.get((int)p.i).frame, ScriptCompiler.node.get((int)p.i).frame.builder, cx.get(p.i));
            }
            p.processed = true;
        }
    }

    private static void md() {
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || !file.get(i).getName().endsWith(".as") || emitter.get(i) == null) continue;
            cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
            MetaDataEvaluator analyzer = new MetaDataEvaluator();
            node.get(i).evaluate(cx.get(i), analyzer);
            cx.get(i).popScope();
        }
    }

    private static void ce() {
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0) continue;
            cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
            ConstantEvaluator analyzer = new ConstantEvaluator(cx.get(i));
            node.get(i).evaluate(cx.get(i), analyzer);
            cx.get(i).popScope();
        }
    }

    private static void cg() throws Throwable {
        int k;
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || !file.get(i).getName().endsWith(".as") || emitter.get(i) == null) continue;
            cx.get(i).setEmitter(emitter.get(i));
            cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
            CodeGenerator generator = new CodeGenerator(cx.get(i).getEmitter());
            generator.emitScriptNames = true;
            node.get(i).evaluate(cx.get(i), generator);
            cx.get(i).popScope();
        }
        if (builtinFlag) {
            mainEmitter.reorderMainScript();
        }
        ByteList bytes = new ByteList();
        mainEmitter.emit(bytes);
        if (outputFile == null) {
            outputFile = mainFile.getName().substring(0, mainFile.getName().length() - ".as".length());
        }
        FileOutputStream out = new FileOutputStream(new File(mainFile.getParentFile(), outputFile + ".abc"));
        Decoder decoder = new Decoder(new BytecodeBuffer(bytes.toByteArray()));
        Encoder encoder = new Encoder(46, 16);
        encoder.enablePeepHole();
        int passes = 2;
        encoder.addConstantPools(new ConstantPool[]{decoder.constantPool});
        encoder.configure(new Decoder[]{decoder});
        encoder.useConstantPool(0);
        int n = decoder.methodInfo.size();
        for (k = 0; k < n; ++k) {
            decoder.methodInfo.decode(k, encoder);
        }
        n = decoder.metadataInfo.size();
        for (k = 0; k < n; ++k) {
            decoder.metadataInfo.decode(k, encoder);
        }
        n = decoder.classInfo.size();
        for (k = 0; k < n; ++k) {
            decoder.classInfo.decodeInstance(k, encoder);
        }
        n = decoder.classInfo.size();
        for (k = 0; k < n; ++k) {
            decoder.classInfo.decodeClass(k, 0, encoder);
        }
        n = decoder.scriptInfo.size();
        for (k = 0; k < n; ++k) {
            decoder.scriptInfo.decode(k, encoder);
        }
        int bodySize = decoder.methodBodies.size();
        for (k = 0; k < bodySize; ++k) {
            decoder.methodBodies.decode(k, passes, encoder);
        }
        byte[] abc = encoder.toABC();
        System.err.println(outputFile + ": " + abc.length);
        out.write(abc);
        out.close();
        Compiler.printNative(mainContext, outputFile, mainEmitter, bytes);
    }

    private static void resolveExpression() throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            Iterator<ReferenceValue> k = ScriptCompiler.node.get((int)i).rt_unresolved.iterator();
            while (k.hasNext()) {
                int size;
                ReferenceValue ref = k.next();
                boolean found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (int j = 0; j < size; ++j) {
                    QName qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    if (qname.ns instanceof UnresolvedNamespace && ((UnresolvedNamespace)qname.ns).resolved) {
                        found = true;
                        break;
                    }
                    int where = ScriptCompiler.findDefinition(qname);
                    if (where == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            ScriptCompiler.node.get((int)i).rt_unresolved.clear();
        }
    }

    private static void clear() {
        s.clear();
        ObjectValue.clear();
        TypeValue.clear();
    }

    private static int findDefinition(QName defName) throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            Names names = ScriptCompiler.node.get((int)i).frame.builder.getNames();
            for (int j = 0; j < 4; ++j) {
                if (names == null || !names.containsKey(defName.name, defName.ns, j)) continue;
                return i;
            }
        }
        return ScriptCompiler.searchClasspath(defName);
    }

    private static int findClass(QName className) throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            int size;
            int n = size = ScriptCompiler.node.get((int)i).clsdefs != null ? ScriptCompiler.node.get((int)i).clsdefs.size() : 0;
            for (int j = 0; j < size; ++j) {
                ClassDefinitionNode clsdef = (ClassDefinitionNode)ScriptCompiler.node.get((int)i).clsdefs.get(j);
                if (!clsdef.cframe.builder.classname.equals(className)) continue;
                return i;
            }
        }
        return ScriptCompiler.searchClasspath(className);
    }

    private static int searchClasspath(QName qname) throws Throwable {
        String path = qname.ns.name.replace('.', File.separatorChar) + File.separatorChar + qname.name;
        File f = new File(path + ".as");
        if (f.exists() && f.isFile()) {
            f = f.getCanonicalFile();
            Context context = new Context(s);
            int where = file.indexOf(f);
            if (where == -1) {
                file.add(f);
                cx.add(context);
                emitter.add(new ActionBlockEmitter(context, f.getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, debugFlag));
                where = file.size() - 1;
            }
            return where;
        }
        return -1;
    }

    static class Pair {
        int i;
        int where;
        boolean processed;

        Pair(int i, int where) {
            this.i = i;
            this.where = where;
            this.processed = false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                return this.i == ((Pair)obj).i && this.where == ((Pair)obj).where;
            }
            return false;
        }

        public int hashCode() {
            return (17 + this.i) * 17 + this.where;
        }
    }
}

