/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class FunctionSignatureNode
extends Node {
    public ParameterListNode parameter;
    public Node result;
    public TypeValue type = null;
    public ReferenceValue typeref;
    public boolean no_anno;
    public boolean void_anno;

    public FunctionSignatureNode(ParameterListNode parameter, Node result) {
        this.parameter = parameter;
        this.result = result;
        this.typeref = null;
        this.no_anno = false;
        this.void_anno = false;
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    public int size() {
        return this.parameter != null ? this.parameter.size() : 0;
    }

    public String toString() {
        return "FunctionSignature";
    }

    public StringBuffer toCanonicalString(Context cx, StringBuffer buff) {
        if (this.parameter != null) {
            this.parameter.toCanonicalString(cx, buff);
        }
        buff.append(" result_type='");
        if (this.result != null) {
            this.result.toCanonicalString(cx, buff);
        } else if (this.void_anno) {
            buff.append("void");
        } else {
            buff.append(cx.noType().name.toString());
        }
        buff.append("'");
        return buff;
    }
}

