/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationConstants;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import flex.messaging.config.ConfigurationParser;
import flex.messaging.config.ServicesConfiguration;
import flex.messaging.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractConfigurationParser
implements ConfigurationParser,
ConfigurationConstants {
    protected ServicesConfiguration config;
    protected DocumentBuilder docBuilder;
    protected ConfigurationFileResolver fileResolver;
    private Map fileByDocument = new HashMap();

    protected AbstractConfigurationParser() {
        this.initializeDocumentBuilder();
    }

    public void parse(String path, ConfigurationFileResolver fileResolver, ServicesConfiguration config) {
        this.config = config;
        this.fileResolver = fileResolver;
        Document doc = this.loadDocument(path, fileResolver.getConfigurationFile(path));
        this.initializeExpressionQuery();
        this.parseTopLevelConfig(doc);
    }

    protected void initializeDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(10100);
            e.setRootCause(ex);
            throw e;
        }
    }

    protected Document loadDocument(String path, InputStream in) {
        try {
            Document doc;
            String encoding;
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            if ("UTF-8".equals(encoding = FileUtils.consumeBOM(in, null)) || "UTF-16".equals(encoding)) {
                InputSource inputSource = new InputSource(in);
                inputSource.setEncoding(encoding);
                doc = this.docBuilder.parse(inputSource);
            } else {
                doc = this.docBuilder.parse(in);
            }
            this.addFileByDocument(path, doc);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (SAXParseException ex) {
            Integer line = new Integer(ex.getLineNumber());
            Integer col = new Integer(ex.getColumnNumber());
            String message = ex.getMessage();
            ConfigurationException e = new ConfigurationException();
            e.setMessage(10102, new Object[]{line, col, message});
            e.setRootCause(ex);
            throw e;
        }
        catch (SAXException ex) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(ex.getMessage());
            e.setRootCause(ex);
            throw e;
        }
        catch (IOException ex) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(ex.getMessage());
            e.setRootCause(ex);
            throw e;
        }
    }

    protected void addFileByDocument(String path, Node node) {
        String shortPath = path;
        if (shortPath != null && (shortPath.indexOf("/") != -1 || shortPath.indexOf("\\") != -1)) {
            int start = 0;
            start = shortPath.lastIndexOf("/");
            if (start == -1) {
                start = shortPath.lastIndexOf("\\");
            }
            shortPath = path.substring(start + 1);
        }
        this.fileByDocument.put(node, shortPath);
    }

    protected String getSourceFileOf(Node node) {
        return (String)this.fileByDocument.get(node.getOwnerDocument());
    }

    protected abstract void parseTopLevelConfig(Document var1);

    protected abstract void initializeExpressionQuery();

    protected abstract Node selectSingleNode(Node var1, String var2);

    protected abstract NodeList selectNodeList(Node var1, String var2);

    protected abstract Object evaluateExpression(Node var1, String var2);

    public ConfigMap properties(NodeList properties) {
        int length = properties.getLength();
        ConfigMap map = new ConfigMap(length);
        for (int p = 0; p < length; ++p) {
            Node prop = properties.item(p);
            String propName = prop.getNodeName();
            if (propName == null) continue;
            propName = propName.trim();
            if (prop.getNodeType() == 1) {
                NodeList attributes = this.selectNodeList(prop, "@*");
                NodeList children = this.selectNodeList(prop, "*");
                if (children.getLength() > 0 || attributes.getLength() > 0) {
                    ConfigMap childMap = new ConfigMap();
                    if (children.getLength() > 0) {
                        childMap.addProperties(this.properties(children));
                    }
                    if (attributes.getLength() > 0) {
                        childMap.addProperties(this.properties(attributes));
                    }
                    map.addProperty(propName, childMap);
                    continue;
                }
                String propValue = this.evaluateExpression(prop, ".").toString();
                map.addProperty(propName, propValue);
                continue;
            }
            map.addProperty(propName, prop.getNodeValue());
        }
        return map;
    }

    public String getAttributeOrChildElement(Node node, String name) {
        String attr = this.evaluateExpression(node, "@" + name).toString().trim();
        if (attr.length() == 0) {
            attr = this.evaluateExpression(node, name).toString().trim();
        }
        return attr;
    }

    public void allowedChildElements(Node node, String[] allowed) {
        NodeList children = this.selectNodeList(node, "*");
        String unexpected = AbstractConfigurationParser.unexpected(children, allowed);
        if (unexpected != null) {
            ConfigurationException ex = new ConfigurationException();
            Object[] args = new Object[]{unexpected, node.getNodeName(), this.getSourceFilename(node)};
            ex.setMessage(10106, args);
            throw ex;
        }
        NodeList textNodes = this.selectNodeList(node, "text()");
        for (int i = 0; i < textNodes.getLength(); ++i) {
            String text = this.evaluateExpression(textNodes.item(i), ".").toString().trim();
            if (text.length() <= 0) continue;
            ConfigurationException ex = new ConfigurationException();
            Object[] args = new Object[]{text, node.getNodeName(), this.getSourceFilename(node)};
            ex.setMessage(11104, args);
            throw ex;
        }
    }

    public void allowedAttributes(Node node, String[] allowed) {
        NodeList attributes = this.selectNodeList(node, "@*");
        String unexpectedAttribute = AbstractConfigurationParser.unexpected(attributes, allowed);
        if (unexpectedAttribute != null) {
            ConfigurationException ex = new ConfigurationException();
            Object[] args = new Object[]{unexpectedAttribute, node.getNodeName(), this.getSourceFilename(node)};
            ex.setMessage(10107, args);
            throw ex;
        }
    }

    private String getSourceFilename(Node node) {
        return this.getSourceFileOf(node);
    }

    public void allowedAttributesOrElements(Node node, String[] allowed) {
        this.allowedAttributes(node, allowed);
        this.allowedChildElements(node, allowed);
    }

    public void requiredAttributesOrElements(Node node, String[] required) {
        String nodeName = node.getNodeName();
        NodeList attributes = this.selectNodeList(node, "@*");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < required.length; ++i) {
            list.add(required[i]);
        }
        String missingAttribute = null;
        do {
            if ((missingAttribute = AbstractConfigurationParser.required(attributes, list)) == null) continue;
            Node child = this.selectSingleNode(node, missingAttribute);
            if (child != null) {
                list.remove(missingAttribute);
                continue;
            }
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10105, new Object[]{missingAttribute, nodeName});
            throw ex;
        } while (missingAttribute != null && list.size() > 0);
    }

    public void requiredChildElements(Node node, String[] required) {
        String nodeName = node.getNodeName();
        NodeList children = this.selectNodeList(node, "*");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < required.length; ++i) {
            list.add(required[i]);
        }
        String missing = AbstractConfigurationParser.required(children, list);
        if (missing != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10104, new Object[]{missing, nodeName});
            throw ex;
        }
    }

    public static String unexpected(NodeList attributes, String[] allowed) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attrib = attributes.item(i);
            String attribName = attrib.getNodeName();
            boolean match = false;
            for (int j = 0; j < allowed.length; ++j) {
                String a = allowed[j];
                if (!a.equals(attribName)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return attribName;
        }
        return null;
    }

    public static String required(NodeList attributes, List required) {
        for (int i = 0; i < required.size(); ++i) {
            boolean found = false;
            String req = (String)required.get(i);
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attrib = attributes.item(j);
                String attribName = attrib.getNodeName();
                if (!req.equals(attribName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return req;
        }
        return null;
    }

    public static boolean isValidID(String id) {
        if (id != null && id.length() > 0 && id.length() < 256) {
            char[] chars = id.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (",;:".indexOf(c) == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

