/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.LocalizedException;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClientConfiguration;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationParser;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.LocalFileResolver;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.ServicesConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServicesDependencies {
    private String xmlInit = "";
    private StringBuffer imports = new StringBuffer();
    private StringBuffer references = new StringBuffer();
    private List channelClasses;
    private Map configPaths;
    private Map lazyAssociations;
    private static final List channel_excludes = new ArrayList();
    public static final boolean traceConfig;

    public ServicesDependencies(String path, String parserClass, String contextRoot) {
        ClientConfiguration config = ServicesDependencies.getClientConfiguration(path, parserClass);
        if (config != null) {
            HashMap importMap = new HashMap();
            this.lazyAssociations = new HashMap();
            this.configPaths = config.getConfigPaths();
            this.xmlInit = this.codegenXmlInit(config, contextRoot, importMap);
            ServicesDependencies.codegenServiceImportsAndReferences(importMap, this.imports, this.references);
            this.channelClasses = ServicesDependencies.listChannelClasses(config);
        }
    }

    public Set getLazyAssociations(String destination) {
        if (this.lazyAssociations == null) {
            this.lazyAssociations = new HashMap();
        }
        return (Set)this.lazyAssociations.get(destination);
    }

    public void addLazyAssociation(String destination, String associationProp) {
        HashSet<String> la = this.getLazyAssociations(destination);
        if (la == null) {
            la = new HashSet<String>();
            this.lazyAssociations.put(destination, la);
        }
        la.add(associationProp);
    }

    public String getServerConfigXmlInit() {
        return this.xmlInit;
    }

    public String getImports() {
        return this.imports.toString();
    }

    public String getReferences() {
        return this.references.toString();
    }

    public List getChannelClasses() {
        return this.channelClasses;
    }

    public void addChannelClass(String className) {
        this.channelClasses.add(className);
    }

    public void addConfigPath(String path, long modified) {
        this.configPaths.put(path, new Long(modified));
    }

    public Map getConfigPaths() {
        return this.configPaths;
    }

    public static ClientConfiguration getClientConfiguration(String path, String parserClass) {
        ClientConfiguration config = new ClientConfiguration();
        ConfigurationParser parser = ServicesDependencies.getConfigurationParser(parserClass);
        if (parser == null) {
            LocalizedException lme = new LocalizedException();
            lme.setMessage(10138);
            throw lme;
        }
        LocalFileResolver local = new LocalFileResolver();
        parser.parse(path, local, config);
        config.addConfigPath(path, new File(path).lastModified());
        return config;
    }

    static ConfigurationParser getConfigurationParser(String className) {
        ConfigurationParser parser;
        block12: {
            Class<?> parserClass;
            block11: {
                block10: {
                    parser = null;
                    parserClass = null;
                    if (className != null) {
                        try {
                            parserClass = Class.forName(className);
                            parser = (ConfigurationParser)parserClass.newInstance();
                        }
                        catch (Throwable t) {
                            if (!traceConfig) break block10;
                            System.out.println("Could not load services configuration parser as: " + className);
                        }
                    }
                }
                if (parser == null) {
                    try {
                        className = "flex.messaging.config.XPathClientConfigurationParser";
                        parserClass = Class.forName(className);
                        Class.forName("javax.xml.xpath.XPathExpressionException");
                        parser = (ConfigurationParser)parserClass.newInstance();
                    }
                    catch (Throwable t) {
                        if (!traceConfig) break block11;
                        System.out.println("Could not load configuration parser as: " + className);
                    }
                }
            }
            if (parser == null) {
                try {
                    className = "flex.messaging.config.ApacheXPathClientConfigurationParser";
                    parserClass = Class.forName(className);
                    parser = (ConfigurationParser)parserClass.newInstance();
                }
                catch (Throwable t) {
                    if (!traceConfig) break block12;
                    System.out.println("Could not load configuration parser as: " + className);
                }
            }
        }
        if (traceConfig && parser != null) {
            System.out.println("Services Configuration Parser: " + parser.getClass().getName());
        }
        return parser;
    }

    private static List listChannelClasses(ServicesConfiguration config) {
        ArrayList<String> channelList = new ArrayList<String>();
        Iterator it = config.getAllChannelSettings().values().iterator();
        while (it.hasNext()) {
            ChannelSettings settings = (ChannelSettings)it.next();
            String clientType = settings.getClientType();
            channelList.add(clientType);
        }
        return channelList;
    }

    private String codegenXmlInit(ServicesConfiguration config, String contextRoot, Map serviceImportMap) {
        ClusterSettings defaultCluster;
        StringBuffer e4x = new StringBuffer();
        e4x.append("<services>\n");
        if (config.getDefaultChannels().size() > 0) {
            e4x.append("\t<default-channels>\n");
            Iterator chanIter = config.getDefaultChannels().iterator();
            while (chanIter.hasNext()) {
                String id = (String)chanIter.next();
                e4x.append("\t\t<channel ref=\"" + id + "\"/>\n");
            }
            e4x.append("\t</default-channels>\n");
        }
        if ((defaultCluster = config.getDefaultCluster()) != null && !defaultCluster.getURLLoadBalancing()) {
            defaultCluster = null;
        }
        Iterator servIter = config.getAllServiceSettings().iterator();
        while (servIter.hasNext()) {
            ServiceSettings entry = (ServiceSettings)servIter.next();
            String serviceType = entry.getId();
            e4x.append("\t<service id=\"");
            e4x.append(serviceType);
            e4x.append("\"");
            e4x.append(">\n");
            Iterator destIter = entry.getDestinationSettings().values().iterator();
            while (destIter.hasNext()) {
                String autoSyncEnabled;
                String useTransactions;
                DestinationSettings dest = (DestinationSettings)destIter.next();
                String destination = dest.getId();
                e4x.append("\t\t<destination id=\"" + destination + "\">\n");
                ConfigMap metadata = dest.getProperties().getPropertyAsMap("metadata", null);
                boolean closePropTag = false;
                if (metadata != null) {
                    e4x.append("\t\t\t<properties>\n\t\t\t\t<metadata>\n");
                    closePropTag = true;
                    List identities = metadata.getPropertyAsList("identity", null);
                    if (identities != null) {
                        Iterator it = identities.iterator();
                        while (it.hasNext()) {
                            Object o = it.next();
                            String identityName = null;
                            String undefinedValue = null;
                            if (o instanceof String) {
                                identityName = (String)o;
                            } else if (o instanceof ConfigMap) {
                                identityName = ((ConfigMap)o).getPropertyAsString("property", null);
                                undefinedValue = ((ConfigMap)o).getPropertyAsString("undefined-value", null);
                            }
                            if (identityName == null) continue;
                            e4x.append("\t\t\t\t\t<identity property=\"");
                            e4x.append(identityName);
                            e4x.append("\"");
                            if (undefinedValue != null) {
                                e4x.append(" undefined-value=\"");
                                e4x.append(undefinedValue);
                                e4x.append("\"");
                            }
                            e4x.append("/>\n");
                        }
                    }
                    this.codegenServiceAssociations(metadata, e4x, destination, "one-to-many");
                    this.codegenServiceAssociations(metadata, e4x, destination, "many-to-many");
                    this.codegenServiceAssociations(metadata, e4x, destination, "one-to-one");
                    this.codegenServiceAssociations(metadata, e4x, destination, "many-to-one");
                    e4x.append("\t\t\t\t</metadata>\n");
                }
                ConfigMap network = dest.getProperties().getPropertyAsMap("network", null);
                ConfigMap clusterInfo = null;
                ConfigMap pagingInfo = null;
                ConfigMap reconnectInfo = null;
                if (network != null || defaultCluster != null) {
                    if (metadata == null) {
                        e4x.append("\t\t\t<properties>\n");
                        closePropTag = true;
                    }
                    e4x.append("\t\t\t\t<network>\n");
                    if (network != null) {
                        pagingInfo = network.getPropertyAsMap("paging", null);
                    }
                    if (pagingInfo != null) {
                        String enabled = pagingInfo.getPropertyAsString("enabled", "false");
                        e4x.append("\t\t\t\t\t<paging enabled=\"");
                        e4x.append(enabled);
                        e4x.append("\"");
                        String size = pagingInfo.getPropertyAsString("pageSize", null);
                        if (size != null) {
                            e4x.append(" pageSize=\"");
                            e4x.append(size);
                            e4x.append("\"");
                        }
                        e4x.append("/>\n");
                    }
                    if (network != null) {
                        reconnectInfo = network.getPropertyAsMap("reconnect", null);
                    }
                    if (reconnectInfo != null) {
                        String fetchOption = reconnectInfo.getPropertyAsString("fetch", "IDENTITY");
                        e4x.append("\t\t\t\t\t<reconnect fetch=\"");
                        e4x.append(fetchOption.toUpperCase());
                        e4x.append("\" />\n");
                    }
                    if (network != null) {
                        clusterInfo = network.getPropertyAsMap("cluster", null);
                    }
                    if (clusterInfo != null) {
                        String clusterId = clusterInfo.getPropertyAsString("ref", null);
                        ClusterSettings clusterSettings = config.getClusterSettings(clusterId);
                        if (clusterSettings != null && clusterSettings.getURLLoadBalancing()) {
                            e4x.append("\t\t\t\t\t<cluster ref=\"");
                            e4x.append(clusterId);
                            e4x.append("\"/>\n");
                        }
                    } else if (defaultCluster != null) {
                        e4x.append("\t\t\t\t\t<cluster");
                        if (defaultCluster.getClusterName() != null) {
                            e4x.append(" ref=\"");
                            e4x.append(defaultCluster.getClusterName());
                            e4x.append("\"");
                        }
                        e4x.append("/>\n");
                    }
                    e4x.append("\t\t\t\t</network>\n");
                }
                if ((useTransactions = dest.getProperties().getPropertyAsString("use-transactions", "true")).equalsIgnoreCase("false")) {
                    if (!closePropTag) {
                        e4x.append("\t\t\t<properties>\n");
                        closePropTag = true;
                    }
                    e4x.append("\t\t\t\t<use-transactions>false</use-transactions>\n");
                }
                if ((autoSyncEnabled = dest.getProperties().getPropertyAsString("auto-sync-enabled", "true")).equalsIgnoreCase("false")) {
                    if (!closePropTag) {
                        e4x.append("\t\t\t<properties>\n");
                        closePropTag = true;
                    }
                    e4x.append("\t\t\t\t<auto-sync-enabled>false</auto-sync-enabled>\n");
                }
                if (closePropTag) {
                    e4x.append("\t\t\t</properties>\n");
                }
                e4x.append("\t\t\t<channels>\n");
                Iterator chanIter = dest.getChannelSettings().iterator();
                while (chanIter.hasNext()) {
                    e4x.append("\t\t\t\t<channel ref=\"" + ((ChannelSettings)chanIter.next()).getId() + "\"/>\n");
                }
                e4x.append("\t\t\t</channels>\n");
                e4x.append("\t\t</destination>\n");
            }
            e4x.append("\t</service>\n");
        }
        e4x.append("\t<channels>\n");
        Iterator chanIter = config.getAllChannelSettings().values().iterator();
        while (chanIter.hasNext()) {
            ChannelSettings chan = (ChannelSettings)chanIter.next();
            String channelType = chan.getClientType();
            serviceImportMap.put(channelType, channelType);
            e4x.append("\t\t<channel id=\"" + chan.getId() + "\" type=\"" + channelType + "\">\n");
            e4x.append("\t\t\t<endpoint uri=\"" + chan.getClientParsedUri(contextRoot) + "\"/>\n");
            e4x.append("\t\t\t<properties>\n");
            Iterator nameIter = chan.getProperties().propertyNames().iterator();
            while (nameIter.hasNext()) {
                String name = (String)nameIter.next();
                if (channel_excludes.contains(name)) continue;
                e4x.append("\t\t\t\t<" + name + ">" + chan.getProperty(name) + "</" + name + ">\n");
            }
            e4x.append("\t\t\t</properties>\n");
            e4x.append("\t\t</channel>\n");
        }
        e4x.append("\t</channels>\n");
        e4x.append("</services>");
        return "\nServerConfig.xml =\n" + e4x.toString() + ";\n";
    }

    public void codegenServiceAssociations(ConfigMap metadata, StringBuffer e4x, String destination, String relation) {
        List references = metadata.getPropertyAsList(relation, null);
        if (references != null) {
            Iterator it = references.iterator();
            while (it.hasNext()) {
                Object ref = it.next();
                if (!(ref instanceof ConfigMap)) continue;
                ConfigMap refMap = (ConfigMap)ref;
                String name = refMap.getPropertyAsString("property", null);
                String associatedDestination = refMap.getPropertyAsString("destination", null);
                String lazy = refMap.getPropertyAsString("lazy", null);
                e4x.append("\t\t\t\t\t<");
                e4x.append(relation);
                if (lazy != null) {
                    e4x.append(" lazy=\"");
                    e4x.append(lazy);
                    e4x.append("\"");
                    if (Boolean.valueOf(lazy.toLowerCase().trim()).booleanValue()) {
                        this.addLazyAssociation(destination, name);
                    }
                }
                e4x.append(" property=\"");
                e4x.append(name);
                e4x.append("\" destination=\"");
                e4x.append(associatedDestination);
                e4x.append("\"");
                String readOnly = refMap.getPropertyAsString("read-only", null);
                if (readOnly != null && readOnly.equalsIgnoreCase("true")) {
                    e4x.append(" read-only=\"true\"");
                }
                e4x.append("/>\n");
            }
        }
    }

    public static void codegenServiceImportsAndReferences(Map map, StringBuffer imports, StringBuffer references) {
        imports.append("import mx.messaging.config.ServerConfig;\n");
        references.append("   // static references for configured channels\n");
        Iterator chanIter = map.values().iterator();
        while (chanIter.hasNext()) {
            String type = (String)chanIter.next();
            imports.append("import ");
            imports.append(type);
            imports.append(";\n");
            references.append("   private static var ");
            references.append(type.replace('.', '_'));
            references.append("_ref:");
            references.append(type.substring(type.lastIndexOf(".") + 1) + ";\n");
        }
    }

    static {
        channel_excludes.add("redirect-url");
        traceConfig = System.getProperty("trace.config") != null;
    }
}

