/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.log;

import flex.messaging.LocalizedException;
import flex.messaging.config.ConfigMap;
import flex.messaging.log.Logger;
import flex.messaging.log.Target;
import flex.messaging.util.PrettyPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Log {
    public static final String INVALID_CHARS = "[]~$^&\\/(){}<>+=`!#%?,:;'\"@";
    private static final int INVALID_TARGET = 10013;
    private static final int INVALID_CATEGORY = 10014;
    private static final int INVALID_CATEGORY_CHARS = 10015;
    private static Log log;
    private static PrettyPrinter prettyPrinter;
    private static String prettyPrinterClass;
    private volatile short targetLevel = (short)2000;
    private final Map loggers = new HashMap();
    private final List targets = new ArrayList();
    private static final Object staticLock;

    private Log() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log createLog() {
        if (log == null) {
            Object object = staticLock;
            synchronized (object) {
                if (log == null) {
                    log = new Log();
                }
            }
        }
        return log;
    }

    public static synchronized void initialize(String id, ConfigMap properties) {
        String value = properties.getPropertyAsString("pretty-printer", null);
        if (value != null) {
            prettyPrinterClass = value;
        }
    }

    public static boolean isFatal() {
        return log == null ? false : Log.log.targetLevel <= 1000;
    }

    public static boolean isError() {
        return log == null ? false : Log.log.targetLevel <= 8;
    }

    public static boolean isWarn() {
        return log == null ? false : Log.log.targetLevel <= 6;
    }

    public static boolean isInfo() {
        return log == null ? false : Log.log.targetLevel <= 4;
    }

    public static boolean isDebug() {
        return log == null ? false : Log.log.targetLevel <= 2;
    }

    public static Logger getLogger(String category) {
        if (log != null) {
            return Log.getLogger(log, category);
        }
        return new Logger(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(Log log, String category) {
        Log.checkCategory(category);
        Object object = staticLock;
        synchronized (object) {
            Logger result = (Logger)log.loggers.get(category);
            if (result == null) {
                result = new Logger(category);
                Iterator iter = log.targets.iterator();
                while (iter.hasNext()) {
                    Target target = (Target)iter.next();
                    if (!Log.categoryMatchInFilterList(category, target.getFilters())) continue;
                    target.addLogger(result);
                }
                log.loggers.put(category, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTargets() {
        if (log != null) {
            List currentTargets;
            Object object = staticLock;
            synchronized (object) {
                currentTargets = Collections.unmodifiableList(new ArrayList(Log.log.targets));
            }
            return currentTargets;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTarget(Target target) {
        if (log != null) {
            if (target != null) {
                Object object = staticLock;
                synchronized (object) {
                    List filters = target.getFilters();
                    Iterator it = Log.log.loggers.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        if (!Log.categoryMatchInFilterList(key, filters)) continue;
                        target.addLogger((Logger)Log.log.loggers.get(key));
                    }
                    if (!Log.log.targets.contains(target)) {
                        Log.log.targets.add(target);
                    }
                    short targetLevel = target.getLevel();
                    if (Log.log.targetLevel == 2000) {
                        Log.log.targetLevel = targetLevel;
                    } else if (targetLevel < Log.log.targetLevel) {
                        Log.log.targetLevel = targetLevel;
                    }
                }
            } else {
                LocalizedException ex = new LocalizedException();
                ex.setMessage(10013);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTarget(Target target) {
        if (log != null) {
            if (target != null) {
                Object object = staticLock;
                synchronized (object) {
                    List filters = target.getFilters();
                    Iterator it = Log.log.loggers.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        if (!Log.categoryMatchInFilterList(key, filters)) continue;
                        target.removeLogger((Logger)Log.log.loggers.get(key));
                    }
                    Log.log.targets.remove(target);
                    Log.resetTargetLevel();
                }
            } else {
                LocalizedException ex = new LocalizedException();
                ex.setMessage(10013);
                throw ex;
            }
        }
    }

    public static synchronized void reset() {
        Log.flush();
    }

    public static void flush() {
        if (log != null) {
            Log.log.loggers.clear();
            Log.log.targets.clear();
            Log.log.targetLevel = (short)2000;
        }
    }

    public static short readLevel(String l) {
        int lvl = 8;
        if (l != null && l.length() > 0) {
            l = l.trim().toLowerCase();
            char c = l.charAt(0);
            switch (c) {
                case 'n': {
                    lvl = 2000;
                    break;
                }
                case 'e': {
                    lvl = 8;
                    break;
                }
                case 'w': {
                    lvl = 6;
                    break;
                }
                case 'i': {
                    lvl = 4;
                    break;
                }
                case 'd': {
                    lvl = 2;
                    break;
                }
                case 'a': {
                    lvl = 0;
                    break;
                }
                default: {
                    lvl = 8;
                }
            }
        }
        return (short)lvl;
    }

    public static boolean hasIllegalCharacters(String value) {
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (INVALID_CHARS.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    public static PrettyPrinter getPrettyPrinter() {
        if (prettyPrinter == null || !prettyPrinter.getClass().getName().equals(prettyPrinterClass)) {
            try {
                Class<?> c = Class.forName(prettyPrinterClass);
                prettyPrinter = (PrettyPrinter)c.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (PrettyPrinter)prettyPrinter.clone();
    }

    public static void setPrettyPrinterClass(String value) {
        prettyPrinterClass = value;
    }

    static short getTargetLevel() {
        return log == null ? (short)2000 : (short)Log.log.targetLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetTargetLevel() {
        if (log != null) {
            Object object = staticLock;
            synchronized (object) {
                short maxTargetLevel = 2000;
                Iterator iter = Log.log.targets.iterator();
                while (iter.hasNext()) {
                    short targetLevel = ((Target)iter.next()).getLevel();
                    if (maxTargetLevel != 2000 && targetLevel >= maxTargetLevel) continue;
                    maxTargetLevel = targetLevel;
                }
                Log.log.targetLevel = maxTargetLevel;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processTargetFilterAdd(Target target, String filter) {
        if (log != null) {
            Object object = staticLock;
            synchronized (object) {
                ArrayList<String> filters = new ArrayList<String>();
                filters.add(filter);
                Iterator it = Log.log.loggers.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!Log.categoryMatchInFilterList(key, filters)) continue;
                    target.addLogger((Logger)Log.log.loggers.get(key));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processTargetFilterRemove(Target target, String filter) {
        if (log != null) {
            Object object = staticLock;
            synchronized (object) {
                ArrayList<String> filters = new ArrayList<String>();
                filters.add(filter);
                Iterator it = Log.log.loggers.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!Log.categoryMatchInFilterList(key, filters)) continue;
                    target.removeLogger((Logger)Log.log.loggers.get(key));
                }
            }
        }
    }

    private static boolean categoryMatchInFilterList(String category, List filters) {
        if (filters == null) {
            return false;
        }
        int index = -1;
        for (int i = 0; i < filters.size(); ++i) {
            String filter = (String)filters.get(i);
            index = filter.indexOf("*");
            if (index == 0) {
                return true;
            }
            if (!(index < 0 ? category.equals(filter) : category.length() >= index && category.substring(0, index).equals(filter.substring(0, index)))) continue;
            return true;
        }
        return false;
    }

    private static void checkCategory(String category) {
        if (category == null || category.length() == 0) {
            LocalizedException ex = new LocalizedException();
            ex.setMessage(10014);
            throw ex;
        }
        if (Log.hasIllegalCharacters(category) || category.indexOf("*") != -1) {
            LocalizedException ex = new LocalizedException();
            ex.setMessage(10015, new Object[]{INVALID_CHARS});
            throw ex;
        }
    }

    static {
        prettyPrinterClass = "BasicPrettyPrinter";
        staticLock = new Object();
    }
}

