/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.security.SecureRandom;
import java.util.Random;

public class UUIDUtils {
    private static SecureRandom _rand = new SecureRandom();
    private static Random _weakRand = new Random();
    private static final int MAX_IDS_PER_MILLI = 10000;
    private static long lastUsedTOD = 0L;
    private static int numIdsThisMilli = 0;
    private static final String alphaNum = "0123456789ABCDEF";
    private static final int BITS_PER_DIGIT = 4;
    private static final int BITS_PER_INT = 32;
    private static final int BITS_PER_LONG = 64;
    private static final int DIGITS_PER_INT = 8;
    private static final int DIGITS_PER_LONG = 16;
    private static String hostid = null;

    private static native long getHostID();

    private UUIDUtils() {
    }

    public static String createUUID(boolean useBackwardCompatibleFormat) {
        return UUIDUtils.createUUID(useBackwardCompatibleFormat, true);
    }

    public static String createUUID(boolean useBackwardCompatibleFormat, boolean secure) {
        Random rand = secure ? _rand : _weakRand;
        StringBuffer s = new StringBuffer(36);
        UUIDUtils.appendHexString(UUIDUtils.uniqueTOD(), false, 11, s);
        if (hostid != null) {
            s.append(hostid);
        } else {
            s.append(alphaNum.charAt(rand.nextInt(16) | 8));
        }
        UUIDUtils.appendRandomHexChars(32 - s.length(), rand, s);
        s.insert(8, "-");
        s.insert(13, "-");
        s.insert(18, "-");
        if (!useBackwardCompatibleFormat) {
            s.insert(23, "-");
        }
        return s.toString();
    }

    private static void appendRandomHexChars(int n, Random rand, StringBuffer result) {
        int digitsPerInt = 8;
        while (n > 0) {
            int digitsToUse = Math.min(n, digitsPerInt);
            n -= digitsToUse;
            UUIDUtils.appendHexString(rand.nextInt(), true, digitsToUse, result);
        }
    }

    private static void appendHexString(long value, boolean prependZeroes, int nLeastSignificantDigits, StringBuffer result) {
        int bitsPerDigit = 4;
        long mask = (1L << bitsPerDigit) - 1L;
        if (nLeastSignificantDigits < 16) {
            value &= (1L << bitsPerDigit * nLeastSignificantDigits) - 1L;
        }
        int i = 0;
        long reorderedValue = 0L;
        if (value == 0L) {
            ++i;
        } else {
            do {
                reorderedValue = reorderedValue << bitsPerDigit | value & mask;
                ++i;
            } while ((value >>>= bitsPerDigit) != 0L);
        }
        if (prependZeroes) {
            for (int j = nLeastSignificantDigits - i; j > 0; --j) {
                result.append('0');
            }
        }
        while (i > 0) {
            result.append(alphaNum.charAt((int)(reorderedValue & mask)));
            reorderedValue >>>= bitsPerDigit;
            --i;
        }
    }

    private static synchronized long uniqueTOD() {
        long currentTOD = System.currentTimeMillis();
        if (currentTOD < lastUsedTOD) {
            lastUsedTOD = currentTOD;
        }
        if (currentTOD == lastUsedTOD) {
            if (++numIdsThisMilli >= 10000) {
                while (currentTOD == lastUsedTOD) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    currentTOD = System.currentTimeMillis();
                }
                lastUsedTOD = currentTOD;
                numIdsThisMilli = 0;
            }
        } else {
            lastUsedTOD = currentTOD;
            numIdsThisMilli = 0;
        }
        return lastUsedTOD * 10000L + (long)numIdsThisMilli;
    }

    static {
        try {
            System.loadLibrary("NeoUUID");
            long lHostid = UUIDUtils.getHostID();
            if (lHostid > 0L) {
                String rawHostid = Long.toHexString(lHostid).toUpperCase();
                hostid = rawHostid.length() > 12 ? rawHostid.substring(rawHostid.length() - 12) : rawHostid;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

