////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

package mx.automation.delegates.controls 
{
import flash.display.DisplayObject;

import mx.automation.Automation;
import mx.automation.IAutomationObject;
import mx.automation.delegates.core.UIComponentAutomationImpl;
import mx.controls.ProgressBar;
import mx.core.mx_internal;

use namespace mx_internal;

[Mixin]
/**
 * 
 *  Defines methods and properties required to perform instrumentation for the 
 *  ProgressBar control.
 * 
 *  @see mx.controls.ProgressBar 
 *
 */
public class ProgressBarAutomationImpl extends UIComponentAutomationImpl 
{
    include "../../../core/Version.as";
    
    //--------------------------------------------------------------------------
    //
    //  Class methods
    //
    //--------------------------------------------------------------------------

    /**
     *  Registers the delegate class for a component class with automation manager.
     */
    public static function init(root:DisplayObject):void
    {
        Automation.registerDelegateClass(ProgressBar, ProgressBarAutomationImpl);
    }   
    
    //--------------------------------------------------------------------------
    //
    //  Constructor
    //
    //--------------------------------------------------------------------------

    /**
     *  Constructor.
     * @param obj ProgressBar object to be automated.     
     */
    public function ProgressBarAutomationImpl(obj:ProgressBar)
    {
        super(obj);
        recordClick = true;
    }

    /**
     *  @private
     *  storage for the owner component
     */
    protected function get  progressBar():ProgressBar
    {
        return uiComponent as ProgressBar;
    }

    //----------------------------------
    //  automationName
    //----------------------------------

    /**
     *  @private
     */
    override public function get automationName():String
    {
        return progressBar.label || progressBar.toolTip || super.automationName;
    }

    /**
     *  @private
     */
    override public function get automationValue():Array
    {
        return [ progressBar.label || progressBar.toolTip ];
    }
        
}

}