////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

package mx.containers
{
	
/**
 *  The BoxDirection class specifies constant values
 *  for the <code>direction</code> property of the Box container.
 *
 *  @see mx.containers.Box
 */
public final class BoxDirection
{
	include "../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Class constants
	//
	//--------------------------------------------------------------------------

	/**
	 *  Specifies that children of the Box container are laid out horizontally.
	 */
	public static const HORIZONTAL:String = "horizontal";
	
	/**
	 *  Specifies that children of the Box container are laid out vertically.
	 */
	public static const VERTICAL:String = "vertical";
}

}
