////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

package mx.containers
{
    
/**
 *  The FormItemDirection class defines the constant values
 *  for the <code>direction</code> property of the FormItem class.
 *
 *  @see mx.containers.FormItem
 */
public final class FormItemDirection
{
    include "../core/Version.as";

    //--------------------------------------------------------------------------
    //
    //  Class constants
    //
    //--------------------------------------------------------------------------

    /**
     *  Specifies that the children of the FormItem container
     *  are laid out horizontally.
     */
    public static const HORIZONTAL:String = "horizontal";
    
    /**
     *  Specifies that the children of the FormItem container
     *  are laid out vertically.
     */
    public static const VERTICAL:String = "vertical";
}

}
