////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

package mx.controls
{
	
/**
 *  The ProgressBarLabelPlacement class defines the values for 
 *  the <code>labelPlacement</code> property of the ProgressBar class.
 *
 *  @see mx.controls.ProgressBar
 */
public final class ProgressBarLabelPlacement
{
	include "../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Class constants
	//
	//--------------------------------------------------------------------------

	/**
	 *  Specifies to place the label below the progress bar.
	 */
	public static const BOTTOM:String = "bottom";
	
	/**
	 *  Specifies to place at the center inside the progress bar.
	 */
	public static const CENTER:String = "center";
	
	/**
	 *  Specifies to place the label to the left of the progress bar.
	 */
	public static const LEFT:String = "left";
	
	/**
	 *  Specifies to place the label to the right of the progress bar.
	 */
	public static const RIGHT:String = "right";
	
	/**
	 *  Specifies to place the label above the progress bar.
	 */
	public static const TOP:String = "top";
}

}
