////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

package mx.controls.scrollClasses
{
	
/**
 *  The ScrollBarDirection class defines the values for the 
 *  <code>direction</code> property of the ScrollBar control.
 *
 *  @see mx.controls.scrollClasses.ScrollBar
 *  @see mx.controls.HScrollBar
 *  @see mx.controls.VScrollBar
 */
public final class ScrollBarDirection
{
	include "../../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Class constants
	//
	//--------------------------------------------------------------------------

	/**
	 *  Specifies that a ScrollBar control is for horizontal scrolling.
	 */
	public static const HORIZONTAL:String = "horizontal";
	
	/**
	 *  Specifies that a ScrollBar control is for vertical scrolling.
	 */
	public static const VERTICAL:String = "vertical";
}

}
