////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

package mx.core
{

/**
 *  MovieClipAsset is a subclass of the Flash Player's MovieClip class
 *  which represents movieclip symbols that you embed in a Flex application
 *  from a SWF file produced by Flash.
 *  It implements the IFlexDisplayObject interface, which makes it
 *  possible for the MovieClip to be displayed in an Image control,
 *  or to be used as a container background or a component skin.
 *
 *  <p>The MovieClip that you're embedding must be a movieclip symbol
 *  that is in a SWF file.
 *  A common reason for using an embedded movieclip is that you have created
 *  a frame-based animation in Flash and want to use it in a Flex application.
 *  The MXML compiler autogenerates a class that extends MovieClipAsset
 *  to represent the embedded animation.</p>
 *
 *  <p>You don't generally have to use the MovieClipAsset class directly
 *  when you write a Flex application.
 *  For example, you can use a movieclip animation as an application's
 *  background image by writing the following:</p>
 *
 *  <pre>
 *  &lt;mx:Application backgroundImage="&#64;Embed(source='Assets.swf', symbol='BackgroundAnimation')"/&gt;</pre>
 *
 *  <p>or</p>
 *
 *  <pre>
 *  &lt;mx:Style&gt;
 *      Application
 *      {
 *          backgroundImage: Embed(source="Assets.swf", symbol="BackgroundAnimation")
 *      }
 *  &lt;mx:Style/&gt;</pre>
 *
 *  <p>without having to understand that the MXML compiler has created
 *  a subclass of MovieClipAsset for you.</p>
 *
 *  <p>However, it may be useful to understand what is happening
 *  at the ActionScript level.
 *  To embed a movieclip in ActionScript, you declare a variable
 *  of type Class, and put <code>[Embed]</code> metadata on it.
 *  For example:</p>
 *
 *  <pre>
 *  [Bindable]
 *  [Embed(source="Assets.swf", symbol="BackgroundAnimation")]
 *  private var backgroundAnimationClass:Class;</pre>
 *
 *  <p>The MXML compiler notices that the BackgroundAnimation symbol
 *  in Assets.swf is a movie clip, autogenerates a subclass of the
 *  MovieClipAsset class to represent it, and sets your variable
 *  to be a reference to this autogenerated class.
 *  You can then use this class reference to create instances of the
 *  MovieClipAsset using the <code>new</code> operator, and you can use
 *  APIs of the MovieClip class on them:</p>
 *
 *  <pre>
 *  var backgroundAnimation:MovieClipAsset =
 *      MovieClipAsset(new backgroundAnimationClass());
 *  var n:int = backgroundAnimation.totalFrames;</pre>
 *
 *  <p>However, you rarely need to create MovieClipAsset instances yourself
 *  because image-related properties and styles can be set to an
 *  image-producing class, and components will create instances as necessary.
 *  For example, to set the application background to this animation,
 *  you can simply write the following:</p>
 *
 *  <pre>
 *  &lt;mx:Application backgroundImage="{backgroundAnimationClass}"/&gt;</pre>
 */
public class MovieClipAsset extends FlexMovieClip
							implements IFlexAsset, IFlexDisplayObject
{
	include "../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Constructor
	//
	//--------------------------------------------------------------------------

	/**
	 *  Constructor.
	 */
	public function MovieClipAsset()
	{
		super();

		// Remember initial size as our measured size.
		_measuredWidth = width;
		_measuredHeight = height;
	}

	//--------------------------------------------------------------------------
	//
	//  Properties
	//
	//--------------------------------------------------------------------------

	//----------------------------------
	//  measuredHeight
	//----------------------------------

	/**
	 *  @private
	 *  Storage for the measuredHeight property.
	 */
	private var _measuredHeight:Number;

	/**
	 *  @inheritDoc
	 */
	public function get measuredHeight():Number
	{
		return _measuredHeight;
	}

	//----------------------------------
	//  measuredWidth
	//----------------------------------

	/**
	 *  @private
	 *  Storage for the measuredWidth property.
	 */
	private var _measuredWidth:Number;

	/**
	 *  @inheritDoc
	 */
	public function get measuredWidth():Number
	{
		return _measuredWidth;
	}

	//--------------------------------------------------------------------------
	//
	//  Methods
	//
	//--------------------------------------------------------------------------

	/**
	 *  @inheritDoc
	 */
	public function move(x:Number, y:Number):void
	{
		this.x = x;
		this.y = y;
	}

	/**
	 *  @inheritDoc
	 */
	public function setActualSize(newWidth:Number, newHeight:Number):void
	{
		width = newWidth;
		height = newHeight;
	}
}

}
