////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

/**
 *  The vertical distance in pixels from the lower edge of the component
 *  to the lower edge of its parent container.
 *  If this style is set, the lower edge of the component is
 *  anchored to the bottom edge of its container; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 */
[Style(name="bottom", type="Number", format="Length", inherit="no")]

/**
 *  The horizontal distance in pixels from the center of the component's
 *  parent container to the center of the component.
 *  If this style is set, the center of the component will be
 *  anchored to the center of its container; when its container
 *  is resized, the two centers maintain their horizontal separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 */
[Style(name="horizontalCenter", type="Number", format="Length", inherit="no")]

/**
 *  The horizontal distance in pixels from the left edge of the component's
 *  parent container to the left edge of the component.
 *  If this style is set, the left edge of the component is
 *  anchored to the left edge of its container; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 */
[Style(name="left", type="Number", format="Length", inherit="no")]

/**
 *  The horizontal distance in pixels from the right edge of the component
 *  to the right edge of its parent container.
 *  If this style is set, the right edge of the component is
 *  anchored to the right edge of its container; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 */
[Style(name="right", type="Number", format="Length", inherit="no")]

/**
 *  The vertical distance in pixels from the top edge of the component's
 *  parent container to the top edge of the component.
 *  If this style is set, the top edge of the component is
 *  anchored to the top edge of its container; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 */
[Style(name="top", type="Number", format="Length", inherit="no")]

/**
 *  The vertical distance in pixels from the center of the component's
 *  parent container to the center of the component.
 *  If this style is set, the center of the component is 
 *  anchored to the center of its container; when its container
 *  is resized, the two centers maintain their vertical separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 */
[Style(name="verticalCenter", type="Number", format="Length", inherit="no")]
