'Script to un-install and deactivate previous version of Acrobat present on machine
'To be used as reference script for NUD migration
'Script will check for installed version of Acrobat and uninstall it
'Script will deactivate all Acrobat serialized licenses for Acrobat X and later versions 

wscript.interactive = false
Dim objFSO
Set objFSO = CreateObject("Scripting.FileSystemObject")
set oshell = WScript.CreateObject("WScript.shell")
uninstallFailed=0
set resutltfile = objFSO.CreateTextFile("log.txt", 2)

Set msi = CreateObject("WindowsInstaller.Installer")

UpgradeCodes=Array("{AC76BA86-0000-0000-BA7E-7E8A45000000}","{AC76BA86-0000-0000-7760-7E8A45000000}")

' Acrobat Standard Upgrade Code {AC76BA86-0000-0000-BA7E-7E8A45000000}
' Acrobat Pro Upgrade Code {AC76BA86-0000-0000-7760-7E8A45000000}

For i = 0 to UBound(UpgradeCodes)

	Set productList = msi.RelatedProducts(UpgradeCodes(i))

		for each product in productList

                'Find Product Version
                ProductVersion = msi.ProductInfo(product , "VersionString")
                if ( Err.Number = 0 ) Then
                            resutltfile.writeline ("Found installed Product Version = "+ ProductVersion)
							resutltfile.writeline ( "Un-Installing product")
							ret=oshell.run ("msiexec /x "+product +" /noreboot REBOOT=reallysuppress DISABLE_FIU_CHECK=1 DISABLE_SECONDARY_REPAIR=1 /qn",2,true)
							
							if (ret = 0) then
								resutltfile.writeline ("Product Version "+Cstr(ProductVersion)+ " uninstalled successfully")
							elseif (ret = 3010) then
								
								resutltfile.writeline ("Product Version "+Cstr(ProductVersion)+ " uninstalled successfully but machine reboot required")
							else
								uninstallFailed=1
								resutltfile.writeline ( "Uninstall failed with Error code ("+Cstr(ret)+") returned " )
							end if 
                end if

 
	Next
Next

if (uninstallFailed = 0 ) then
'Starting deactivate previous version
resutltfile.writeline ("Starting deactivate previous version")

scriptPath = Wscript.ScriptFullName
set scriptobj = objFSO.GetFile(scriptPath)
scriptFolder = objFSO.GetParentFolderName(scriptobj)
'Wscript.echo scriptFolder
PRTKPath = objFSO.BuildPath(scriptFolder,"adobe_prtk")

LeidList=Array("AcrobatPro-AS1-Win-GM","AcrobatStd-AS1-Win-GM","V6{}AcrobatPro-AS2-Win-GM","V6{}AcrobatStd-AS2-Win-GM","V7{}AcrobatESR-12-Win-GM","V7{}AcrobatESR-17-Win-GM","V7{}AcrobatETLA-12-Win-GM")
				
For each leid in LeidList
		resutltfile.writeline("Deactivation started for LEID "+leid)
		ret=oshell.run(PRTKPath+"  --tool=UnSerialize --deactivate --force --leid="+leid ,2,true) 
		resutltfile.writeline("return value"+Cstr(ret))
Next

else
	resutltfile.writeline ( "Uninstall failed skipping deactivation " )
end if 