﻿/*
	DigitalFlipbook Source Code License Agreement
	Copyright(c) 2008 Mark Walters. All rights reserved.
		
	Please read this Source Code License Agreement carefully before using
	the source code.
		
	Mark Walters grants to you a perpetual, worldwide, non-exclusive,
	no-charge, royalty-free, irrevocable copyright license, to reproduce,
	prepare derivative works of, publicly display, publicly perform, and
	distribute this source code and such derivative works in source or
	object code form without any attribution requirements.
	
	The names "Mark Walters" and "DigitalFlipbook" must not be used to endorse or promote products
	derived from the source code without prior written permission.
		
	You agree to indemnify, hold harmless and defend Mark Walters from and
	against any loss, damage, claims or lawsuits, including attorney's
	fees that arise or result from your use or distribution of the source
	code.
		
	THIS SOURCE CODE IS PROVIDED "AS IS" AND "WITH ALL FAULTS", WITHOUT
	ANY TECHNICAL SUPPORT OR ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING,
	BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. ALSO, THERE IS NO WARRANTY OF
	NON-INFRINGEMENT, TITLE OR QUIET ENJOYMENT. IN NO EVENT SHALL MARK WALTERS
	OR HIS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
	OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
	WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
	OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOURCE CODE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package com.digitalflipbook.geoglobe
{
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	public class Geocoder extends EventDispatcher
	{
		public static const APP_ID:String = "APP_ID";
		public static const REQUEST_URL:String = "http://local.yahooapis.com/MapsService/V1/geocode";
		
		private var _location:String;
		
		public function Geocoder() {}
		
		public function locate( location:String ):void
		{
			_location = location.toLowerCase();
			var url:String = Geocoder.REQUEST_URL + "?appid=" + Geocoder.APP_ID + "&location=" + escape( _location );
			var request:URLRequest = new URLRequest( url );
			var loader:URLLoader = new URLLoader();
			loader.addEventListener( Event.COMPLETE, completeHandler );
			loader.addEventListener( IOErrorEvent.IO_ERROR, ioErrorHandler );
			loader.load( request );
		}
		
		private function completeHandler( evt:Event ):void
		{
			var latitude:Number;
			var longitude:Number;
			var geocoderEvent:GeocoderEvent;
			var data:XML = new XML( evt.currentTarget.data );
			var yahoomaps:Namespace = new Namespace( "urn:yahoo:maps" );
			var result:XMLList = data.yahoomaps::Result;
			
			if( result.@precision )
			{
				latitude = result.yahoomaps::Latitude.toString();
				longitude = result.yahoomaps::Longitude.toString();
				geocoderEvent = new GeocoderEvent( GeocoderEvent.GEOCODER_SUCCESS, _location, latitude, longitude );
				dispatchEvent( geocoderEvent );
			}
			else
			{
				dispatchEvent( new GeocoderEvent( GeocoderEvent.GEOCODER_UNAVAILABLE ) );
			}
		}
		
		private function ioErrorHandler( evt:IOErrorEvent ):void
		{
			trace( "IOError" );
		}
	}
}